<?php
/*
 * Taille du terrain (longueur et largeur)
 */
define('TAILLE_TERRAIN', 32);

/*
 * Nombre de tours par partie
 */
define('FIN_PARTIE', 200);

/*
 * Nombre maximum de joueurs dans la partie
 */
define('MAX_JOUEURS', 2);

/*
 * Revenu en or par île à chaque tour
 */
define('REVENU_ILE', 5);

/*
 * Revenu en or par volcan à chaque tour
 */
define('REVENU_VOLCAN', 10);

/*
 * Or initialement possédé par chaque joueur
 */
define('OR_INITIAL', 20);

/*
 * Coût de construction d'une Caravelle
 */
define('CARAVELLE_COUT', 15);

/*
 * Coût de construction d'un Galion
 */
define('GALION_COUT', 4);

/*
 * Déplacement de la Caravelle
 */
define('CARAVELLE_DEPLACEMENT', 4);

/*
 * Déplacement du Galion
 */
define('GALION_DEPLACEMENT', 6);

/*
 * Limite du nombre de bateaux pour chaque joueur
 */
define('LIMITE_BATEAUX', 500);

/*
 * Type de bateau
 */
define('BATEAU_CARAVELLE', 0); // Caravelle
define('BATEAU_GALION', 1); // Galion
define('BATEAU_ERREUR', 2); // Bateau inexistant

/*
 * Type de terrain
 */
define('TERRAIN_ILE', 0); // Île
define('TERRAIN_VOLCAN', 1); // Volcan
define('TERRAIN_MER', 2); // Mer
define('TERRAIN_ERREUR', 3); // Erreur, case impossible

/*
 * Erreurs possibles
 */
define('OK', 0); // L'action a été exécutée avec succès
define('OR_INSUFFISANT', 1); // Vous ne possédez pas assez d'or pour cette action
define('ILE_INVALIDE', 2); // La position spécifiée n'est pas une île
define('POSITION_INVALIDE', 3); // La position spécifiée n'est pas valide
define('TROP_LOIN', 4); // La destination est trop éloignée
define('ILE_COLONISEE', 5); // L'île est déjà colonisée
define('ILE_ENNEMIE', 6); // L'île ne vous appartient pas
define('BATEAU_ENNEMI', 7); // Le bateau ne vous appartient pas
define('ID_INVALIDE', 8); // L'ID spécifiée n'est pas valide
define('NON_DEPLACABLE', 9); // Le bateau n'est pas déplaçable
define('AUCUNE_CARAVELLE', 10); // Il n'y a aucune caravelle susceptible de coloniser l'île
define('LIMITE_ATTEINTE', 11); // La limite de bateaux est atteinte

?>
