/*
Description de la stratégie:

Une seule caravelle, entourée de près (du moins en théorie) par des galions en production constante, et qui dirige aussi bien la colonisation que l'attaque et la gestion de l'argent.
Stratégie plus défensive qu'offensive.
*/

#include "prologin.hh"
#include <iostream>
#include <vector>
using namespace std;

///
// Déclarations globales
//
vector<position> iles;
vector<position> volcans;
vector<position> mesIles;
vector<position> mesVolcans;
vector<int> bateaux;
int caravelle;

void deplacement(int id, position dest, int limit);

///
// Fonction appelée au début du Jeu
//
void partie_init()
{
    caravelle = -1;
}

///
// Fonction appelée à chaque tour de Jeu
//
void jouer_tour()
{
    //
    // Bases
    //

    iles.clear();
    volcans.clear();
    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_terrain(liste_iles()[i]) == TERRAIN_ILE) iles.push_back(liste_iles()[i]);
        else volcans.push_back(liste_iles()[i]);
    }

    mesIles.clear();
    mesVolcans.clear();
    for(unsigned int i = 0 ; i < mes_iles().size() ; i++)
    {
        if(info_terrain(mes_iles()[i]) == TERRAIN_ILE) mesIles.push_back(mes_iles()[i]);
        else mesVolcans.push_back(mes_iles()[i]);
    }

    //
    // Construction des bateaux
    //

    if(!bateau_existe(caravelle)) caravelle = -1;

    for(unsigned int i = 0 ; i < mesIles.size() ; i++)
    {
        if(caravelle == -1 && construire(BATEAU_CARAVELLE, mesIles[i]) == OK)
        {
            bateaux.push_back(id_dernier_bateau_construit());
            caravelle = id_dernier_bateau_construit();
        }

        while(caravelle != -1 && construire(BATEAU_GALION, mesIles[i]) == OK)
            bateaux.push_back(id_dernier_bateau_construit());
    }

    //
    // Conquêtes
    //

    position pos;
    pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y; // Position de la caravelle
    int effectif = liste_id_bateaux_position(info_bateau(caravelle).pos).size()-1; // Nombre de galions sur la même case

    // Île la plus proche

    int min_dist = -1, ilePlusProche = -1;
    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_ile_joueur(liste_iles()[i]) == mon_joueur()) continue;
        int tmp = distance(info_bateau(caravelle).pos, liste_iles()[i]);
        if(info_terrain(liste_iles()[i]) == TERRAIN_VOLCAN) tmp /= 1.5;
        if(min_dist == -1 || tmp < min_dist)
        {
            min_dist = tmp;
            ilePlusProche = i;
        }
    }

    // Ennemi le plus dangereux (i.e. ayant le plus de galions sur sa case)

    int max_danger = -1;
    position meilleurEnnemi;
    for(int i = 0 ; i < TAILLE_TERRAIN ; i++)
    {
        for(int j = 0 ; j < TAILLE_TERRAIN ; j++)
        {
            position cell;
            cell.x = j, cell.y = i;
            vector<bateau> bateauxCase = liste_bateaux_position(cell);
            if(bateauxCase.empty()) continue;
            if(bateauxCase[0].joueur == mon_joueur()) continue;
            int nbBateaux = bateauxCase.size();
            if(nbBateaux >= effectif) continue;
            if(max_danger == -1 || nbBateaux > max_danger)
            {
                max_danger = nbBateaux;
                meilleurEnnemi.x = cell.x, meilleurEnnemi.y = cell.y;
            }
        }
    }

    // Choix

    if(ilePlusProche == -1 && max_danger == -1) // Si on ne dispose d'aucun des deux
    {
        // On transfère l'argent produit par les volcans

        if(info_bateau(caravelle).nb_or < 50) // Aller
        {
            int max_or = -1, id = -1;
            for(unsigned int i = 0 ; i < mesVolcans.size() ; i++)
            {
                int tmp = info_ile_or(mesVolcans[i]);
                if(max_or == -1 || tmp > max_or)
                {
                    max_or = tmp;
                    id = i;
                }
            }

            if(id != -1)
                deplacement(caravelle, mesVolcans[id], CARAVELLE_DEPLACEMENT);

            position pos;
            pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y;
            if(info_terrain(pos) == TERRAIN_VOLCAN && info_ile_joueur(pos) == mon_joueur())
                charger(caravelle, info_ile_or(mesVolcans[id]));
        }
        else // Retour
        {
            int min_dist = -1, id = -1;
            for(unsigned int i = 0 ; i < mesIles.size() ; i++)
            {
                int tmp = distance(info_bateau(caravelle).pos, mesIles[i]);
                if(min_dist == -1 || tmp < min_dist)
                {
                    min_dist = tmp;
                    id = i;
                }
            }

            if(id != -1)
                deplacement(caravelle, mesIles[id], CARAVELLE_DEPLACEMENT);

            position pos;
            pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y;
            if(info_terrain(pos) == TERRAIN_ILE && info_ile_joueur(pos) == mon_joueur())
                decharger(caravelle, info_bateau(caravelle).nb_or);
        }
    }
    else if(max_danger == -1) // Pas d'ennemi
        deplacement(caravelle, liste_iles()[ilePlusProche], CARAVELLE_DEPLACEMENT);
    else if(ilePlusProche == -1) // Pas d'île...
        deplacement(caravelle, meilleurEnnemi, CARAVELLE_DEPLACEMENT);
    else // Sinon le plus proche (j'avais aussi pensé à un rand()%2...)
    {
        if(distance(pos, liste_iles()[ilePlusProche]) < distance(pos, meilleurEnnemi))
            deplacement(caravelle, liste_iles()[ilePlusProche], CARAVELLE_DEPLACEMENT);
        else
            deplacement(caravelle, meilleurEnnemi, CARAVELLE_DEPLACEMENT);
    }

    //
    // Regroupement des unités
    //

    for(unsigned int i = 0 ; i < bateaux.size() ; i++)
    {
        if(!bateau_existe(bateaux[i]) || bateaux[i] == caravelle) continue;
        deplacement(bateaux[i], info_bateau(caravelle).pos, GALION_DEPLACEMENT);
    }

    //
    // Colonisation de la terre actuelle
    //

    pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y;
    if(info_terrain(pos) == TERRAIN_ILE || info_terrain(pos) == TERRAIN_VOLCAN)
        coloniser(pos);
}

///
// Fonction appelée à la fin du Jeu
//
void partie_fin()
{

}

///
// Autres fonctions
//
void deplacement(int id, position dest, int limit)
{
    if(distance(info_bateau(id).pos, dest) <= limit)
        deplacer(id, dest);
    else
    {
        position bateau;
        bateau.x = info_bateau(id).pos.x, bateau.y = info_bateau(id).pos.y;
        while(distance(bateau, dest) > limit)
        {
            if(abs(bateau.x - dest.x) > abs(bateau.y - dest.y))
            {
                if(dest.x > bateau.x) dest.x--;
                else dest.x++;
            }
            else
            {
                if(dest.y > bateau.y) dest.y--;
                else dest.y++;
            }
        }
        deplacer(id, dest);
    }
}

