 #include "prologin.hh"
#include <iostream>
#include <vector>
using namespace std;

///
// Déclarations globales
//
vector<position> iles;
vector<position> volcans;
vector<position> mesIles;
vector<position> mesVolcans;
vector<int> bateaux;
int caravelle;

void deplacement(int id, position dest, int limit);

///
// Fonction appelée au début du Jeu
//
void partie_init()
{
    caravelle = -1;
}

///
// Fonction appelée à chaque tour de Jeu
//
void jouer_tour()
{
    //
    // Bases
    //

    iles.clear();
    volcans.clear();
    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_terrain(liste_iles()[i]) == TERRAIN_ILE) iles.push_back(liste_iles()[i]);
        else volcans.push_back(liste_iles()[i]);
    }

    mesIles.clear();
    mesVolcans.clear();
    for(unsigned int i = 0 ; i < mes_iles().size() ; i++)
    {
        if(info_terrain(mes_iles()[i]) == TERRAIN_ILE) mesIles.push_back(mes_iles()[i]);
        else mesVolcans.push_back(mes_iles()[i]);
    }

    //
    // Construction des bateaux
    //

    for(unsigned int i = 0 ; i < mesIles.size() ; i++)
    {
        if(caravelle == -1 && construire(BATEAU_CARAVELLE, mesIles[i]) == OK)
        {
            bateaux.push_back(id_dernier_bateau_construit());
            caravelle = id_dernier_bateau_construit();
        }

        while(caravelle != -1 && construire(BATEAU_GALION, mesIles[i]) == OK)
            bateaux.push_back(id_dernier_bateau_construit());
    }

    //
    // Conquêtes
    //

    int min_dist = -1, id = -1;
    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_ile_joueur(liste_iles()[i]) == mon_joueur()) continue;
        int tmp = distance(info_bateau(caravelle).pos, liste_iles()[i]);
        if(min_dist == -1 || tmp < min_dist)
        {
            min_dist = tmp;
            id = i;
        }
    }

    if(id != -1) deplacement(caravelle, liste_iles()[id], CARAVELLE_DEPLACEMENT);

    position pos;
    pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y;
    if(info_terrain(pos) == TERRAIN_ILE || info_terrain(pos) == TERRAIN_VOLCAN)
        coloniser(pos);

    //
    // Transferts
    //

    if(tour_actuel() <= 10 && info_bateau(caravelle).deplacable)
    {
        if(info_bateau(caravelle).nb_or < 50) // Aller
        {
            int max_or = -1, id = -1;
            for(unsigned int i = 0 ; i < mesVolcans.size() ; i++)
            {
                int tmp = info_ile_or(mesVolcans[i]);
                if(max_or == -1 || tmp > max_or)
                {
                    max_or = tmp;
                    id = i;
                }
            }

            if(id != -1)
                deplacement(caravelle, mesVolcans[id], CARAVELLE_DEPLACEMENT);

            position pos;
            pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y;
            if(info_terrain(pos) == TERRAIN_VOLCAN && info_ile_joueur(pos) == mon_joueur())
                charger(caravelle, info_ile_or(mesVolcans[id]));
        }
        else // Retour
        {
            int min_dist = -1, id = -1;
            for(unsigned int i = 0 ; i < mesIles.size() ; i++)
            {
                int tmp = distance(info_bateau(caravelle).pos, mesIles[i]);
                if(min_dist == -1 || tmp < min_dist)
                {
                    min_dist = tmp;
                    id = i;
                }
            }

            if(id != -1)
                deplacement(caravelle, mesIles[id], CARAVELLE_DEPLACEMENT);

            position pos;
            pos.x = info_bateau(caravelle).pos.x, pos.y = info_bateau(caravelle).pos.y;
            if(info_terrain(pos) == TERRAIN_ILE && info_ile_joueur(pos) == mon_joueur())
                decharger(caravelle, info_bateau(caravelle).nb_or);
        }
    }

    //
    // Unification
    //

    for(unsigned int i = 0 ; i < bateaux.size() ; i++)
    {
        if(!bateau_existe(i) || i == caravelle) continue;
        if(info_bateau(i).btype == BATEAU_GALION)
            deplacement(i, info_bateau(caravelle).pos, GALION_DEPLACEMENT);
        else
            deplacement(i, info_bateau(caravelle).pos, CARAVELLE_DEPLACEMENT);
    }
}

///
// Fonction appelée à la fin du Jeu
//
void partie_fin()
{

}

///
// Autres fonctions
//
void deplacement(int id, position dest, int limit)
{
    if(distance(info_bateau(id).pos, dest) <= limit)
        deplacer(id, dest);
    else
    {
        position bateau;
        bateau.x = info_bateau(id).pos.x, bateau.y = info_bateau(id).pos.y;
        while(distance(bateau, dest) > limit)
        {
            if(abs(bateau.x - dest.x) > abs(bateau.y - dest.y))
            {
                if(dest.x > bateau.x) dest.x--;
                else dest.x++;
            }
            else
            {
                if(dest.y > bateau.y) dest.y--;
                else dest.y++;
            }
        }
        deplacer(id, dest);
    }
}

