#include "prologin.hh"
#include <iostream>
#include <vector>
using namespace std;

///
// Déclarations globales
//
vector<position> iles;
vector<position> volcans;
vector<position> mesIles;
vector<position> mesVolcans;
vector<position> sesIles;
vector<int> caravelle;
int nbCaravelles;
int nbGalions;

void deplacement(int id, position dest);

///
// Fonction appelée au début du Jeu
//
void partie_init()
{
    nbCaravelles = 0;
    nbGalions = 0;
}

///
// Fonction appelée à chaque tour de Jeu
//
void jouer_tour()
{
    ///////////////////
    //    GENERAL    //
    ///////////////////

    // Bases

    iles.clear();
    volcans.clear();
    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_terrain(liste_iles()[i]) == TERRAIN_ILE) iles.push_back(liste_iles()[i]);
        else volcans.push_back(liste_iles()[i]);
    }

    mesIles.clear();
    mesVolcans.clear();
    for(unsigned int i = 0 ; i < mes_iles().size() ; i++)
    {
        if(info_terrain(mes_iles()[i]) == TERRAIN_ILE) mesIles.push_back(mes_iles()[i]);
        else mesVolcans.push_back(mes_iles()[i]);
    }
    
    sesIles.clear();
    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_terrain(liste_iles()[i]) == TERRAIN_ILE && info_ile_joueur(liste_iles()[i])) sesIles.push_back(liste_iles()[i]);
    }

    caravelle.resize(mesIles.size(), -1);

    // Construction des bateaux

    for(unsigned int i = 0 ; i < mesIles.size() ; i++)
    {
        if(caravelle[i] == -1) // Construction de la première caravelle
        {
            if(construire(BATEAU_CARAVELLE, mesIles[i]) == OK)
            {
                caravelle[i] = id_dernier_bateau_construit();
                nbCaravelles++;
            }
        }
        
        if(caravelle[i] != -1)
        {
            while(nbGalions < LIMITE_BATEAUX-50)
            {
                if(construire(BATEAU_GALION, mesIles[i]) == OK)
                {
                    //mesGalions.push_back(id_dernier_bateau_construit());
                    nbGalions++;
                }
                else break;
            }
        }
    }

    //////////////////////
    //    CARAVELLES    //
    //////////////////////

    //// CONQUÊTES

    for(unsigned int i = 0 ; i < mesIles.size() ; i++)
    {
        if(caravelle[i] == -1) continue;

        int min_dist = -1, id = -1;
        for(unsigned int j = 0 ; j < liste_iles().size() ; j++)
        {
            if(info_ile_joueur(liste_iles()[j]) != -1) continue;
            int tmp = distance(info_bateau(caravelle[i]).pos, liste_iles()[j]);
            if(info_terrain(liste_iles()[j]) == TERRAIN_VOLCAN) tmp /= 2;
            if(min_dist == -1 || tmp < min_dist)
            {
                min_dist = tmp;
                id = j;
            }
        }

        if(id != -1)
            deplacement(caravelle[i], liste_iles()[id]);

        position pos;
        pos.x = info_bateau(caravelle[i]).pos.x, pos.y = info_bateau(caravelle[i]).pos.y;
        if((info_terrain(pos) == TERRAIN_ILE || info_terrain(pos) == TERRAIN_VOLCAN) && info_ile_joueur(pos) == -1)
            coloniser(pos);
    }

    //// TRANSFERTS DE VOLCANS

    if(tour_actuel() <= 42)
    {
        for(unsigned int i = 0 ; i < mesIles.size() ; i++)
        {
            if(caravelle[i] == -1) continue;
            if(!info_bateau(caravelle[i]).deplacable) continue;

            if(info_bateau(caravelle[i]).nb_or < 50) // Aller
            {
                int max_or = -1, id = -1;
                for(unsigned int j = 0 ; j < mesVolcans.size() ; j++)
                {
                    int tmp = info_ile_or(mesVolcans[j]);
                    if(max_or == -1 || tmp > max_or)
                    {
                        max_or = tmp;
                        id = j;
                    }
                }

                if(id != -1)
                    deplacement(caravelle[i], mesVolcans[id]);

                position pos;
                pos.x = info_bateau(caravelle[i]).pos.x, pos.y = info_bateau(caravelle[i]).pos.y;
                if(info_terrain(pos) == TERRAIN_VOLCAN && info_ile_joueur(pos) == mon_joueur())
                    charger(caravelle[i], info_ile_or(mesVolcans[id]));
            }
            else // Retour
            {
                int min_dist = -1, id = -1;
                for(unsigned int j = 0 ; j < mesIles.size() ; j++)
                {
                    int tmp = distance(info_bateau(caravelle[i]).pos, mesIles[j]);
                    if(min_dist == -1 || tmp < min_dist)
                    {
                        min_dist = tmp;
                        id = j;
                    }
                }

                if(id != -1)
                    deplacement(caravelle[i], mesIles[id]);

                position pos;
                pos.x = info_bateau(caravelle[i]).pos.x, pos.y = info_bateau(caravelle[i]).pos.y;
                if(info_terrain(pos) == TERRAIN_ILE && info_ile_joueur(pos) == mon_joueur())
                    decharger(caravelle[i], info_bateau(caravelle[i]).nb_or);
            }
        }
    }

    //// ATTAQUE

    else
    {
        for(unsigned int i = 0 ; i < mesIles.size() ; i++)
        {
            position pos;
            pos.x = info_bateau(caravelle[i]).pos.x, pos.y = info_bateau(caravelle[i]).pos.y;
            if(!(info_terrain(pos) == TERRAIN_ILE && info_ile_joueur(pos) == adversaire()))
            {
                int cible = rand()%sesIles.size();
                deplacement(caravelle[i], sesIles[cible]);
            }
        }
    }

    ///////////////////
    //    GALIONS    //
    ///////////////////

    // Déplacement des galions

                        /*int nbGalionsParCaravelle = nbGalions/nbCaravelles, c;
                        for(unsigned int i = 0, j = 0 ; i < mesIles.size() ; i++)
                        {
                            for(c = 0 ; c < nbGalionsParCaravelle && j < mesGalions.size() ; c++, j++)
                                deplacement(mesGalions[j], info_bateau(caravelle[i]).pos);
                        }*/
    
    
}

///
// Fonction appelée à la fin du Jeu
//
void partie_fin()
{

}

///
// Autres fonctions
//
void deplacement(int id, position dest)
{
    if(distance(info_bateau(id).pos, dest) <= CARAVELLE_DEPLACEMENT)
        deplacer(id, dest);
    else
    {
        position bateau;
        bateau.x = info_bateau(id).pos.x, bateau.y = info_bateau(id).pos.y;
        while(distance(bateau, dest) > CARAVELLE_DEPLACEMENT)
        {
            if(abs(bateau.x - dest.x) > abs(bateau.y - dest.y))
            {
                if(dest.x > bateau.x) dest.x--;
                else dest.x++;
            }
            else
            {
                if(dest.y > bateau.y) dest.y--;
                else dest.y++;
            }
        }
        deplacer(id, dest);
    }
}

