(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(*
** Taille de la banquise (longueur et largeur).
*)
let taille_banquise = 25

(*
** Nombre de tours à jouer avant la fin de la partie.
*)
let nb_tours = 100

(*
** Nombre de points d'action par tour par agent.
*)
let nb_points_action = 8

(*
** Nombre de point d'action que coûte un déplacement.
*)
let cout_deplacement = 1

(*
** Nombre de points d'action que coûte une glissade.
*)
let cout_glissade = 3

(*
** Nombre de points d'action nécessaires pour pousser un agent.
*)
let cout_pousser = 5

(*
** Nombre d'agents par joueur.
*)
let nb_agents = 4

(*
** Nombre de tours nécessaires pour capturer un alien.
*)
let nb_tours_capture = 3

(*
** Types de cases
*)
type case_type =
| Libre (* <- Case libre *)
| Mur (* <- Mur *)
| Erreur (* <- Erreur *)


(*
** Points cardinaux
*)
type direction =
| Nord (* <- Direction : nord *)
| Est (* <- Direction : est *)
| Sud (* <- Direction : sud *)
| Ouest (* <- Direction : ouest *)


(*
** Erreurs possibles
*)
type erreur =
| Ok (* <- L'action s'est effectuée avec succès. *)
| Pa_insuffisants (* <- Votre agent ne possède pas assez de points d'action pour réaliser cette action. *)
| Position_invalide (* <- La position spécifiée n'est pas sur la banquise. *)
| Obstacle_mur (* <- La position spécifiée est un mur. *)
| Obstacle_agent (* <- La position spécifiée est un agent. *)
| Deplacement_hors_limites (* <- Ce déplacement fait sortir un agent des limites de la banquise. *)
| Direction_invalide (* <- La direction spécifiée n'existe pas. *)
| Id_agent_invalide (* <- L'agent spécifié n'existe pas. *)
| Rien_a_pousser (* <- Aucun agent à pousser dans la direction indiquée. *)
| Drapeau_invalide (* <- Le drapeau spécifié n'existe pas. *)


(*
** Types d'actions
*)
type action_type =
| Action_deplacer (* <- Action ``deplacer`` *)
| Action_glisser (* <- Action ``glisser`` *)
| Action_pousser (* <- Action ``pousser`` *)


(*
** Types de drapeaux de débug
*)
type debug_drapeau =
| Aucun_drapeau (* <- Aucun drapeau, enlève le drapeau présent *)
| Drapeau_bleu (* <- Drapeau bleu *)
| Drapeau_vert (* <- Drapeau vert *)
| Drapeau_rouge (* <- Drapeau rouge *)


(*
** Position sur la banquise, donnée par deux coordonnées.
*)
type position = (int * int)

(*
** Alien à capturer durant la mission.
*)
type alien_info = {
  pos : position ; (* <- Position de l'alien *)
  points_capture : int ; (* <- Nombre de points obtenus pour la capture de cet alien *)
  tour_invasion : int ; (* <- Tour où l'alien débarque sur la banquise *)
  duree_invasion : int ; (* <- Nombre de tours où l'alien reste sur la banquise *)
  capture_en_cours : int ; (* <- Nombre de tours de la capture en cours, l'alien est considéré comme capturé si la variable atteint NB_TOURS_CAPTURE *)
}

(*
** Action de déplacement représentée dans l'historique.
*)
type action_hist = {
  atype : action_type ; (* <- Type de l'action *)
  id_agent : int ; (* <- Numéro de l'agent concerné par l'action *)
  dir : direction ; (* <- Direction visée par l'agent durant le déplacement *)
}

(*
** Déplace l'agent ``id_agent`` d'une case dans la direction choisie.
*)
external deplacer : int -> direction -> erreur = "ml_deplacer"
(*
** Propulse l'agent ``id_agent`` dans la direction choisie jusqu'à ce qu'il heurte un obstacle, c'est-à-dire soit un mur soit un autre agent.
*)
external glisser : int -> direction -> erreur = "ml_glisser"
(*
** L'agent ``id_agent`` pousse tout autre agent se trouvant sur la case adjacente dans la direction indiquée. Ce dernier est propulsé jusqu'à ce qu'il rencontre un obstacle, c'est-à-dire soit un mur soit un autre agent.
*)
external pousser : int -> direction -> erreur = "ml_pousser"
(*
** Affiche le drapeau spécifié sur la case indiquée.
*)
external debug_afficher_drapeau : position -> debug_drapeau -> erreur = "ml_debug_afficher_drapeau"
(*
** Renvoie le nombre de points d'action de l'agent ``id_agent`` restants pour le tour. Si le numéro d'agent est invalide, la fonction renvoie -1.
*)
external points_action_agent : int -> int = "ml_points_action_agent"
(*
** Renvoie le plus court chemin entre deux positions de la banquise sous la forme d'une suite de direction à emprunter. Ce chemin ne contient pas de glissade, uniquement des déplacements simples. Si la position est invalide ou que le chemin n'existe pas, le chemin renvoyé est vide.
*)
external chemin : position -> position -> direction array = "ml_chemin"
(*
** Renvoie le type d'une case donnée.
*)
external type_case : position -> case_type = "ml_type_case"
(*
** Renvoie le numéro du joueur à qui appartient l'agent sur la case indiquée. Renvoie -1 s'il n'y a pas d'agent ou si la position est invalide.
*)
external agent_sur_case : position -> int = "ml_agent_sur_case"
(*
** Indique si un alien se trouve sur une case donnée. Renvoie vrai si l'alien est en train d'envahir la banquise et qu'il n'a pas encore été capturé. Renvoie faux autremement, ou si la position est invalide.
*)
external alien_sur_case : position -> bool = "ml_alien_sur_case"
(*
** Indique la position de l'agent sur la banquise désigné par le numéro ``id_agent`` appartenant au joueur ``id_joueur``. Si la description de l'agent est incorrecte, la position (-1, -1) est renvoyée.
*)
external position_agent : int -> int -> position = "ml_position_agent"
(*
** Renvoie la description d'un alien en fonction d'une position donnée. Si l'alien n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``alien_info`` renvoyée sont initialisés à -1.
*)
external info_alien : position -> alien_info = "ml_info_alien"
(*
** Renvoie la liste de tous les aliens présents durant la partie.
*)
external liste_aliens : unit -> alien_info array = "ml_liste_aliens"
(*
** Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
*)
external historique : unit -> action_hist array = "ml_historique"
(*
** Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
*)
external score : int -> int = "ml_score"
(*
** Renvoie votre numéro de joueur.
*)
external moi : unit -> int = "ml_moi"
(*
** Renvoie le numéro de joueur de votre adversaire.
*)
external adversaire : unit -> int = "ml_adversaire"
(*
** Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour-ci.
*)
external annuler : unit -> bool = "ml_annuler"
(*
** Retourne le numéro du tour actuel.
*)
external tour_actuel : unit -> int = "ml_tour_actuel"
(*
** Affiche le contenu d'une valeur de type case_type
*)
external afficher_case_type : case_type -> unit = "ml_afficher_case_type"
(*
** Affiche le contenu d'une valeur de type direction
*)
external afficher_direction : direction -> unit = "ml_afficher_direction"
(*
** Affiche le contenu d'une valeur de type erreur
*)
external afficher_erreur : erreur -> unit = "ml_afficher_erreur"
(*
** Affiche le contenu d'une valeur de type action_type
*)
external afficher_action_type : action_type -> unit = "ml_afficher_action_type"
(*
** Affiche le contenu d'une valeur de type debug_drapeau
*)
external afficher_debug_drapeau : debug_drapeau -> unit = "ml_afficher_debug_drapeau"
(*
** Affiche le contenu d'une valeur de type position
*)
external afficher_position : position -> unit = "ml_afficher_position"
(*
** Affiche le contenu d'une valeur de type alien_info
*)
external afficher_alien_info : alien_info -> unit = "ml_afficher_alien_info"
(*
** Affiche le contenu d'une valeur de type action_hist
*)
external afficher_action_hist : action_hist -> unit = "ml_afficher_action_hist"
