#include <algorithm>
#include <iostream>

#include "prologin.hh"
#include "duel.hh"
#include "pathfinding.hh"

using namespace std;

// EFFECTUER UN TIR SUR UNE CASE VULNERABLE DE L'ADVERSAIRE
bool shoot()
{
    vector<vector<int>> influence = dijkstra(aretesBases(base_ennemie()), tuyauxSeulement, tuyauxLong);
    int plusGrand = 10000;
    position vulnerable;
    for (int x = 0; x < TAILLE_TERRAIN; ++x) {
        for (int y = 0; y < TAILLE_TERRAIN; ++y) {
            if (est_tuyau(makePos(x, y)) && influence[x][y] < plusGrand && influence[x][y] != -1) {
                vulnerable = makePos(x, y);
                plusGrand = influence[x][y];
            }
        }
    }
    if (plusGrand != 10000) {
        return detruire(vulnerable) == OK;
    }
    return false;
}

// AMELIORER NOS TUYAUX PROCHES DE LA BASE
void renforcer() {
    vector<vector<int>> monControl = getInfluence();
    vector<position> candidats;
    for (int x = 0; x < TAILLE_TERRAIN; ++x)
        for (int y = 0; y < TAILLE_TERRAIN; ++y)
            if (monControl[x][y] >= 0 && !est_super_tuyau(makePos(x, y)))
                candidats.push_back(makePos(x, y));
    sort(begin(candidats), end(candidats), [&](position a, position b){ return  monControl[a.x][a.y] > monControl[b.x][b.y];});
    for (const auto& pos : candidats)
        if ((pos.x+pos.y)%2 == 0)
            ameliorer(pos);
}
