#include <iostream>

#include "prologin.hh"
#include "pathfinding.hh"

using namespace std;
void partie_init()
{ }

int d1(position a, position b)
{
    return abs(a.x - b.x) + abs(a.y - b.y);
}

double puissanceMoyenne(position pulsar) {
    pulsar_info info = info_pulsar(pulsar);
    return double(info.puissance)/double(info.periode);
}

void jouer_tour()
{
    vector<position> pulsars = liste_pulsars();
    while (points_action() >= COUT_CONSTRUCTION) {
        vector<vector<int>> poids = dijkstra(ma_base(), reseauConnexe);
        vector<position> adjacent;
        for (int x = 0; x < TAILLE_TERRAIN; ++x)
            for (int y = 0; y < TAILLE_TERRAIN; ++y)
                if (poids[x][y] == 1 && type_case(makePos(x,y)) == VIDE)
                    adjacent.push_back(makePos(x,y));
        double meilleurScore = 0.0;
        position meilleurPotentiel;
        for (const auto& potentiel: adjacent) {
            double score = 0.0;
            for (const auto& pulsar: pulsars)
                score += puissanceMoyenne(pulsar)/d1(potentiel, pulsar);
            if (score > meilleurScore) {
                meilleurScore = score;
                meilleurPotentiel = potentiel;
            }
        }
        construire(meilleurPotentiel);
    }
}

void partie_fin()
{ }

