#include <queue>

#include "pathfinding.hh"

using namespace std; 

position makePos(int x, int y) {
    position pos;
    pos.x = x;
    pos.y = y;
    return pos;
}

vector<position> neighbours(position pos) {
    int x = pos.x;
    int y = pos.y;
    vector<position> cases = {makePos(x+1,y), makePos(x-1,y), makePos(x,y+1), makePos(x,y-1)};
    return cases;
}

bool correct(position pos) {
    if (pos.x < 0 || pos.y < 0 || pos.x >= TAILLE_TERRAIN || pos.y >= TAILLE_TERRAIN)
        return false;
    return type_case(pos) == VIDE || type_case(pos) == TUYAU;
}

int reseauConnexe(position dest, Edge current) {
    if (type_case(dest) == TUYAU)
        return current.weight;
    return current.weight+1;
}

vector<vector<int>> dijkstra(const vector<position>& departs, function<int (position, Edge)> poids) {
    const int neverSeen = -1;
    vector<vector<int>> weights(TAILLE_TERRAIN, vector<int>(TAILLE_TERRAIN, neverSeen));
    priority_queue<Edge> waiting;
    for (const auto& pos : departs)
        waiting.push(Edge(pos, 0));
    while (!waiting.empty()) {
        Edge current = waiting.top();
        waiting.pop();
        if (weights[current.pos.x][current.pos.y] != neverSeen)
            continue ;
        weights[current.pos.x][current.pos.y] = current.weight;
        for (const auto& neighbor : neighbours(current.pos))
            if (correct(neighbor) && weights[neighbor.x][neighbor.y] == neverSeen)
                waiting.push(Edge(neighbor, poids(neighbor, current)));
    }
    return weights;
}
