#ifndef PATHFINDING_HH
#define PATHFINDING_HH

#include <functional>
#include <vector>

#include "prologin.hh"

struct Edge {
  Edge(position _pos, int _weight):pos(_pos),weight(_weight){}
  bool operator<(const Edge& other) const {
      return weight > other.weight;
  }
  position pos;
  int weight;
};

struct Pulsar {
    Pulsar(position _site, position _pulsar):site(_site),pulsar(_pulsar){}
    double puissanceMoyenne() const;
    double puissanceTotale() const;
    position site;
    position pulsar;
};

position makePos(int, int);
position departTuyau(position);
std::vector<position> neighbours(position);
int d1(position, position);

std::vector<Pulsar> pulsarsVivants();
std::vector<Pulsar> pulsarsLibres();
double puissanceMoyenne(position);

bool inside(position);
bool toutChemins(position);
int reseauEtTrous(position, Edge);
bool tuyauxSeulement(position);
int tuyauxLong(position, Edge);
int poidsBFS(position, Edge);

std::vector<Edge> aretesBases(std::vector<position>);
std::vector<Edge> poidsUniforme(std::vector<position>, int);

std::vector<std::vector<int>> dijkstra(const std::vector<Edge>&, std::function<bool (position)>, std::function<int (position, Edge)>);

std::vector<std::vector<int>> difference(std::vector<std::vector<int>>, std::vector<std::vector<int>>);
std::vector<std::vector<int>> getInfluence();
std::vector<std::vector<int>> getPretentions();
std::vector<std::vector<int>> getCandidates();
std::vector<Pulsar> selectCandidates();
void choisirItineraire();
std::vector<position> retrouverChemin(std::vector<std::vector<int>>, position arrive);
std::vector<position> dfs(std::vector<std::vector<int>>&, position, position);

void debugGrille(std::vector<std::vector<int>>);
void debugTableau(std::vector<position>);

#endif
