///////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////// README //////////////////////////////////////////////////////////////////////
/*//////                                                                                    ///////////
////////    * Heuristique choisissant un mouvement a chaque tour grace a une                ///////////
////////    fonction d'evaluation calculant :                                               ///////////
////////    1) son gain espere apres une prise                                              ///////////
////////    2) points perdus par l'adversaire                                               ///////////
////////    3) Malus distance/bouclier (leger)                                              ///////////
////////    * Place des boucliers selon la proximite de l'adversaire, et selon              ///////////
////////    l'importance du noeud pour moi et pour l'adversaire,                            ///////////
////////    et selon l'agressivite                                                          ///////////
////////    * Adapte son aggressivite selon l'avantage qu'il possede sur la situation       ///////////
////////    * Composante aleatoire pour contrer les cycles ou les defauts de la fonction    ///////////
////////    d'evaluation                                                                    ///////////
*//////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////


#include <algorithm>
#include <cmath>
#include <iterator>
#include <random>
#include <vector>

#include "prologin.hh"

const int PAS_PORTAIL = -2;
const int PERSONNE = -1;
const int INFINI = 1000*1000;
const int LONGUEUR_MOYENNE = 19.0;
double violence = 0.5;
int precedMoi = 0;
int precedAdversaire = 0;
int scoreSommet(position);
int evaluer(position);
int nbPortails;
std::random_device rd;
std::mt19937 gen(rd());
std::uniform_real_distribution<> dis(0, 1);
std::binomial_distribution<> gauss(1, 0.3);

position make_position(int x, int y)
{
    position obj;
    obj.x = x;
    obj.y = y;
    return obj;
}

bool operator==(position left, position right)
{
    return (left.x == right.x && left.y == right.y);
}

bool operator!=(position left, position right)
{
    return !(left == right);
}

lien make_lien(position extr1, position extr2, int joueur = -1)
{
    lien obj;
    obj.extr1 = extr1;
    obj.extr2 = extr2;
    obj.joueur_l = joueur;
    return obj;
}

int longueurTrajet(position portail)
{
    return distance(position_agent(moi()), portail);
}

template<typename T>
position meilleurVoisin(T predicat)
{
    std::vector<position> portails = liste_portails();
    position meilleur = make_position(INFINI, INFINI);
    position alternative = make_position(INFINI, INFINI);
    int poidsMeilleur = -INFINI;
    for (auto portail : portails)
    {
        if (!predicat(portail))
            continue;
        int poidsCourant = evaluer(portail);
        if (poidsMeilleur < poidsCourant)
        {
            poidsMeilleur = poidsCourant;
            meilleur = portail;
            if (dis(gen) < 0.5)
                alternative = meilleur;
        }
    }
    if (dis(gen) < 0.7 || alternative == make_position(INFINI, INFINI))
        return meilleur;
    return alternative;
}

int signe(int a)
{
    if (a < 0)
        return -1;
    return 1;
}

void voyage(position destination)
{
    if (longueurTrajet(destination) <= points_deplacement())
        deplacer(destination);
    else 
    {
        int deltaX = destination.x - position_agent(moi()).x;
        int deltaY = destination.y - position_agent(moi()).y;
        int x1 = std::min(position_agent(moi()).x+deltaX, position_agent(moi()).x);
        int x2 = std::max(position_agent(moi()).x+deltaX, position_agent(moi()).x);
        int y1 = std::min(position_agent(moi()).y+deltaY, position_agent(moi()).y);
        int y2 = std::max(position_agent(moi()).y+deltaY, position_agent(moi()).y);
        position ile = meilleurVoisin([=](position portail){
                                      return portail.x >= x1 &&
                                             portail.x <= x2 &&
                                             portail.y >= y1 &&
                                             portail.y <= y2 &&
                                             longueurTrajet(portail) != 0 &&
                                             longueurTrajet(portail) < points_deplacement();});
        if (ile != make_position(INFINI, INFINI))
            deplacer(ile);
        else
        {
            int dX = std::min(abs(deltaX), points_deplacement())*signe(deltaX);
            deplacer(make_position(position_agent(moi()).x+dX, position_agent(moi()).y));
            int dY = std::min(abs(deltaY), points_deplacement())*signe(deltaY);
            deplacer(make_position(position_agent(moi()).x, position_agent(moi()).y+dY));
        }
    }

}

bool lienCorrect(position origine, position extr2)
{
    std::vector<lien> liens = liens_bloquants(origine, extr2);
    int total = liens.size();
    for (auto lien : liens)
        if (lien.extr1 == origine || lien.extr2 == origine)
            total -= 1;
    return total == 0;
}

void trierTriangles(position origine, std::vector<lien>& triangles)
{
    std::sort(begin(triangles), end(triangles), 
              [=](lien triangle1, lien triangle2) {
                 return score_triangle(origine, 
                                       triangle1.extr1, 
                                       triangle1.extr2)
                      > score_triangle(origine, 
                                       triangle2.extr1,
                                       triangle2.extr2);
              });
}

std::vector<lien> trianglesPotentiels(int joueur, position origine)
{
    std::vector<lien> triangles;
    std::vector<position> portails = liste_portails();
    for(auto extr1 : portails)
    {
        if (portail_joueur(extr1) != joueur
         || !lienCorrect(origine, extr1))
            continue ;
        std::vector<lien> voisins = liens_incidents_portail(extr1);
        for (auto voisin : voisins)
        {
            position extr2 = (voisin.extr1 == extr1)? voisin.extr2 : voisin.extr1;
            if (lienCorrect(origine, extr2))
            {
                triangles.push_back(make_lien(extr1, extr2));
            }
        }
    }
    return triangles;
}

int gainPotentiel(int joueur, position origine)
{
    std::vector<lien> triangles = trianglesPotentiels(joueur, origine);
    int somme = 0;
    std::for_each(begin(triangles), end(triangles), 
                  [&](lien triangle) {
                     somme += score_triangle(origine, 
                                             triangle.extr1, 
                                             triangle.extr2);
                  });
    return somme;
}

int scoreSommet(position portail)
{
    std::vector<champ> champs = champs_incidents_portail(portail);
    int somme = 0;
    for (auto aire : champs)
        somme += score_triangle(aire.som1, aire.som2, aire.som3);
    return somme;
}

int longueurCumulee(position portail)
{
    std::vector<lien> liens = liens_incidents_portail(portail);
    int somme = 0;
    std::for_each(begin(liens), end(liens), [&](lien l){somme+=distance(l.extr1,l.extr2);});
    return somme;
}

int evaluer(position portail)
{
    int poids = 0;
    int delta = longueurTrajet(portail) - points_deplacement();
    if (delta > 0)
        poids += -delta*COUT_TURBO;
    if (portail_joueur(portail) != moi())
        poids += gainPotentiel(moi(), portail);
    if (portail_joueur(portail) == adversaire())
    {
        int score = scoreSommet(portail);
        int longueur = longueurCumulee(portail);
        poids += score;
        poids += (longueur*longueur)*0.5;
        poids -= (10 + portail_boucliers(portail)*COUT_BOUCLIER);
    }
    return poids;
}

void poserLiensTriangles()
{
    std::vector<lien> triangles = trianglesPotentiels(moi(), position_agent(moi()));
    trierTriangles(position_agent(moi()), triangles);
    for (auto triangle : triangles)
    {
        lier(triangle.extr1);
        lier(triangle.extr2);
    }
}

void poserLiensSimples()
{
    std::vector<position> portails = liste_portails();
    std::sort(begin(portails), 
              end(portails), 
              [](position left, position right){
                 return longueurTrajet(left) > longueurTrajet(right);
              });
    for (auto portail : portails)
        lier(portail);
}

void poserLiens()
{
    poserLiensTriangles();
    poserLiensSimples();
}

double quartile(int joueur, double score)
{
    std::vector<position> portails = liste_portails();
    std::vector<position> portailsJoueur;
    std::copy_if(begin(portails), end(portails),  std::back_inserter(portailsJoueur),
                 [=](position portail){return portail_joueur(portail) == joueur;});
    if (portailsJoueur.empty())
        return 1.0;
    int nbDessous = 0;
    for (auto portail : portailsJoueur)
        if (scoreSommet(portail) < score)
            ++nbDessous;
    return double(nbDessous+1)/double(portailsJoueur.size());
}

void proteger()
{
    double importanceMoi = quartile(moi(), scoreSommet(position_agent(moi())));
    double importanceAdversaire = quartile(adversaire(), gainPotentiel(adversaire(), position_agent(moi())));
    double proximite = 2. - distance(position_agent(moi()), position_agent(adversaire()))/double(LONGUEUR_MOYENNE) ;
    double strategique = importanceMoi + importanceAdversaire*(0.5 + violence);
    int quantite = std::min(MAX_BOUCLIERS, int(1 + proximite + strategique * 2));
    int manquant = std::max(0, quantite - portail_boucliers(position_agent(moi())));
    for (;manquant > 0; --manquant)
        ajouter_bouclier();
}

void traiterPortail(position portail)
{
    if (portail_joueur(position_agent(moi())) == adversaire())
        neutraliser();
    if (portail_joueur(position_agent(moi())) == PERSONNE)
        capturer();
    if (portail_joueur(position_agent(moi())) == moi())
    {
        poserLiens();
        proteger();
    }
}

void comportement()
{
    int aireMoi = std::max(score(moi()) - precedMoi, 1); // division by 0 protection
    int aireAdversaire = score(adversaire()) - precedAdversaire;
    violence = 0.5*(1 - (aireMoi-aireAdversaire)/double(std::max(aireMoi, aireAdversaire)));
    violence *= gauss(gen);
    precedAdversaire = score(adversaire());
    precedMoi = score(moi());
}

void jouer_tour()
{
    comportement();
    int precedPA = points_action();
    int precedPM = points_deplacement();
    while (points_deplacement() > 0)
    {
        if (portail_joueur(position_agent(moi())) != PAS_PORTAIL)
            traiterPortail(position_agent(moi()));
        position voisin = meilleurVoisin([](position portail){return portail_joueur(portail)!=moi();});
        voyage(voisin);
        if (portail_joueur(position_agent(moi())) != PAS_PORTAIL)
        {
            traiterPortail(position_agent(moi()));
            if (portail_joueur(position_agent(moi())) != moi())
                return ;
        }
        if (points_deplacement() == 0 && points_action() >= COUT_TURBO)
            utiliser_turbo();
        if (precedPA == points_action() && precedPM == points_deplacement())
        {
            while (ajouter_bouclier() == OK) ;
            return ;
        }
        precedPA = points_action();
        precedPM = points_deplacement();
   }
}

//////////////////////////////////////////////
////////////// DEPRECATE /////////////////////
//////////////////////////////////////////////

std::vector<lien> trianglesFiltres(position origine, std::vector<lien>& triangles)
{
    std::vector<lien> trianglesCorrects;
    std::copy_if(begin(triangles), end(triangles), 
                 std::back_inserter(trianglesCorrects), 
                 [=](lien triangle) {
                    return lienCorrect(origine, triangle.extr1)
                        && lienCorrect(origine, triangle.extr2);
                });
    return trianglesCorrects;
}

//////////////////////////////////////////////
/////////////// USELESS //////////////////////
//////////////////////////////////////////////

void partie_init()
{ 
    nbPortails = liste_portails().size();
}

void partie_fin()
{ }

