#include <algorithm>
#include <cmath>
#include <vector>

#include "prologin.hh"

const int PAS_PORTAIL = -2;
const int PERSONNE = -1;
const int INFINI = 1000*1000;
double defense = 2;
double aggressivite = 2;
int precedMoi = 0;
int precedAdversaire = 0;
int scoreSommet(position);
int nbPortails;

position make_position(int x, int y)
{
    position obj;
    obj.x = x;
    obj.y = y;
    return obj;
}

bool operator==(position left, position right)
{
    return (left.x == right.x && left.y == right.y);
}

lien make_lien(position extr1, position extr2, int joueur = -1)
{
    lien obj;
    obj.extr1 = extr1;
    obj.extr2 = extr2;
    obj.joueur_l = joueur;
    return obj;
}

int longueurTrajet(position portail)
{
    return distance(position_agent(moi()), portail);
}

int longueurCumulee(position portail)
{
    std::vector<lien> liens = liens_incidents_portail(portail);
    int somme = 0;
    std::for_each(begin(liens), end(liens), [&](lien l){somme+=distance(l.extr1,l.extr2);});
    return somme;
}

int cout(position portail)
{
    int coutPA = 0;
    if (portail_joueur(portail) == adversaire())
    {
        coutPA += (10 + 5*portail_boucliers(portail))*0.5;
        coutPA -= scoreSommet(portail)*aggressivite*0.1;
        coutPA -= longueurCumulee(portail)*sqrt(aggressivite)*0.1;
    }
    if (longueurTrajet(portail) > points_deplacement())
        coutPA += (longueurTrajet(portail) - points_deplacement())*COUT_TURBO;
    if (case_dans_champ(portail) && portail_joueur(portail) != adversaire())
        coutPA = int(coutPA * 1.5);
    return coutPA;
}

position plusProchePortail()
{
    std::vector<position> portails = liste_portails();
    position meilleur = make_position(INFINI, INFINI);
    int coutMeilleur = INFINI;
    for (auto portail : portails)
    {
        if (portail_joueur(portail) != moi())
        {
            int coutCourant = cout(portail);
            if (coutMeilleur > coutCourant)
            {
                coutMeilleur = coutCourant;
                meilleur = portail;
            }
        }
    }
    return meilleur;
}

void voyage(position destination)
{
    int deltaX = std::min(abs(destination.x - position_agent(moi()).x), 
                          points_deplacement());
    int deltaY = std::min(abs(destination.y - position_agent(moi()).y), 
                          points_deplacement()-deltaX);
    if (destination.x < position_agent(moi()).x)
        deltaX *= (-1);
    if (destination.y < position_agent(moi()).y)
        deltaY *= (-1);
    deplacer(make_position(position_agent(moi()).x+deltaX, 
                           position_agent(moi()).y+deltaY));
}

bool lienCorrect(position extr1, position extr2)
{
    return liens_bloquants(extr1, extr2).empty();
}

std::vector<lien> genererTriangles()
{
    std::vector<lien> triangles;
    std::vector<position> portails = liste_portails();
    for(auto extr1 : portails)
    {
        if (portail_joueur(extr1) != moi()
         || !lienCorrect(position_agent(moi()), extr1))
            continue ;
        std::vector<lien> voisins = liens_incidents_portail(extr1);
        for (auto voisin : voisins)
        {
            position extr2 = (voisin.extr1 == extr1)? voisin.extr2 : voisin.extr1;
            if (lienCorrect(position_agent(moi()), extr2))
            {
                triangles.push_back(make_lien(extr1, extr2));
            }
        }
    }
    return triangles;
}

void poserLiensTriangles()
{
    std::vector<lien> triangles = genererTriangles();
    std::sort(begin(triangles), 
              end(triangles), 
              [](lien triangle1, lien triangle2) {
                 return score_triangle(position_agent(moi()), 
                                       triangle1.extr1, 
                                       triangle1.extr2)
                      > score_triangle(position_agent(moi()), 
                                       triangle2.extr1,
                                       triangle2.extr2);
              });
    for (auto triangle : triangles)
    {
        if (lienCorrect(position_agent(moi()), triangle.extr1)
         && lienCorrect(position_agent(moi()), triangle.extr2))
        {
            lier(triangle.extr1);
            lier(triangle.extr2);
        }
    }
}

void poserLiensSimples()
{
    std::vector<position> portails = liste_portails();
    std::sort(begin(portails), 
              end(portails), 
              [](position left, position right){
                 return longueurTrajet(left) < longueurTrajet(right);
              });
    for (auto portail : portails)
        lier(portail);
}

void poserLiens()
{
    poserLiensTriangles();
    poserLiensSimples();
}

int scoreSommet(position portail)
{
    std::vector<champ> champs = champs_incidents_portail(portail);
    int somme = 0;
    for (auto aire : champs)
        somme += score_triangle(aire.som1, aire.som2, aire.som3);
    return somme;
}

double moyenneScore()
{
    std::vector<position> portails = liste_portails();
    int total = 0;
    for (auto portail : portails)
        if (portail_joueur(portail) == moi())
            total += scoreSommet(portail);
    return double(total)/double(portails.size());
}

void proteger()
{
    double menace = 1.0 - distance(position_agent(moi()), position_agent(adversaire()))/double(2*TAILLE_TERRAIN);
    double importance = scoreSommet(position_agent(moi()))/moyenneScore() + 0.5;
    int quantite = int(menace*menace*defense) + 1 + int(importance*defense);
    int manquant = std::max(0, quantite - portail_boucliers(position_agent(moi())));
    for (;manquant > 0; --manquant)
        ajouter_bouclier();
}

void traiterPortail(position portail)
{
    if (portail_joueur(position_agent(moi())) == adversaire())
        neutraliser();
    if (portail_joueur(position_agent(moi())) == PERSONNE)
        capturer();
    if (portail_joueur(position_agent(moi())) == moi())
    {
        poserLiens();
        proteger();
    }
}

void comportement()
{
    int aireMoi = score(moi()) - precedMoi;
    int aireAdversaire = score(adversaire()) - precedAdversaire;
    aggressivite = 0.5*(1 - (aireMoi-aireAdversaire)/double(std::max(aireMoi, aireAdversaire)));
    defense = 6. * (1 - aggressivite);
    precedMoi = score(moi());
    precedAdversaire = score(adversaire()); 
}

void jouer_tour()
{
    comportement();
    int precedPA = points_action();
    int precedPM = points_deplacement();
    while (points_deplacement() > 0)
    {
        if (portail_joueur(position_agent(moi())) != PAS_PORTAIL)
            traiterPortail(position_agent(moi()));
        position voisin = plusProchePortail();
        voyage(voisin);
        if (portail_joueur(position_agent(moi())) != PAS_PORTAIL)
            traiterPortail(position_agent(moi()));
        if (points_deplacement() == 0 && points_action() >= COUT_TURBO)
            utiliser_turbo();
        if (precedPA == points_action() && precedPM == points_deplacement())
        {
            while (ajouter_bouclier() == OK) ;
            return ;
        }
        precedPA = points_action();
        precedPM = points_deplacement();
   }
}

//////////////////////////////////////////////
/////////////// USELESS //////////////////////
//////////////////////////////////////////////

void partie_init()
{ 
    nbPortails = liste_portails().size();
}

void partie_fin()
{ }

