#include <algorithm>
#include <list>
#include <queue>
#include <vector>

#include "prologin.hh"
#include "deplacement.hh"
#include "tirs.hh"

using namespace std;

Cible::Cible(){}
Cible::Cible(int _hash, int _nb_sorciers) : hash(_hash), nb_sorciers(_nb_sorciers){}
bool Cible::operator<(const Cible& other) const
{
  return (nb_sorciers < other.nb_sorciers);
}

void choisir_tirs(vector<tourelle> tourelles)
{
  // Etabli la liste des adversaires a portee et des tours les menacant
  list<int> menaces[TAILLE_TERRAIN*TAILLE_TERRAIN];
  priority_queue<Cible> aTuer;
  for (int Tourelle = 0; Tourelle < (int)tourelles.size(); ++Tourelle)
  {
    vector<Cible> cibles = BFS_Tourelles(tourelles[Tourelle]);
    for (auto& cible : cibles)
    {
      if (menaces[cible.hash].empty())
	aTuer.push(cible);
      menaces[cible.hash].push_back(Tourelle);
    }
  } 
  
  // Supprime les ennemis jusqu'a supression des ennemis ou des tourelles
  while (!aTuer.empty())
  {
    Cible cible = aTuer.top();
    aTuer.pop();
    list<int>::iterator choisi = choisirTourelle(tourelles, menaces[cible.hash]);
    if (choisi != menaces[cible.hash].end())
    {
      // Calcule les degats
      int degats = min(cible.nb_sorciers, tourelles[*choisi].attaque);
      if (!aTuer.empty())
	degats = min(cible.nb_sorciers - aTuer.top().nb_sorciers + 1, tourelles[*choisi].attaque);
      
      // Realise l'attaque
      tourelles[*choisi].attaque -= degats;
      cible.nb_sorciers -= degats;
      tirer(degats, tourelles[*choisi].pos, Position(cible.hash));
      
      // Supprime ou conserve
      if (cible.nb_sorciers > 0)
	aTuer.push(cible);
    }
  }
}

// Renvoie un iterateur sur le premier element valide, en supprimant les invalides
list<int>::iterator choisirTourelle(const vector<tourelle>& tourelles, list<int>& candidats)
{
  for (list<int>::iterator it = candidats.begin(); it != candidats.end(); )
    if (tourelles[*it].attaque <= 0)
      it = candidats.erase(it);
    else
      ++it;
  return candidats.begin();
}

// Renvoie la liste des adversaires atteignables par la tour
vector<Cible> BFS_Tourelles(tourelle depart)
{
  vector<Cible> cibles;
  vector<int> profondeur(TAILLE_TERRAIN*TAILLE_TERRAIN, -1);
  queue<position> file;
  file.push(depart.pos);
  profondeur[hasher(depart.pos)] = 0;
  while (!file.empty())
  {
    position pos = file.front();
    file.pop();
    if (joueur_case(pos) != moi())
      cibles.push_back(Cible(hasher(pos), nb_sorciers(pos, joueur_case(pos))));
    if (profondeur[hasher(pos)] < depart.portee)
    {
      for (int dir = 0; dir < nbDirections; ++dir)
      {
	position nPos;
	nPos.x = pos.x + dirs[dir][0];
	nPos.y = pos.y + dirs[dir][1];
	if (correct(nPos) && profondeur[hasher(nPos)] == -1)
	{
	  file.push(nPos);
	  profondeur[hasher(nPos)] = profondeur[hasher(pos)] + 1;
	}
      }
    }
  }
  return cibles;
}

void assiegerAdjacents(position centre)
{
  vector<Cible> cibles;
  for (int dir = 0; dir < nbDirections; ++dir)
  {
    position nPos = centre;
    nPos.x += dirs[dir][0];
    nPos.y += dirs[dir][1];
    if (correct(nPos) && info_case(nPos) == CASE_TOURELLE && tourelle_case(nPos).joueur != moi())
      cibles.push_back(Cible(hasher(nPos), tourelle_case(nPos).vie));
  }
  int cur = 0;
  int sorciersDispo = nb_sorciers(centre, moi());
  sort(cibles.begin(), cibles.end());
  while (sorciersDispo > 0 && cur < (int)cibles.size())
  {
    int effectif = min(cibles[cur].nb_sorciers, sorciersDispo);
    assieger(centre, Position(cibles[cur].hash), effectif);
    ++cur;
  }
}