#include <vector>

#include "construction.hh"
#include "prologin.hh"
#include "deplacement.hh" 

using namespace std;

const int nbDirections = 4;
int dirs[4][2] = {{0, 1}, {0, -1}, {1, 0}, {-1, 0}};
position objectif = Position(0, 0);
int tentatives[TAILLE_TERRAIN*TAILLE_TERRAIN];
int total = 0;

bool operator==(const position& m1, const position& m2)
{
  return (m1.x == m2.x && m1.y == m2.y);
}

bool operator!=(const position& m1, const position& m2)
{
  return !(m1 == m2);
}

position Position(int hash)
{
  return Position(hash%TAILLE_TERRAIN, hash/TAILLE_TERRAIN);
}

position Position(int x, int y)
{
  position retour;
  retour.x = x;
  retour.y = y;
  return retour;
}

int hasher(position pos)
{
  return pos.y*TAILLE_TERRAIN + pos.x;
}

void determinerEtat()
{
  if (joueur_case(objectif) == moi())
    tentatives[hasher(objectif)] = 0;
  else
    ++tentatives[hasher(objectif)];
  if (tentatives[hasher(objectif)] > 10)
    tentatives[hasher(objectif)] = -10;
  
  position controlee = fontaineControlee();
  if (controlee != base_joueur(moi()))
  {
    if (tour_actuel() >= 90)
    {
      objectif = Position(15, 15);
    }
    else
    {
      objectif = choisirBase(controlee);
    }
    return ;
  }
  
  objectif = fontaineProtegee();
}

position fontaineControlee()
{
  for (int fontaine = 0; fontaine < nbFontaines; ++fontaine)
    if (joueur_case(fontaines[fontaine]) == moi())
      return fontaines[fontaine];
  return base_joueur(moi());
}
 
position fontaineProtegee()
{
  int defaut = 0;
  int plusCourt = TAILLE_TERRAIN+TAILLE_TERRAIN;
  vector<tourelle> tourelles = tourelles_joueur(moi());
  for (auto& Tourelle : tourelles)
  {
    for (int fontaine = 0; fontaine < nbFontaines; ++fontaine)
    {
      if (manhattan(fontaines[fontaine], Tourelle.pos) <= Tourelle.portee)
      {
	return fontaines[fontaine];
      }
      if (manhattan(fontaines[fontaine], Tourelle.pos) < plusCourt)
      {
	defaut = fontaine;
	plusCourt = manhattan(fontaines[fontaine], Tourelle.pos);
      }
    }
  }
  return fontaines[defaut];
}

position choisirBase(position controlee)
{
  position pos = base_joueur(moi());
  int plusCourt = TAILLE_TERRAIN+TAILLE_TERRAIN;
  for (int fontaine = 0; fontaine < nbFontaines; ++fontaine)
  {
    if (joueur_case(fontaines[fontaine]) != moi() && manhattan(fontaines[fontaine], base_joueur(moi())) < plusCourt)
    {
      if (tentatives[hasher(fontaines[fontaine])] < 0)
	tentatives[hasher(fontaines[fontaine])] += 1;
      else 
      {
	plusCourt = manhattan(fontaines[fontaine], base_joueur(moi()));
	pos = fontaines[fontaine];
      }
    }
  }
  
  vector<int> idAdversaires = adversaires();
  for (int adversaire = 0; adversaire < (int)idAdversaires.size(); ++adversaire)
  {
    if (manhattan(base_joueur(idAdversaires[adversaire]), controlee) < plusCourt)
    {
      if (tentatives[hasher(base_joueur(idAdversaires[adversaire]))] < 0)
	tentatives[hasher(base_joueur(idAdversaires[adversaire]))] += 1;
      else
      {
	plusCourt = manhattan(base_joueur(idAdversaires[adversaire]), controlee);
	pos = base_joueur(idAdversaires[adversaire]);
      }
    }
  }
  return pos;
}

void deplacerUnites()
{/*
  for (int x = 0; x < TAILLE_TERRAIN; ++x)
  {
    for (int y = 0; y < TAILLE_TERRAIN; ++y)
    {
      total += nb_sorciers_deplacables(Position(x, y), moi());
    }
  }
  */
  for (int x = 0; x < TAILLE_TERRAIN; ++x)
  {
    for (int y = 0; y < TAILLE_TERRAIN; ++y)
    {
      if (joueur_case(Position(x, y)) == moi() && nb_sorciers(Position(x, y), moi()) > 0)
	bouger(Position(x, y));
    }
  }
}

void bouger(position depart)
{
  // Defense de la base
  int effectif = nb_sorciers_deplacables(depart, moi());
  if (depart == base_joueur(moi()))
    effectif -= max(necessaire, 0);
  
  // Ne pas bouger ceux sur les fontaines
  for (int fontaine = 0; fontaine < nbFontaines; ++fontaine)
    if (fontaines[fontaine] == depart)
      return ;
  
  vector<position> route = chemin(depart, objectif);
  if (route.empty())
    return ;
  int limite = min(PORTEE_SORCIER, (int)route.size()) - 1;
  total = nb_sorciers_deplacables(route[limite], moi());
  if (joueur_case(objectif) != moi() 
   && total < nb_sorciers_deplacables(objectif, joueur_case(objectif)))
    return ;
  deplacer(depart, route[limite], effectif);
}