#include <algorithm>
#include <cstdio>
#include <map>
#include <queue>
#include <vector>

#include "deplacement.hh"
#include "construction.hh"
#include "prologin.hh"

using namespace std;

struct plusLoin
{
  plusLoin(){}
  plusLoin(position _pos) : pos(_pos){}
  position pos;
  bool operator()(const tourelle& m1, const tourelle& m2) const
  {
    return manhattan(m1.pos, pos) > manhattan(m2.pos, pos);
  }
};

const int nbFontaines = 4;
position fontaines[4];
int necessaire;

void choix()
{
  // save or die
  necessaire = evaluerMenace(base_joueur(moi())) - nb_sorciers(base_joueur(moi()), moi());
  if (necessaire >= 1)
  {
   if (magie(moi())/COUT_SORCIER < necessaire)
     salvateur(necessaire - magie(moi())/COUT_SORCIER, base_joueur(moi()));
   creer(min(necessaire, magie(moi())/COUT_SORCIER));
  }
  
  // placer les tours sur les cases appropriees
  if (tour_actuel() < 90)
  {
    Potentiel meilleur = BFS_Tourelles(tourelles_joueur(moi()));
    if (tourelles_joueur(moi()).size() < 9 && correct(meilleur.pos))
    {
      if (meilleur.cout <= magie(moi()))
	construire(meilleur.pos, meilleur.longueur);
      else
	return ;
    }
  }
  
  if (tour_actuel() == 90)
    vider();
  if (tour_actuel() == 91)
    barricader();
  
  if (tour_actuel() <= 90)
  {
    menage();
    creer(magie(moi())/COUT_SORCIER);
  }
}

void salvateur(int quantite, position pos)
{
  vector<tourelle> tourelles = tourelles_joueur(moi());
  sort(tourelles.begin(), tourelles.end(), plusLoin(pos));
  int cur = 0;
  while (quantite > 0 && cur < (int)tourelles.size())
  {
    supprimer(tourelles[cur].pos);
    quantite -= MAGIE_SUPPRESSION;
    ++cur;
  }
}

int evaluerMenace(position depart)
{
  int pire = 0;
  map<int, int> joueurs;
  vector<int> profondeur(TAILLE_TERRAIN*TAILLE_TERRAIN, -1);
  queue<position> file;
  file.push(depart);
  profondeur[hasher(depart)] = 0;
  while (!file.empty())
  {
    position pos = file.front();
    file.pop();
    if (joueur_case(pos) != moi())
    {
      joueurs[joueur_case(pos)] += nb_sorciers(pos, joueur_case(pos));
      pire = max(pire, joueurs[joueur_case(pos)]);
    }
    if (profondeur[hasher(pos)] < PORTEE_SORCIER)
    {
      for (int dir = 0; dir < nbDirections; ++dir)
      {
	position nPos;
	nPos.x = pos.x + dirs[dir][0];
	nPos.y = pos.y + dirs[dir][1];
	if (correct(nPos) && profondeur[hasher(nPos)] == -1)
	{
	  file.push(nPos);
	  profondeur[hasher(nPos)] = profondeur[hasher(pos)] + 1;
	}
      }
    }
  }
  
  return pire;
}

Potentiel BFS_Tourelles(const vector<tourelle>& departs)
{
  Potentiel meilleur; 
  meilleur.longueur = TAILLE_TERRAIN+TAILLE_TERRAIN;
  meilleur.pos = Position(-1, -1);
  meilleur.cout = COUT_TOURELLE;
  vector<int> profondeur(TAILLE_TERRAIN*TAILLE_TERRAIN, -1);
  profondeur[hasher(base_joueur(moi()))] = 0;
  queue<position> file;
  file.push(base_joueur(moi()));
  for (int depart = 0; depart < (int)departs.size(); ++depart)
  {
    file.push(departs[depart].pos);
    profondeur[hasher(departs[depart].pos)] = 0;
  }
  while (!file.empty())
  {
    position pos = file.front();
    file.pop();
    if (constructible(pos, moi()))
    {
      Potentiel nouveau;
      nouveau.pos = pos;
      nouveau.longueur = TAILLE_TERRAIN+TAILLE_TERRAIN;
      for (int fontaine = 0; fontaine < nbFontaines; ++fontaine)
	if (block(pos, fontaines[fontaine]))
	  goto aretes;
	else
	  nouveau.longueur = min(nouveau.longueur, manhattan(pos, fontaines[fontaine]));
      
      nouveau.cout = 0;
      if (nouveau.longueur > 3 && nouveau.longueur <= 7)
	nouveau.cout = COUT_PORTEE + (nouveau.longueur-3)*(nouveau.longueur-3);
      
      if (nouveau.longueur < meilleur.longueur)
	  meilleur = nouveau;
    }
    aretes: ;
    if (profondeur[hasher(pos)] < CONSTRUCTION_TOURELLE)
    {
      for (int dir = 0; dir < nbDirections; ++dir)
      {
	position nPos;
	nPos.x = pos.x + dirs[dir][0];
	nPos.y = pos.y + dirs[dir][1];
	if (correct(nPos) && profondeur[hasher(nPos)] == -1)
	{
	  file.push(nPos);
	  profondeur[hasher(nPos)] = profondeur[hasher(nPos)] + 1;
	}
      }
    }
  }
  meilleur.cout += COUT_TOURELLE;
  if (meilleur.longueur > 7 || meilleur.longueur < 3)
    meilleur.longueur = 3;
  return meilleur;
}

bool block(position nouveau, position fontaine)
{
  if (fontaine.x == 15)
  {
    int minY = min(fontaine.y, 15);
    int maxY = max(fontaine.y, 15);
    return (nouveau.x == 15 && minY <= nouveau.y && maxY >= nouveau.y);
  }
  else
  {
    int minX = min(fontaine.x, 15);
    int maxX = max(fontaine.x, 15);
    return (nouveau.y == 15 && minX <= nouveau.x && maxX >= nouveau.x);
  }
}

void menage()
{
  vector<tourelle> tourelles = tourelles_joueur(moi());
  vector<int> voisins(tourelles.size());
  vector<bool> atteint(nbFontaines, false);
  int cur = 0;
  for (auto& Tourelle : tourelles)
  {
    int longueurMin = TAILLE_TERRAIN+TAILLE_TERRAIN;
    for (int fontaine = 0; fontaine < nbFontaines; ++fontaine)
    {
      if (manhattan(Tourelle.pos, fontaines[fontaine]) < longueurMin)
      {
	longueurMin = manhattan(Tourelle.pos, fontaines[fontaine]);
	voisins[cur] = fontaine;
      }
      if (manhattan(Tourelle.pos, fontaines[fontaine]) <= Tourelle.portee)
	atteint[fontaine] = true;
    }
    ++cur;
  }
  
  cur = 0;
  for (auto& Tourelle : tourelles)
  {
    if (manhattan(Tourelle.pos, fontaines[voisins[cur]]) > Tourelle.portee && atteint[voisins[cur]])
	supprimer(Tourelle.pos);
    ++cur;
  }
}

void vider()
{
  vector<tourelle> tourelles = tourelles_joueur(moi());
  for (auto& Tourelle : tourelles)
  {
    supprimer(Tourelle.pos);
  }
}

void barricader()
{
  vector<int> profondeur(TAILLE_TERRAIN*TAILLE_TERRAIN, -1);
  profondeur[hasher(base_joueur(moi()))] = 0;
  queue<position> file;
  file.push(base_joueur(moi()));
  vector<tourelle> departs = tourelles_joueur(moi());
  for (int depart = 0; depart < (int)departs.size(); ++depart)
  {
    file.push(departs[depart].pos);
    profondeur[hasher(departs[depart].pos)] = 0;
  }
  while (!file.empty())
  {
    position pos = file.front();
    file.pop();
    if (constructible(pos, moi()))
    {
      construire(pos, PORTEE_TOURELLE);
    }
    if (profondeur[hasher(pos)] < CONSTRUCTION_TOURELLE)
    {
      for (int dir = 0; dir < nbDirections; ++dir)
      {
	position nPos;
	nPos.x = pos.x + dirs[dir][0];
	nPos.y = pos.y + dirs[dir][1];
	if (correct(nPos) && profondeur[hasher(nPos)] == -1)
	{
	  file.push(nPos);
	  profondeur[hasher(nPos)] = profondeur[hasher(nPos)] + 1;
	}
      }
    }
  }
}