/*
  README:
    Depuis toute ile que je possede je cherche a atteindre l'ile la plus proche qui ne mappartient pas.
    Si l'ile en question est inoccupee j'envoie une caravelle, sinon des galions.
    L'attaque n'est effectuee que si le nombre de galions est suffisant.
    Plusieurs iles peuvent fournir des galions pour une meme cible.
    Les caravelles font des allers-retours entre les volcans et l'ile la plus proche.
*/

#include <algorithm>
#include <cstdlib>
#include <cstdio>

#include "prologin.hh"

struct Ile
{
  Ile() {}
  Ile(position _pos, terrain _type) : type(_type)
  {
    x = _pos.x;
    y = _pos.y;
  }

  terrain type;
  int x;
  int y;
};

struct Chemin
{
  Chemin()
  {}
  
  Chemin(int _indice, int _longueur) : indice(_indice), longueur(_longueur)
  {}
  
  int indice;
  int longueur;
  
  bool operator<(const Chemin & autre) const
  {
    return (longueur < autre.longueur);
  }
};

// Iles et attaquants
std::vector<Ile> iles;
std::vector<int> nbEnnemis;
std::vector<int> cible;
std::vector<bool> colonisable;
std::vector<std::vector<int>> disponibles;

// IDs des bateaux et objectifs militaires
std::vector<int> bateaux;
std::vector<int> missions;
std::vector<bateau_type> types;

// Liaisons entre les iles
std::vector<std::vector<Chemin>> distances;
std::vector<bool> dejaTriee;

void lireIles(); // Ok
void distancesIles(); // Ok
void MaJ_Iles(); // Ok
void MaJ_Bateaux(); // Ok
void colonisationGlobale(); // Ok
void colonisation(int); // Ok
void productionGlobale(); // Ok
void actualiser(int, int);
void production(int); // Ok
int fabriquerBateau(bateau_type, int, int); // Ok
void envoyer(int, int); // Ok
void MaJ_Ennemis(); // Ok
int nombreTypeBateau(int, int, bateau_type); // Ok
void lancerAttaqueGlobale(); // Ok
void lancerAttaque(); // Ok
position joindre(position, position, int); // Ok

// Ok
void partie_init()
{
  lireIles();
  distancesIles();
}
     
// Ok
void jouer_tour()
{
  MaJ_Iles();
  MaJ_Bateaux();
  MaJ_Ennemis();
  colonisationGlobale();
  productionGlobale();
  lancerAttaqueGlobale();
}

// Ok
void partie_fin()
{}

// Correct
position Position(int x, int y)
{
  position pos;
  pos.x = x;
  pos.y = y;
  return pos;
}

//Correct
int signe(int nombre)
{
  if (nombre < 0)
    return -1;
  return 1;
}

// Correct
void lireIles()
{
  for (int y = 0; y < TAILLE_TERRAIN; ++y) 
  {
    for (int x = 0; x < TAILLE_TERRAIN; ++x)
    {
      terrain typeCourant = info_terrain(Position(x, y));
      
      if (typeCourant == TERRAIN_ILE || typeCourant == TERRAIN_VOLCAN)
      {
        iles.push_back(Ile(Position(x, y), typeCourant));
        dejaTriee.push_back(false);
        nbEnnemis.push_back(0);
        cible.push_back(0);
        colonisable.push_back(false);
      }
    }
  }
  disponibles.resize(iles.size());
}

// Correct
void distancesIles()
{
  distances.resize(iles.size());
  for (unsigned int depart = 0; depart < iles.size(); ++depart)
  {
    distances[depart].reserve(iles.size());
    for (unsigned int arrive = 0; arrive < depart; ++arrive)
    {
      int longueur = distance(Position(iles[depart].x, iles[depart].y), Position(iles[arrive].x, iles[arrive].y));
      distances[depart].push_back(Chemin(arrive, longueur));
      distances[arrive].push_back(Chemin(depart, longueur));
    }
  }
}

// Correct
void MaJ_Iles()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    if (info_ile_joueur(Position(iles[ile].x, iles[ile].y)) == mon_joueur())
    {
      cible[ile] = 0;
      colonisable[ile] = false;
    }
  }
}

// Correct
void MaJ_Bateaux()
{
  std::vector<int> anciens = bateaux;
  bateaux.clear();
  std::vector<int> oldsMissions = missions;
  missions.clear();
  std::vector<bateau_type> oldsTypes = types;
  types.clear();
  for (unsigned int bateau = 0; bateau < anciens.size(); ++bateau)
  {
    if (bateau_existe(anciens[bateau]))
    {
      bateaux.push_back(anciens[bateau]);
      missions.push_back(oldsMissions[bateau]);
      types.push_back(oldsTypes[bateau]);
    }
    else if (oldsTypes[bateau] == BATEAU_GALION)
    {
      --cible[oldsMissions[bateau]];
    }
    else
    {
      colonisable[oldsMissions[bateau]] = false;
    }
  }
}

// Correct
void colonisation(int iBateau)
{
  position origine = info_bateau(bateaux[iBateau]).pos;
  position destination = Position(iles[missions[iBateau]].x, iles[missions[iBateau]].y);
  if (info_ile_joueur(destination) == -1)
  {
    position intermediaire = joindre(origine, destination, CARAVELLE_DEPLACEMENT);
    deplacer(bateaux[iBateau], intermediaire);
    
    if (intermediaire.x == destination.x && intermediaire.y == destination.y)
    {
      coloniser(destination);
      if (info_terrain(destination) == TERRAIN_ILE)
      {
        disponibles[missions[iBateau]].push_back(iBateau);
      }
      else
      {
        charger(bateaux[iBateau], info_ile_or(destination));
        for (unsigned int voisin = 0; voisin < distances[missions[iBateau]].size(); ++voisin)
        {
          int iVoisin = distances[missions[iBateau]][voisin].indice;
          position posVoisin = Position(iles[iVoisin].x, iles[iVoisin].y);
          if (iles[iVoisin].type == TERRAIN_ILE && info_ile_joueur(posVoisin) == mon_joueur())
          {
            actualiser(iBateau, iVoisin);
            break;
          }
        }
      }
    }
  }
  if (info_ile_joueur(destination) == mon_joueur())
  {
    decharger(bateaux[iBateau], info_bateau(bateaux[iBateau]).nb_or);
  }
}

// Correct
void colonisationGlobale()
{
  for (unsigned int bateau = 0; bateau < bateaux.size(); ++bateau)
  {
    if (info_bateau(bateaux[bateau]).btype == BATEAU_CARAVELLE)
    {
      colonisation(bateau);
    }
  }
}

// Correct
int fabriquerBateau(bateau_type btype, int x, int y)
{
  construire(btype, Position(x, y));
  return id_dernier_bateau_construit();
}

// Correct
void envoyerGalion(int bateau, int ile)
{
  bateaux.push_back(bateau);
  missions.push_back(ile);
  types.push_back(BATEAU_GALION);
  ++cible[ile];
}

// Correct
void envoyerCaravelle(int bateau, int ile)
{
  bateaux.push_back(bateau);
  missions.push_back(ile);
  types.push_back(BATEAU_CARAVELLE);
  if (!colonisable[ile])
  {
    colonisable[ile] = true;
  }
}

// Correct
void creerArmee(position pos, int ile)
{
  while (nombre_bateaux(mon_joueur()) < LIMITE_BATEAUX && info_ile_or(pos) >= GALION_COUT)
  {
    int dernier = fabriquerBateau(BATEAU_GALION, pos.x, pos.y);
    envoyerGalion(dernier, ile);
  }  
}

void actualiser(int iBateau, int ile)
{
  missions[iBateau] = ile;
  if (!colonisable[ile])
  {
    colonisable[ile] = true;
  }
}

// Correct
void production(int ile)
{
  if (!dejaTriee[ile])
  {
    std::sort(distances[ile].begin(), distances[ile].end());
    dejaTriee[ile] = true;
  }
  
  position ileCourante = Position(iles[ile].x, iles[ile].y);
  
  for (unsigned int voisin = 0; voisin < distances[ile].size(); ++voisin)
  {
    int iVoisin = distances[ile][voisin].indice;
    position posVoisin = Position(iles[iVoisin].x, iles[iVoisin].y);
    
    if (info_ile_joueur(posVoisin) == -1 && !colonisable[iVoisin])
    {
      if (disponibles[ile].size())
      {
        actualiser(disponibles[ile].back(), iVoisin);
        disponibles[ile].pop_back();
        creerArmee(ileCourante, ile);
      }
      else if (info_ile_or(ileCourante) >= CARAVELLE_COUT && nombre_bateaux(mon_joueur()) < LIMITE_BATEAUX)
      {
        int dernier = fabriquerBateau(BATEAU_CARAVELLE, iles[ile].x, iles[ile].y);
        envoyerCaravelle(dernier, iVoisin);
        creerArmee(ileCourante, ile);
      }
      return;
    }
    else if (info_ile_joueur(posVoisin) == adversaire() && cible[iVoisin] <= nbEnnemis[iVoisin])
    {
      creerArmee(ileCourante, iVoisin);
      return;
    }
  }
  
  creerArmee(ileCourante, ile);
}

// Correct
void productionGlobale()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    if (info_ile_joueur(Position(iles[ile].x, iles[ile].y)) == mon_joueur()
     && iles[ile].type == TERRAIN_ILE)
    {
      production(ile);
    }
  }
}

// Correct
int nombreTypeBateau(int ile, int joueur, bateau_type btype)
{
  std::vector<bateau> flotte = liste_bateaux_position(Position(iles[ile].x, iles[ile].y));
  int nbTrouves = 0;
  for (unsigned int bateau = 0; bateau < flotte.size(); ++bateau)
  {
    if (flotte[bateau].joueur == joueur && flotte[bateau].btype == btype)
    {
      ++nbTrouves;
    }
  }
  return nbTrouves;
}

// Correcte
void MaJ_Ennemis()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    if (info_ile_joueur(Position(iles[ile].x, iles[ile].y)) == adversaire())
    {
      nbEnnemis[ile] = nombreTypeBateau(ile, adversaire(), BATEAU_GALION);
    }
  }
}

// Correct
void lancerAttaque(int iBateau)
{
  if (cible[missions[iBateau]] > nbEnnemis[missions[iBateau]] 
   || iles[missions[iBateau]].type == TERRAIN_MER)
  {
    bateau bateauCourant = info_bateau(bateaux[iBateau]);
    int x = iles[missions[iBateau]].x;
    int y = iles[missions[iBateau]].y;
    deplacer(bateaux[iBateau], joindre(bateauCourant.pos, Position(x, y), GALION_DEPLACEMENT));
  }
}

// Correct
void lancerAttaqueGlobale()
{
  for (unsigned int bateau = 0; bateau < bateaux.size(); ++bateau)
  {
    if (info_bateau(bateaux[bateau]).btype == BATEAU_GALION)
    {
      lancerAttaque(bateau);
    }
  }
}

// Correct
position joindre(position depart, position arrive, int longueur)
{
  int deltaX = arrive.x - depart.x;
  int deltaY = arrive.y - depart.y;
  
  int nX = depart.x + std::min(abs(deltaX), longueur)*signe(deltaX);
  longueur -= std::min(abs(deltaX), longueur);
  int nY = depart.y + std::min(abs(deltaY), longueur)*signe(deltaY);
  
  return Position(nX, nY);
}

