#include <algorithm>
#include <cstdlib>
#include <cstdio>

#include "prologin.hh"

#define nDEBUG_INIT
#define nDEBUG_PRODUCTION
#define nDEBUG_DEPLACEMENT

struct Ile
{
  Ile() {}
  Ile(position _pos, terrain _type) : type(_type)
  {
    x = _pos.x;
    y = _pos.y;
  }

  terrain type;
  int x;
  int y;
};

struct Chemin
{
  Chemin()
  {}
  
  Chemin(int _indice, int _longueur) : indice(_indice), longueur(_longueur)
  {}
  
  int indice;
  int longueur;
  
  bool operator<(const Chemin & autre) const
  {
    return (longueur < autre.longueur);
  }
};

// Iles et attaquants
std::vector<Ile> iles;
std::vector<int> nbEnnemis;
std::vector<int> cible;
std::vector<bool> colonisable;

// IDs des bateaux et objectifs militaires
std::vector<int> bateaux;
std::vector<int> missions;

// Liaisons entre les iles
std::vector<std::vector<Chemin>> distances;
std::vector<bool> dejaTriee;

void lireIles(); // Ok
void distancesIles(); // Ok
void MaJ_Iles(); // Ok
void MaJ_Bateaux(); // Ok
void colonisationGlobale(); // Ok
void colonisation(int); // Ok
void productionGlobale(); // Ok
void production(int); // Ok
int fabriquerBateau(bateau_type, int, int); // Ok
void envoyer(int, int); // Ok
void MaJ_Ennemis(); // Ok
void evaluerForcesAdverses(); // Ok
void lancerAttaqueGlobale(); // Ok
void lancerAttaque(); // Ok
position joindre(position, position, int); // Ok

void afficherIles()
{
  if (mon_joueur() != 1)
    return;
  
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    printf("%2u: {%2d;%2d} -> %s\n", ile, iles[ile].x, iles[ile].y, iles[ile].type == TERRAIN_ILE ? "ile" : "volcan");
    fflush(stdout);
  }
}

void afficherDistances()
{
  if (mon_joueur() != 1)
    return;
    
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    printf("Ile : %d\n", ile);
    for (unsigned int voisin = 0; voisin < distances[ile].size(); ++voisin)
    {
      printf("->%d:{%d}\n", distances[ile][voisin].indice, distances[ile][voisin].longueur);
    }
    printf("\n");
  }
}

// Ok
void partie_init()
{
  lireIles();
  distancesIles();
  
  #ifdef DEBUG_INIT
  afficherIles();
  afficherDistances();
  #endif
}
     
// Ok
void jouer_tour()
{
  MaJ_Iles();
  MaJ_Bateaux();
  MaJ_Ennemis();
  colonisationGlobale();
  productionGlobale();
  lancerAttaqueGlobale();
}

// Ok
void partie_fin()
{}

// Correct
position Position(int x, int y)
{
  position pos;
  pos.x = x;
  pos.y = y;
  return pos;
}

//Correct
int signe(int nombre)
{
  if (nombre < 0)
    return -1;
  return 1;
}

// Correct
void lireIles()
{
  for (int y = 0; y < TAILLE_TERRAIN; ++y) 
  {
    for (int x = 0; x < TAILLE_TERRAIN; ++x)
    {
      terrain typeCourant = info_terrain(Position(x, y));
      
      if (typeCourant == TERRAIN_ILE || typeCourant == TERRAIN_VOLCAN)
      {
        iles.push_back(Ile(Position(x, y), typeCourant));
        dejaTriee.push_back(false);
        nbEnnemis.push_back(0);
        cible.push_back(0);
        colonisable.push_back(false);
      }
    }
  }
}

// Correct
void distancesIles()
{
  distances.resize(iles.size());
  for (unsigned int depart = 0; depart < iles.size(); ++depart)
  {
    distances[depart].reserve(iles.size());
    for (unsigned int arrive = 0; arrive < depart; ++arrive)
    {
      int longueur = distance(Position(iles[depart].x, iles[depart].y), Position(iles[arrive].x, iles[arrive].y));
      distances[depart].push_back(Chemin(arrive, longueur));
      distances[arrive].push_back(Chemin(depart, longueur));
    }
  }
}

// Correct
void MaJ_Iles()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    if (info_ile_joueur(Position(iles[ile].x, iles[ile].y)) == mon_joueur())
    {
      cible[ile] = 0;
      colonisable[ile] = false;
    }
  }
}

// Incorrect TODO
void MaJ_Bateaux()
{
  std::vector<int> anciens = bateaux;
  bateaux.clear();
  std::vector<int> oldsMissions = missions;
  missions.clear();
  for (unsigned int bateau = 0; bateau < anciens.size(); ++bateau)
  {
    if (bateau_existe(anciens[bateau]))
    {
      bateaux.push_back(anciens[bateau]);
      missions.push_back(oldsMissions[bateau]);
    }
    else
    {
      --cible[oldsMissions[bateau]];
    }
  }
}

// Correct
void colonisation(int iBateau)
{
  position origine = info_bateau(bateaux[iBateau]).pos;
  position destination = Position(iles[missions[iBateau]].x, iles[missions[iBateau]].y);
  if (info_ile_joueur(destination) == -1)
  {
    position intermediaire = joindre(origine, destination, CARAVELLE_DEPLACEMENT);
    deplacer(bateaux[iBateau], intermediaire);
    
    if (intermediaire.x == destination.x && intermediaire.y == destination.y)
    {
      coloniser(destination);
    }
  }
}

// Correct
void colonisationGlobale()
{
  for (unsigned int bateau = 0; bateau < bateaux.size(); ++bateau)
  {
    if (info_bateau(bateaux[bateau]).btype == BATEAU_CARAVELLE)
    {
      colonisation(bateau);
    }
  }
}

// Correct
int fabriquerBateau(bateau_type btype, int x, int y)
{
  construire(btype, Position(x, y));
  return id_dernier_bateau_construit();
}

// Correct
void envoyerGalion(int bateau, int ile)
{
  bateaux.push_back(bateau);
  missions.push_back(ile);
  ++cible[ile];
}

// Correct
void envoyerCaravelle(int bateau, int ile)
{
  bateaux.push_back(bateau);
  missions.push_back(ile);
  if (!colonisable[ile])
  {
    colonisable[ile] = true;
  }
}

// Correct
void creerArmee(position pos, int ile)
{
  while (nombre_bateaux(mon_joueur()) < LIMITE_BATEAUX && info_ile_or(pos) >= GALION_COUT)
  {
    int dernier = fabriquerBateau(BATEAU_GALION, pos.x, pos.y);
    envoyerGalion(dernier, ile);
  }  
}

// Correct
void production(int ile)
{
  if (!dejaTriee[ile])
  {
    std::sort(distances[ile].begin(), distances[ile].end());
    dejaTriee[ile] = true;
  }
  
  position ileCourante = Position(iles[ile].x, iles[ile].y);
  
  for (unsigned int voisin = 0; voisin < distances[ile].size(); ++voisin)
  {
    int iVoisin = distances[ile][voisin].indice;
    position posVoisin = Position(iles[iVoisin].x, iles[iVoisin].y);
    if (info_ile_joueur(posVoisin) == -1 && !colonisable[iVoisin])
    {
      if (info_ile_or(ileCourante) >= CARAVELLE_COUT && nombre_bateaux(mon_joueur()) < LIMITE_BATEAUX)
      {
        int dernier = fabriquerBateau(BATEAU_CARAVELLE, iles[ile].x, iles[ile].y);
        envoyerCaravelle(dernier, iVoisin);
        
        #ifdef DEBUG_PRODUCTION
        printf("Depuis {%d;%d} vers {%d;%d}\n", ileCourante.x, ileCourante.y, posVoisin.x, posVoisin.y);
        #endif
        
        creerArmee(ileCourante, iVoisin);
      }
      return;
    }
    else if (info_ile_joueur(posVoisin) == adversaire() && cible[iVoisin] <= nbEnnemis[iVoisin])
    {
      creerArmee(ileCourante, iVoisin);
      return;
    }
  }
  
  creerArmee(Position(iles[ile].x, iles[ile].y), ile);
}

// Correct
void productionGlobale()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    if (info_ile_joueur(Position(iles[ile].x, iles[ile].y)) == mon_joueur()
     && iles[ile].type == TERRAIN_ILE)
    {
      production(ile);
    }
  }
}

// Correct
int evaluerForcesAdverses(int ile)
{
  std::vector<bateau> flotte = liste_bateaux_position(Position(iles[ile].x, iles[ile].y));
  int nbGalionsEnnemis = 0;
  for (unsigned int bateau = 0; bateau < flotte.size(); ++bateau)
  {
    if (flotte[bateau].joueur == adversaire() && flotte[bateau].btype == BATEAU_GALION)
    {
      ++nbGalionsEnnemis;
    }
  }
  return nbGalionsEnnemis;
}

// Correcte
void MaJ_Ennemis()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    if (info_ile_joueur(Position(iles[ile].x, iles[ile].y)) == adversaire())
    {
      nbEnnemis[ile] = evaluerForcesAdverses(ile);
    }
  }
}

// Correct
void lancerAttaque(int iBateau)
{
  if (cible[missions[iBateau]] > nbEnnemis[missions[iBateau]])
  {
    bateau bateauCourant = info_bateau(bateaux[iBateau]);
    int x = iles[missions[iBateau]].x;
    int y = iles[missions[iBateau]].y;
    deplacer(bateaux[iBateau], joindre(bateauCourant.pos, Position(x, y), GALION_DEPLACEMENT));
  }
}

// Correct
void lancerAttaqueGlobale()
{
  for (unsigned int bateau = 0; bateau < bateaux.size(); ++bateau)
  {
    if (info_bateau(bateaux[bateau]).btype == BATEAU_GALION)
    {
      lancerAttaque(bateau);
    }
  }
}

// Correct
position joindre(position depart, position arrive, int longueur)
{
  #ifdef DEBUG_DEPLACEMENT
  printf("[%d;%d] essaie d'aller a [%d;%d]\n", depart.x, depart.y, arrive.x, arrive.y);
  #endif
  
  int deltaX = arrive.x - depart.x;
  int deltaY = arrive.y - depart.y;
  
  int nX = depart.x + std::min(abs(deltaX), longueur)*signe(deltaX);
  longueur -= std::min(abs(deltaX), longueur);
  int nY = depart.y + std::min(abs(deltaY), longueur)*signe(deltaY);
  
  return Position(nX, nY);
}

