///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb
//

#include "interface.hh"

#include <iostream>
#include <assert.h>
#include <cstdlib>
#include <cstring>

CSharpInterface gl_csharp;

template < class Out, class Cxx >
Out cxx2lang(Cxx in)
{
  return (Out)in;
}

template <>
MonoString* cxx2lang<MonoString*, std::string>(std::string in)
{
  return mono_string_new (gl_csharp.getDomain(), in.c_str());
}

template <>
gint32 cxx2lang< gint32, int >(int in)
{
  return (gint32)in;
}

template <>
gint32 cxx2lang< gint32, bool >(bool in)
{
  return (gint32)in;
}

template < class Out, class Cxx >
Cxx lang2cxx(Out in)
{
  return (Cxx)in;
}

template <>
std::string lang2cxx< MonoString*, std::string >(MonoString* in)
{
  std::string s_out;
  MonoError error;
  char *c_out;

  if (!in)
    return std::string("(null)");
  c_out = mono_string_to_utf8_checked(in, &error);
  if (!mono_error_ok(&error)) {
    s_out = std::string(mono_error_get_message(&error));
    mono_error_cleanup(&error);
    return s_out;
  } else {
    s_out = std::string(c_out);
    mono_free(c_out);
    return s_out;
  }
}

template <>
int lang2cxx< gint32, int >(gint32 in)
{
  return (int)in;
}

template <>
bool lang2cxx< gint32, bool >(gint32 in)
{
  return (bool)in;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<int> >(std::vector<int> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_get_int32_class();
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);

  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, int >(in[i])));

  return maArray;
}

template <>
std::vector<int> lang2cxx< MonoArray*, std::vector<int> >(MonoArray* in)
{
  std::vector< int > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, int >(mono_array_get(in, gint32, i)));

  return out;
}
///
// Type de bateau
//
template <>
gint32 cxx2lang< gint32, bateau_type >(bateau_type in)
{
  return (gint32)in;
}

template <>
bateau_type lang2cxx< gint32, bateau_type >(gint32 in)
{
  return (bateau_type)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<bateau_type> >(std::vector<bateau_type> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "BateauType");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, bateau_type >(in[i])));
  return maArray;
}

template <>
std::vector<bateau_type> lang2cxx< MonoArray*, std::vector<bateau_type> >(MonoArray* in)
{
  std::vector< bateau_type > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, bateau_type >(mono_array_get(in , gint32, i)));
  return out;
}

///
// Type de terrain
//
template <>
gint32 cxx2lang< gint32, terrain >(terrain in)
{
  return (gint32)in;
}

template <>
terrain lang2cxx< gint32, terrain >(gint32 in)
{
  return (terrain)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<terrain> >(std::vector<terrain> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Terrain");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, terrain >(in[i])));
  return maArray;
}

template <>
std::vector<terrain> lang2cxx< MonoArray*, std::vector<terrain> >(MonoArray* in)
{
  std::vector< terrain > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, terrain >(mono_array_get(in , gint32, i)));
  return out;
}

///
// Erreurs possibles
//
template <>
gint32 cxx2lang< gint32, erreur >(erreur in)
{
  return (gint32)in;
}

template <>
erreur lang2cxx< gint32, erreur >(gint32 in)
{
  return (erreur)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<erreur> >(std::vector<erreur> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Erreur");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, erreur >(in[i])));
  return maArray;
}

template <>
std::vector<erreur> lang2cxx< MonoArray*, std::vector<erreur> >(MonoArray* in)
{
  std::vector< erreur > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, erreur >(mono_array_get(in , gint32, i)));
  return out;
}

///
// Représente la position sur la carte
//
template <>
MonoObject* cxx2lang< MonoObject*, position >(position in)
{
  void* arg;
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.x));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "X"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.y));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Y"), &arg);
  return moObj;
}

template <>
position lang2cxx< MonoObject*, position >(MonoObject* in)
{
    position out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "X"), &out.x);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Y"), &out.y);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<position> >(std::vector<position> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, position >(in[i])));
  return maArray;
}

template <>
std::vector<position> lang2cxx< MonoArray*, std::vector<position> >(MonoArray* in)
{
  std::vector< position > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, position >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

///
// Représente un bateau
//
template <>
MonoObject* cxx2lang< MonoObject*, bateau >(bateau in)
{
  void* arg;
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Bateau");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.id));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Id"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< MonoObject*, position >(in.pos));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Pos"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.joueur));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Joueur"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, bateau_type >(in.btype));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Btype"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.nb_or));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "NbOr"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, bool >(in.deplacable));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Deplacable"), &arg);
  return moObj;
}

template <>
bateau lang2cxx< MonoObject*, bateau >(MonoObject* in)
{
    bateau out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Bateau");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Id"), &out.id);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Pos"), &field_out);
  out.pos = lang2cxx< MonoObject*, position >(reinterpret_cast< MonoObject* >(field_out));
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Joueur"), &out.joueur);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Btype"), &out.btype);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "NbOr"), &out.nb_or);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Deplacable"), &out.deplacable);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<bateau> >(std::vector<bateau> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Bateau");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, bateau >(in[i])));
  return maArray;
}

template <>
std::vector<bateau> lang2cxx< MonoArray*, std::vector<bateau> >(MonoArray* in)
{
  std::vector< bateau > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, bateau >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

gint32 info_terrain(MonoObject* pos)
{
	return cxx2lang< gint32, terrain >(api_info_terrain(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 info_ile_joueur(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_info_ile_joueur(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 info_ile_or(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_info_ile_or(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoObject* info_bateau(gint32 id)
{
	return cxx2lang< MonoObject*, bateau >(api_info_bateau(lang2cxx< gint32, int >(id)))
;
}

gint32 bateau_existe(gint32 id)
{
	return cxx2lang< gint32, bool >(api_bateau_existe(lang2cxx< gint32, int >(id)))
;
}

MonoArray* liste_bateaux_position(MonoObject* pos)
{
	return cxx2lang< MonoArray*, std::vector<bateau> >(api_liste_bateaux_position(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* liste_id_bateaux_position(MonoObject* pos)
{
	return cxx2lang< MonoArray*, std::vector<int> >(api_liste_id_bateaux_position(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* liste_iles()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_iles())
;
}

MonoArray* mes_iles()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_mes_iles())
;
}

gint32 id_dernier_bateau_construit()
{
	return cxx2lang< gint32, int >(api_id_dernier_bateau_construit())
;
}

gint32 distance(MonoObject* depart, MonoObject* arrivee)
{
	return cxx2lang< gint32, int >(api_distance(lang2cxx< MonoObject*, position >(depart), lang2cxx< MonoObject*, position >(arrivee)))
;
}

gint32 construire(gint32 btype, MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_construire(lang2cxx< gint32, bateau_type >(btype), lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 deplacer(gint32 id, MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_deplacer(lang2cxx< gint32, int >(id), lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 coloniser(MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_coloniser(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 charger(gint32 id, gint32 nb_or)
{
	return cxx2lang< gint32, erreur >(api_charger(lang2cxx< gint32, int >(id), lang2cxx< gint32, int >(nb_or)))
;
}

gint32 decharger(gint32 id, gint32 nb_or)
{
	return cxx2lang< gint32, erreur >(api_decharger(lang2cxx< gint32, int >(id), lang2cxx< gint32, int >(nb_or)))
;
}

gint32 transferer(gint32 montant, gint32 id_source, gint32 id_dest)
{
	return cxx2lang< gint32, erreur >(api_transferer(lang2cxx< gint32, int >(montant), lang2cxx< gint32, int >(id_source), lang2cxx< gint32, int >(id_dest)))
;
}

gint32 mon_joueur()
{
	return cxx2lang< gint32, int >(api_mon_joueur())
;
}

gint32 adversaire()
{
	return cxx2lang< gint32, int >(api_adversaire())
;
}

gint32 score(gint32 id_joueur)
{
	return cxx2lang< gint32, int >(api_score(lang2cxx< gint32, int >(id_joueur)))
;
}

gint32 tour_actuel()
{
	return cxx2lang< gint32, int >(api_tour_actuel())
;
}

gint32 nombre_bateaux(gint32 id_joueur)
{
	return cxx2lang< gint32, int >(api_nombre_bateaux(lang2cxx< gint32, int >(id_joueur)))
;
}

void afficher_bateau_type(gint32 v)
{
	api_afficher_bateau_type(lang2cxx< gint32, bateau_type >(v))
;
}

void afficher_terrain(gint32 v)
{
	api_afficher_terrain(lang2cxx< gint32, terrain >(v))
;
}

void afficher_erreur(gint32 v)
{
	api_afficher_erreur(lang2cxx< gint32, erreur >(v))
;
}

void afficher_position(MonoObject* v)
{
	api_afficher_position(lang2cxx< MonoObject*, position >(v))
;
}

void afficher_bateau(MonoObject* v)
{
	api_afficher_bateau(lang2cxx< MonoObject*, bateau >(v))
;
}


/*
** Inititialize Mono and load the DLL file.
*/
CSharpInterface::CSharpInterface()
{
  const char*		champion_path = getenv("CHAMPION_PATH");
  std::string		champion;

  if (!champion_path)
    champion = "./champion-prologin.dll";
  else
  {
    champion = champion_path;
    champion += "/champion-prologin.dll";
  }

  _domain = mono_jit_init(champion.c_str());
  assert(_domain != NULL);

  _assembly = mono_domain_assembly_open(_domain, champion.c_str());
  assert(_assembly != NULL);

  _image = mono_assembly_get_image(_assembly);
  assert(_image != NULL);

  _class = mono_class_from_name(_image, "Prologin", "Prologin");
  assert(_class != NULL);

  _object = mono_object_new(_domain, _class);
  assert(_object);

  mono_runtime_object_init(_object);

  // Register API functions as internal Mono functions
  mono_add_internal_call("Prologin.Api::InfoTerrain", (const void*)info_terrain);
  mono_add_internal_call("Prologin.Api::InfoIleJoueur", (const void*)info_ile_joueur);
  mono_add_internal_call("Prologin.Api::InfoIleOr", (const void*)info_ile_or);
  mono_add_internal_call("Prologin.Api::InfoBateau", (const void*)info_bateau);
  mono_add_internal_call("Prologin.Api::BateauExiste", (const void*)bateau_existe);
  mono_add_internal_call("Prologin.Api::ListeBateauxPosition", (const void*)liste_bateaux_position);
  mono_add_internal_call("Prologin.Api::ListeIdBateauxPosition", (const void*)liste_id_bateaux_position);
  mono_add_internal_call("Prologin.Api::ListeIles", (const void*)liste_iles);
  mono_add_internal_call("Prologin.Api::MesIles", (const void*)mes_iles);
  mono_add_internal_call("Prologin.Api::IdDernierBateauConstruit", (const void*)id_dernier_bateau_construit);
  mono_add_internal_call("Prologin.Api::Distance", (const void*)distance);
  mono_add_internal_call("Prologin.Api::Construire", (const void*)construire);
  mono_add_internal_call("Prologin.Api::Deplacer", (const void*)deplacer);
  mono_add_internal_call("Prologin.Api::Coloniser", (const void*)coloniser);
  mono_add_internal_call("Prologin.Api::Charger", (const void*)charger);
  mono_add_internal_call("Prologin.Api::Decharger", (const void*)decharger);
  mono_add_internal_call("Prologin.Api::Transferer", (const void*)transferer);
  mono_add_internal_call("Prologin.Api::MonJoueur", (const void*)mon_joueur);
  mono_add_internal_call("Prologin.Api::Adversaire", (const void*)adversaire);
  mono_add_internal_call("Prologin.Api::Score", (const void*)score);
  mono_add_internal_call("Prologin.Api::TourActuel", (const void*)tour_actuel);
  mono_add_internal_call("Prologin.Api::NombreBateaux", (const void*)nombre_bateaux);
  mono_add_internal_call("Prologin.Api::AfficherBateauType", (const void*)afficher_bateau_type);
  mono_add_internal_call("Prologin.Api::AfficherTerrain", (const void*)afficher_terrain);
  mono_add_internal_call("Prologin.Api::AfficherErreur", (const void*)afficher_erreur);
  mono_add_internal_call("Prologin.Api::AfficherPosition", (const void*)afficher_position);
  mono_add_internal_call("Prologin.Api::AfficherBateau", (const void*)afficher_bateau);
}

MonoImage* CSharpInterface::getImage()
{
    return _image;
}

MonoDomain* CSharpInterface::getDomain()
{
    return _domain;
}

CSharpInterface::~CSharpInterface()
{
  mono_image_close(_image);
  mono_assembly_close(_assembly);
  // XXX -- mono segfaults when calling this. Seems to be a known bug
  //        appearing when mono_jit_clean() is called from a dtor. ???
  //mono_jit_cleanup(_domain);
}

/*
** Calls C# functions from C++
*/
MonoObject* CSharpInterface::callCSharpMethod(const char* name)
{
  MonoThread*   thread = mono_thread_attach(_domain);
  MonoMethod*   method = mono_class_get_method_from_name(_class, name, 0);
  MonoObject*   object = mono_runtime_invoke(method, _object, NULL, NULL);

  mono_thread_detach(thread);

  return object;
}

/*
** Functions called from stechec to C.
*/
void partie_init()
{
  gl_csharp.callCSharpMethod("PartieInit");
}
void jouer_tour()
{
  gl_csharp.callCSharpMethod("JouerTour");
}
void partie_fin()
{
  gl_csharp.callCSharpMethod("PartieFin");
}
