// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Type de bateau
	public enum BateauType {
		BATEAU_CARAVELLE, // <- Caravelle
		BATEAU_GALION, // <- Galion
		BATEAU_ERREUR, // <- Bateau inexistant
	}

// Type de terrain
	public enum Terrain {
		TERRAIN_ILE, // <- Île
		TERRAIN_VOLCAN, // <- Volcan
		TERRAIN_MER, // <- Mer
		TERRAIN_ERREUR, // <- Erreur, case impossible
	}

// Erreurs possibles
	public enum Erreur {
		OK, // <- L'action a été exécutée avec succès
		OR_INSUFFISANT, // <- Vous ne possédez pas assez d'or pour cette action
		ILE_INVALIDE, // <- La position spécifiée n'est pas une île
		POSITION_INVALIDE, // <- La position spécifiée n'est pas valide
		TROP_LOIN, // <- La destination est trop éloignée
		ILE_COLONISEE, // <- L'île est déjà colonisée
		ILE_ENNEMIE, // <- L'île ne vous appartient pas
		BATEAU_ENNEMI, // <- Le bateau ne vous appartient pas
		ID_INVALIDE, // <- L'ID spécifiée n'est pas valide
		NON_DEPLACABLE, // <- Le bateau n'est pas déplaçable
		AUCUNE_CARAVELLE, // <- Il n'y a aucune caravelle susceptible de coloniser l'île
		LIMITE_ATTEINTE, // <- La limite de bateaux est atteinte
	}

// Représente la position sur la carte
	class Position {
		public Position() {
		}
		public int X; // <- Coordonnée en X
		public int Y; // <- Coordonnée en Y
	}

// Représente un bateau
	class Bateau {
		public Bateau() {
		}
		public int Id; // <- Identifiant unique du bateau
		public Position Pos; // <- Position
		public int Joueur; // <- Joueur
		public BateauType Btype; // <- Type
		public int NbOr; // <- Or contenu dans le bateau
		public bool Deplacable; // <- Le bateau n'a pas encore été déplacé ce tour-ci
	}

	class Api {
// Taille du terrain (longueur et largeur)
		public const int TAILLE_TERRAIN = 32;

// Nombre de tours par partie
		public const int FIN_PARTIE = 200;

// Nombre maximum de joueurs dans la partie
		public const int MAX_JOUEURS = 2;

// Revenu en or par île à chaque tour
		public const int REVENU_ILE = 5;

// Revenu en or par volcan à chaque tour
		public const int REVENU_VOLCAN = 10;

// Or initialement possédé par chaque joueur
		public const int OR_INITIAL = 20;

// Coût de construction d'une Caravelle
		public const int CARAVELLE_COUT = 15;

// Coût de construction d'un Galion
		public const int GALION_COUT = 4;

// Déplacement de la Caravelle
		public const int CARAVELLE_DEPLACEMENT = 4;

// Déplacement du Galion
		public const int GALION_DEPLACEMENT = 6;

// Limite du nombre de bateaux pour chaque joueur
		public const int LIMITE_BATEAUX = 500;

// Retourne la nature du terrain désigné par ``pos``.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Terrain InfoTerrain(Position pos);

// Retourne le joueur qui possède l'île à l'emplacement ``pos``. Retourne -1 si l'île est libre ou si la position indiquée n'est pas une île
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int InfoIleJoueur(Position pos);

// Retourne l'or contenu sur l'île à l'emplacement ``pos``. Retourne -1 si la case spécifiée n'est pas une île.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int InfoIleOr(Position pos);

// Retourne le bateau ayant pour identifiant ``id``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Bateau InfoBateau(int id);

// Retourne vrai si le bateau ayant pour identifiant ``id`` existe et est encore à flots
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool BateauExiste(int id);

// Retourne la liste de bateaux à la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Bateau[] ListeBateauxPosition(Position pos);

// Retourne la liste des ID des bateaux à la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int[] ListeIdBateauxPosition(Position pos);

// Retourne la liste des positions des îles de la carte
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListeIles();

// Retourne la liste des positions des îles qui vous appartiennent
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] MesIles();

// Retourne l'ID du dernier bateau construit. Son comportement n'est pas défini si vous n'avez pas encore créé de bateau à ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int IdDernierBateauConstruit();

// Retourne la distance entre deux positions
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Distance(Position depart, Position arrivee);

// Construire un bateau de type ``btype`` sur l'île à la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Construire(BateauType btype, Position pos);

// Déplace le bateau représenté par l'identifiant ``id`` jusqu'à la position `pos`` (si elle est dans la portée du bateau)
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Deplacer(int id, Position pos);

// Colonise l'île à la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Coloniser(Position pos);

// Charge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Charger(int id, int nb_or);

// Décharge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Decharger(int id, int nb_or);

// Transfère ``montant`` or de la caravelle ``id_source`` à la caravelle ``id_dest``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Transferer(int montant, int id_source, int id_dest);

// Retourne le numéro de votre joueur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int MonJoueur();

// Retourne le numéro de votre adversaire
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Adversaire();

// Retourne les scores du joueur désigné par l'identifiant ``id``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Score(int id_joueur);

// Retourne le numéro du tour actuel
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Retourne le nombre de bateaux que possède le joueur désigné par l'identifiant ``id``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int NombreBateaux(int id_joueur);

// Affiche le contenu d'une valeur de type bateau_type
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherBateauType(BateauType v);

// Affiche le contenu d'une valeur de type terrain
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherTerrain(Terrain v);

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type bateau
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherBateau(Bateau v);

	}
}
