#ifndef ILES_CPP
#define ILES_CPP

#include "prologin.hh"
#include "terrain.cpp"

extern int Moi;
extern int Adversaire;
extern std::vector<Ile> iles;

std::vector<int> usines;
std::vector<int> tresors;
void MaJ_Iles()
{
  usines.clear();
  tresors.clear();
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    Position pos(iles[ile].x, iles[ile].y);
    iles[ile].joueur = info_ile_joueur(pos.point());
    iles[ile].richesse = info_ile_or(pos.point());
    
    if (iles[ile].joueur == Moi)
    {
      if (iles[ile].type == ILE)
        usines.push_back(ile);
      else
        tresors.push_back(ile);
    }
  }
}

inline bool nombreBateauxCorrect()
{
  return (nombre_bateaux(Moi) < LIMITE_BATEAUX);
}

void produireArmeeGalions(int ile)
{
  int nbGalions = iles[ile].richesse / GALION_COUT;
  for (int galion = 0; galion < nbGalions && nombreBateauxCorrect(); ++galion)
  {
    Position pos(iles[ile].x, iles[ile].y);
    construire(BATEAU_GALION, pos.point());
  }
}

#endif

