#include "prologin.hh"

struct Flotte
{
  Flotte () : nbGallions(0), nbCaravelles(0)
  { }
  
  void deplacer(const position & pos)
  {
    for (int gallion = 0; gallion < nbGallions; ++gallion)
    {
      deplacer(gallions[gallion].id, pos);
    }
    
    for (int caravelle = 0; caravelle < nbCaravelles; ++caravelle)
    {
      deplacer(caravelles[caravelle].id, pos);
    }
    
    x = pos.x;
    y = pos.y;
  }
  
  void ajouter(const bateau & vaisseau)
  {
    if (vaisseau.btype == BATEAU_GALLION)
    {
      ++nbGallions;
      gallions.push_back(vaisseau.id);
    }
    else if (vaisseau.btype == BATEAU_CARAVELLE)
    {
      ++nbCaravelles;
      caravelles.push_back(vaisseau.id);
    }
  }
  
  int nbGallions; 
  int nbCaravelles;
  vector<int> gallions;
  vector<int> caravelles;
  int x;
  int y;
};

vector<Flotte> flottes;

