// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

// Type de bateau
enum BateauType {
  BATEAU_CARAVELLE, // <- Caravelle
  BATEAU_GALION, // <- Galion
  BATEAU_ERREUR, // <- Bateau inexistant
}

// Type de terrain
enum Terrain {
  TERRAIN_ILE, // <- Île
  TERRAIN_VOLCAN, // <- Volcan
  TERRAIN_MER, // <- Mer
  TERRAIN_ERREUR, // <- Erreur, case impossible
}

// Erreurs possibles
enum Erreur {
  OK, // <- L'action a été exécutée avec succès
  OR_INSUFFISANT, // <- Vous ne possédez pas assez d'or pour cette action
  ILE_INVALIDE, // <- La position spécifiée n'est pas une île
  POSITION_INVALIDE, // <- La position spécifiée n'est pas valide
  TROP_LOIN, // <- La destination est trop éloignée
  ILE_COLONISEE, // <- L'île est déjà colonisée
  ILE_ENNEMIE, // <- L'île ne vous appartient pas
  BATEAU_ENNEMI, // <- Le bateau ne vous appartient pas
  ID_INVALIDE, // <- L'ID spécifiée n'est pas valide
  NON_DEPLACABLE, // <- Le bateau n'est pas déplaçable
  AUCUNE_CARAVELLE, // <- Il n'y a aucune caravelle susceptible de coloniser l'île
  LIMITE_ATTEINTE, // <- La limite de bateaux est atteinte
}

// Représente la position sur la carte
class Position {
  public int x; // Coordonnée en X
  public int y; // Coordonnée en Y
}

// Représente un bateau
class Bateau {
  public int id; // Identifiant unique du bateau
  public Position pos = new Position(); // Position
  public int joueur; // Joueur
  public BateauType btype; // Type
  public int nb_or; // Or contenu dans le bateau
  public boolean deplacable; // Le bateau n'a pas encore été déplacé ce tour-ci
}

public class Interface
{
  // Taille du terrain (longueur et largeur)
  public static final int TAILLE_TERRAIN = 32;

  // Nombre de tours par partie
  public static final int FIN_PARTIE = 200;

  // Nombre maximum de joueurs dans la partie
  public static final int MAX_JOUEURS = 2;

  // Revenu en or par île à chaque tour
  public static final int REVENU_ILE = 5;

  // Revenu en or par volcan à chaque tour
  public static final int REVENU_VOLCAN = 10;

  // Or initialement possédé par chaque joueur
  public static final int OR_INITIAL = 20;

  // Coût de construction d'une Caravelle
  public static final int CARAVELLE_COUT = 15;

  // Coût de construction d'un Galion
  public static final int GALION_COUT = 4;

  // Déplacement de la Caravelle
  public static final int CARAVELLE_DEPLACEMENT = 4;

  // Déplacement du Galion
  public static final int GALION_DEPLACEMENT = 6;

  // Limite du nombre de bateaux pour chaque joueur
  public static final int LIMITE_BATEAUX = 500;

  // Retourne la nature du terrain désigné par ``pos``.
  public static native Terrain info_terrain(Position pos);

  // Retourne le joueur qui possède l'île à l'emplacement ``pos``. Retourne -1 si l'île est libre ou si la position indiquée n'est pas une île
  public static native int info_ile_joueur(Position pos);

  // Retourne l'or contenu sur l'île à l'emplacement ``pos``. Retourne -1 si la case spécifiée n'est pas une île.
  public static native int info_ile_or(Position pos);

  // Retourne le bateau ayant pour identifiant ``id``
  public static native Bateau info_bateau(int id);

  // Retourne vrai si le bateau ayant pour identifiant ``id`` existe et est encore à flots
  public static native boolean bateau_existe(int id);

  // Retourne la liste de bateaux à la position ``pos``
  public static native Bateau[] liste_bateaux_position(Position pos);

  // Retourne la liste des ID des bateaux à la position ``pos``
  public static native int[] liste_id_bateaux_position(Position pos);

  // Retourne la liste des positions des îles de la carte
  public static native Position[] liste_iles();

  // Retourne la liste des positions des îles qui vous appartiennent
  public static native Position[] mes_iles();

  // Retourne l'ID du dernier bateau construit. Son comportement n'est pas défini si vous n'avez pas encore créé de bateau à ce tour-ci.
  public static native int id_dernier_bateau_construit();

  // Retourne la distance entre deux positions
  public static native int distance(Position depart, Position arrivee);

  // Construire un bateau de type ``btype`` sur l'île à la position ``pos``
  public static native Erreur construire(BateauType btype, Position pos);

  // Déplace le bateau représenté par l'identifiant ``id`` jusqu'à la position `pos`` (si elle est dans la portée du bateau)
  public static native Erreur deplacer(int id, Position pos);

  // Colonise l'île à la position ``pos``
  public static native Erreur coloniser(Position pos);

  // Charge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
  public static native Erreur charger(int id, int nb_or);

  // Décharge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
  public static native Erreur decharger(int id, int nb_or);

  // Transfère ``montant`` or de la caravelle ``id_source`` à la caravelle ``id_dest``
  public static native Erreur transferer(int montant, int id_source, int id_dest);

  // Retourne le numéro de votre joueur
  public static native int mon_joueur();

  // Retourne le numéro de votre adversaire
  public static native int adversaire();

  // Retourne les scores du joueur désigné par l'identifiant ``id``
  public static native int score(int id_joueur);

  // Retourne le numéro du tour actuel
  public static native int tour_actuel();

  // Retourne le nombre de bateaux que possède le joueur désigné par l'identifiant ``id``
  public static native int nombre_bateaux(int id_joueur);

  // Affiche le contenu d'une valeur de type bateau_type
  public static native void afficher_bateau_type(BateauType v);

  // Affiche le contenu d'une valeur de type terrain
  public static native void afficher_terrain(Terrain v);

  // Affiche le contenu d'une valeur de type erreur
  public static native void afficher_erreur(Erreur v);

  // Affiche le contenu d'une valeur de type position
  public static native void afficher_position(Position v);

  // Affiche le contenu d'une valeur de type bateau
  public static native void afficher_bateau(Bateau v);

}
