/*
ID: algue-r1
PROG: packrec
LANG: C++
*/

#include <algorithm>
#include <cstdio>
#include <vector>
#include <exception>

using namespace std;

struct Rectangle
{
    Rectangle () {}
    Rectangle (int _l1, int _l2) : l1(_l1), l2(_l2) {}

    int l1; // Largeur par defaut
    int l2; // Longueur par defaut
    
    bool operator<(const Rectangle & r) const
    {
        int largeur = min(l1, l2);
        int longueur = max(l1, l2);
        int rLargeur = min(r.l1, r.l2);
        int rLongueur = max(r.l1, r.l2);
        
        if (largeur != rLargeur)
            return (largeur < rLargeur);
        return (longueur < rLongueur);
    }
};

const int INF = 1000*1000;
const int nbRectangles = 4;
Rectangle rectangles[nbRectangles];
vector<bool> utilise(nbRectangles, false);
int meilleureAire = INF;
vector<Rectangle> solutions;

vector<Rectangle> Aligner(int nombre)
{
    if (nombre <= 0)
        return vector<Rectangle>(1, Rectangle(0, 0));
    
    int rectangle = 0;
    while (utilise[rectangle])
        ++rectangle;
        
    int l1 = rectangles[rectangle].l1;
    int l2 = rectangles[rectangle].l2;
    
    utilise[rectangle] = true;
    vector<Rectangle> suivants = Aligner(nombre-1);
    utilise[rectangle] = false;
    
    vector<Rectangle> courants;
    for (unsigned int suivant = 0; suivant < suivants.size(); ++suivant)
    {
        courants.push_back(Rectangle(l1 + suivants[suivant].l1, max(l2, suivants[suivant].l2)));
        courants.push_back(Rectangle(l2 + suivants[suivant].l1, max(l1, suivants[suivant].l2)));
    }
    return courants;
}

vector<Rectangle> Layout2(int nombre)
{
    vector<Rectangle> courants;
    for (int rectangle = 0; rectangle < nbRectangles; ++rectangle)
    {
        if (!utilise[rectangle])
        {
            utilise[rectangle] = true;
            vector<Rectangle> suivants = Aligner(nombre-1);
            utilise[rectangle] = false;
            
            int l1 = rectangles[rectangle].l1;
            int l2 = rectangles[rectangle].l2;
            
            for (unsigned int suivant = 0; suivant < suivants.size(); ++suivant)
            {
                courants.push_back(Rectangle(max(l1, suivants[suivant].l1), l2 + suivants[suivant].l2));
                courants.push_back(Rectangle(max(l2, suivants[suivant].l1), l1 + suivants[suivant].l2));
            }
        }
    }
    return courants;
}

vector<Rectangle> Layout3()
{
    vector<Rectangle> courants;
    for (int rectangle = 0; rectangle < nbRectangles; ++rectangle)
    {
        if (!utilise[rectangle])
        {
            utilise[rectangle] = true;
            vector<Rectangle> suivants = Layout2(3);
            utilise[rectangle] = false;
            
            int l1 = rectangles[rectangle].l1;
            int l2 = rectangles[rectangle].l2;
            
            for (unsigned int suivant = 0; suivant < suivants.size(); ++suivant)
            {
                courants.push_back(Rectangle(l1 + suivants[suivant].l1, max(l2, suivants[suivant].l2)));
                courants.push_back(Rectangle(l2 + suivants[suivant].l1, max(l1, suivants[suivant].l2)));
            }
        }
    }
    return courants;
}

vector<Rectangle> Layout4()
{
    vector<Rectangle> courants;
    for (int rectangle = 0; rectangle < nbRectangles; ++rectangle)
    {
        if (!utilise[rectangle])
        {
            int l1 = rectangles[rectangle].l1;
            int l2 = rectangles[rectangle].l2;
            
            utilise[rectangle] = true;
            for (int rectangle2 = 0; rectangle2 < nbRectangles; ++rectangle2)
            {
                if (!utilise[rectangle2])
                {
                    int nl1 = max(rectangles[rectangle2].l1, l1);
                    int nl2 = rectangles[rectangle2].l2 + l2;
                    int nnl1 = max(rectangles[rectangle2].l1, l2);
                    int nnl2 = rectangles[rectangle2].l2 + l1;
                    
                    utilise[rectangle2] = true;
                    vector<Rectangle> suivants = Aligner (2);
                    utilise[rectangle2] = false;
                    
                    for (unsigned int suivant = 0; suivant < suivants.size(); ++suivant)
                    {
                        courants.push_back(Rectangle(nl1 + suivants[suivant].l1, max(nl2, suivants[suivant].l2)));
                        courants.push_back(Rectangle(nl2 + suivants[suivant].l1, max(nl1, suivants[suivant].l2)));
                        courants.push_back(Rectangle(nnl1 + suivants[suivant].l1, max(nnl2, suivants[suivant].l2)));
                        courants.push_back(Rectangle(nnl2 + suivants[suivant].l1, max(nnl1, suivants[suivant].l2)));
                    }
                }
            }
            utilise[rectangle] = false;
        }
    }
    return courants;
}

/
vector<Rectangle> Layout6()
{
    vector<Rectangle> courants;
    vector<Rectangle> courants;
    for (int rectangle = 0; rectangle < nbRectangles; ++rectangle)
    {
        if (!utilise[rectangle])
        {
            int l1 = rectangles[rectangle].l1;
            int l2 = rectangles[rectangle].l2;
            
            utilise[rectangle] = true;
            for (int rectangle2 = 0; rectangle2 < nbRectangles; ++rectangle2)
            {
                if (!utilise[rectangle2])
                {
                    int nl1 = max(rectangles[rectangle2].l1, l1);
                    int nl2 = rectangles[rectangle2].l2 + l2;
                    int nnl1 = max(rectangles[rectangle2].l1, l2);
                    int nnl2 = rectangles[rectangle2].l2 + l1;
                    
                    utilise[rectangle2] = true;
                    vector<Rectangle> suivants = Aligner (2);
                    utilise[rectangle2] = false;
                    
                    for (unsigned int suivant = 0; suivant < suivants.size(); ++suivant)
                    {
                        courants.push_back(Rectangle(nl1 + suivants[suivant].l1, max(nl2, suivants[suivant].l2)));
                        courants.push_back(Rectangle(nl2 + suivants[suivant].l1, max(nl1, suivants[suivant].l2)));
                        courants.push_back(Rectangle(nnl1 + suivants[suivant].l1, max(nnl2, suivants[suivant].l2)));
                        courants.push_back(Rectangle(nnl2 + suivants[suivant].l1, max(nnl1, suivants[suivant].l2)));
                    }
                }
            }
            utilise[rectangle] = false;
        }
    }
    return courants;
}

void selectionner (Rectangle proposition)
{
    int aireCourante = proposition.l1 * proposition.l2;
    if (aireCourante < meilleureAire)
    {
        solutions.clear();
        meilleureAire = aireCourante;
    }
    
    if (aireCourante == meilleureAire)
        solutions.push_back(proposition);
}

int main ()
{
    //freopen("packrec.in", "r", stdin); freopen("packrec.out", "w", stdout);
    
    for (int rectangle = 0; rectangle < nbRectangles; ++rectangle)
    {
        scanf("%d%d", &rectangles[rectangle].l1, &rectangles[rectangle].l2);
    }
    
    vector<Rectangle> total = Aligner(nbRectangles);
    vector<Rectangle> layout2 = Layout2(nbRectangles);
    vector<Rectangle> layout3 = Layout3();
    vector<Rectangle> layout4 = Layout4();
    total.insert(total.begin(), layout2.begin(), layout2.end());
    total.insert(total.begin(), layout3.begin(), layout3.end());
    total.insert(total.begin(), layout4.begin(), layout4.end());
    for (unsigned int possible = 0; possible < total.size(); ++possible)
    {
        selectionner(total[possible]);
    }
    
    printf("%d\n", meilleureAire);
    sort(solutions.begin(), solutions.end());
    Rectangle precedent(0, 0);
    for (unsigned int solution = 0; solution < solutions.size(); ++solution)
    {
        if (precedent < solutions[solution] || solutions[solution] < precedent)
        {
            int largeur = min(solutions[solution].l1, solutions[solution].l2);
            int longueur = max(solutions[solution].l1, solutions[solution].l2);
            printf("%d %d\n", largeur, longueur);
        }
        precedent = solutions[solution];
    }
}
 
