#ifndef TERRAIN_CPP
#define TERRAIN_CPP

#include <algorithm>

#include "prologin.hh"

extern const int taille = TAILLE_TERRAIN;

struct Position
{
  Position(int _x, int _y) : x(_x), y(_y)
  { }
  
  position point()
  {
    position pos;
    pos.x = x;
    pos.y = y;
    
    return pos;
  }
  
  int x;
  int y;
};

enum Terrain
{
  ILE,
  VOLCAN,
  MER
};

struct Ile
{
  Ile() {}
  Ile(int _x, 
      int _y, 
      Terrain _type, 
      int _id) : x(_x), y(_y), 
                 type(_type), 
                 id(_id), 
                 joueur(-1), 
                 richesse(0)
  {}
  
  int x;
  int y;
  Terrain type;
  int id;
  int joueur;
  int richesse;
};

std::vector<Ile> iles;
Terrain carte[taille][taille];
void lireCarte()
{
  for (int x = 0; x < taille; ++x)
  {
    for (int y= 0; y < taille; ++y)
    { 
      Position pos(x, y);
      terrain typeTerrain = info_terrain(pos.point());
      
      switch (typeTerrain)
      {
        case TERRAIN_ILE:
        carte[x][y] = ILE;
        break;
        
        case TERRAIN_VOLCAN:
        carte[x][y] = VOLCAN;
        break;
        
        case TERRAIN_MER:
        carte[x][y] = MER;
        break;
        
        default: break;
      }
      
      if (carte[x][y] == ILE || carte[x][y] == VOLCAN)
      {
        iles.push_back(Ile(x, y, carte[x][y], iles.size()));
      }
    }
  }
}

struct Chemin
{
  Chemin(int _id, int _longueur) : id(_id), longueur(_longueur)
  {}
  
  int id;
  int longueur;
  
  bool operator<(const Chemin & ch1) const
  {
    return (longueur < ch1.longueur);
  }
};

std::vector<std::vector<Chemin>> distances;
void distancesIles()
{
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    Position pos1(iles[ile].x, iles[ile].y);
    for (unsigned int desti = 0; desti <= ile; ++desti)
    {
      Position pos2(iles[desti].x, iles[desti].y);
      int longueur = distance(pos1.point(), pos2.point());
      distances[ile].push_back(Chemin(iles[desti].id, longueur));
      distance[desti].push_back(Chemin(iles[ile].id, longueur));
    }
  }
  
  for (unsigned int ile = 0; ile < iles.size(); ++ile)
  {
    std::sort(distances[ile].begin(), distances[ile].end());
  }
}

#endif

