///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_c.rb
//

#include "interface.hh"
#include <cstdlib>

template<typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
  return in;
}

template<>
std::string lang2cxx<char*, std::string>(char* in)
{
  return in;
}

template<typename Lang, typename Lang_array, typename Cxx>
std::vector<Cxx> lang2cxx_array(Lang_array in)
{
  std::vector<Cxx> out(in.length);
  for (size_t i = 0; i < in.length; ++i)
    out[i] = lang2cxx<Lang, Cxx>(in.datas[i]);
  return out;
}

template<typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
  return in;
}

template<>
char* cxx2lang<char*, std::string>(std::string in)
{
  size_t l = in.length();
  char* out = (char *) malloc(l + 1);
  for (int i = 0; i < l; i++) out[i] = in[i];
  out[l] = 0;
  return out;
}

template<typename Lang, typename Lang_array, typename Cxx>
Lang_array cxx2lang_array(const std::vector<Cxx>& in)
{
  Lang_array out = { NULL, in.size() };
  out.datas = (Lang *)malloc((out.length) * sizeof(Lang));
  for (int i = 0; i < out.length; ++i)
    out.datas[i] = cxx2lang<Lang, Cxx>(in[i]);
  return out;
}
///
// Représente la position sur la carte
//
template<>
__internal__cxx__position lang2cxx<position, __internal__cxx__position>(position in)
{
  __internal__cxx__position out;
  out.x = lang2cxx<int, int >(in.x);
  out.y = lang2cxx<int, int >(in.y);
  return out;
}

template<>
position cxx2lang<position, __internal__cxx__position>(__internal__cxx__position in)
{
  position out;
  out.x = cxx2lang<int, int >(in.x);
  out.y = cxx2lang<int, int >(in.y);
  return out;
}


///
// Représente une tourelle
//
template<>
__internal__cxx__tourelle lang2cxx<tourelle, __internal__cxx__tourelle>(tourelle in)
{
  __internal__cxx__tourelle out;
  out.pos = lang2cxx<position, __internal__cxx__position >(in.pos);
  out.portee = lang2cxx<int, int >(in.portee);
  out.joueur = lang2cxx<int, int >(in.joueur);
  out.vie = lang2cxx<int, int >(in.vie);
  out.attaque = lang2cxx<int, int >(in.attaque);
  return out;
}

template<>
tourelle cxx2lang<tourelle, __internal__cxx__tourelle>(__internal__cxx__tourelle in)
{
  tourelle out;
  out.pos = cxx2lang<position, __internal__cxx__position >(in.pos);
  out.portee = cxx2lang<int, int >(in.portee);
  out.joueur = cxx2lang<int, int >(in.joueur);
  out.vie = cxx2lang<int, int >(in.vie);
  out.attaque = cxx2lang<int, int >(in.attaque);
  return out;
}


extern "C" {
///
// Retourne le type de la case à l'emplacement `pos`
//
case_info info_case(position pos)
{
  return cxx2lang<case_info, case_info >(api_info_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


///
// Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
//
tourelle_array tourelles_joueur(int joueur)
{
  return cxx2lang_array<tourelle, tourelle_array, __internal__cxx__tourelle >(api_tourelles_joueur(lang2cxx<int, int >(joueur)));
}


///
// Retourne la magie que possède le joueur ``joueur``
//
int magie(int joueur)
{
  return cxx2lang<int, int >(api_magie(lang2cxx<int, int >(joueur)));
}


///
// Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
//
int nb_sorciers(position pos, int joueur)
{
  return cxx2lang<int, int >(api_nb_sorciers(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<int, int >(joueur)));
}


///
// Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
//
int nb_sorciers_deplacables(position pos, int joueur)
{
  return cxx2lang<int, int >(api_nb_sorciers_deplacables(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<int, int >(joueur)));
}


///
// Retourne le numéro du joueur qui contrôle la case ``pos``
//
int joueur_case(position pos)
{
  return cxx2lang<int, int >(api_joueur_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


///
// Retourne la tourelle située sur la case ``pos``
//
tourelle tourelle_case(position pos)
{
  return cxx2lang<tourelle, __internal__cxx__tourelle >(api_tourelle_case(lang2cxx<position, __internal__cxx__position >(pos)));
}


///
// Retourne la position de la base du joueur ``joueur``
//
position base_joueur(int joueur)
{
  return cxx2lang<position, __internal__cxx__position >(api_base_joueur(lang2cxx<int, int >(joueur)));
}


///
// Retourne vrai si l'on peut construire sur la case ``pos``
//
bool constructible(position pos, int joueur)
{
  return cxx2lang<bool, bool >(api_constructible(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<int, int >(joueur)));
}


///
// Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
//
position_array chemin(position pos1, position pos2)
{
  return cxx2lang_array<position, position_array, __internal__cxx__position >(api_chemin(lang2cxx<position, __internal__cxx__position >(pos1), lang2cxx<position, __internal__cxx__position >(pos2)));
}


///
// Construire une tourelle à la position ``pos``
//
erreur construire(position pos, int portee)
{
  return cxx2lang<erreur, erreur >(api_construire(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<int, int >(portee)));
}


///
// Supprimer une tourelle à la position ``pos``
//
erreur supprimer(position pos)
{
  return cxx2lang<erreur, erreur >(api_supprimer(lang2cxx<position, __internal__cxx__position >(pos)));
}


///
// Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
//
erreur tirer(int pts, position tourelle, position cible)
{
  return cxx2lang<erreur, erreur >(api_tirer(lang2cxx<int, int >(pts), lang2cxx<position, __internal__cxx__position >(tourelle), lang2cxx<position, __internal__cxx__position >(cible)));
}


///
// Créer ``nb`` sorciers dans la base
//
erreur creer(int nb)
{
  return cxx2lang<erreur, erreur >(api_creer(lang2cxx<int, int >(nb)));
}


///
// Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
//
erreur deplacer(position depart, position arrivee, int nb)
{
  return cxx2lang<erreur, erreur >(api_deplacer(lang2cxx<position, __internal__cxx__position >(depart), lang2cxx<position, __internal__cxx__position >(arrivee), lang2cxx<int, int >(nb)));
}


///
// Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
//
erreur assieger(position pos, position cible, int nb_sorciers)
{
  return cxx2lang<erreur, erreur >(api_assieger(lang2cxx<position, __internal__cxx__position >(pos), lang2cxx<position, __internal__cxx__position >(cible), lang2cxx<int, int >(nb_sorciers)));
}


///
// Retourne le numéro de votre joueur
//
int moi(void)
{
  return cxx2lang<int, int >(api_moi());
}


///
// Retourne la liste des numéros de vos adversaires
//
int_array adversaires(void)
{
  return cxx2lang_array<int, int_array, int >(api_adversaires());
}


///
// Retourne le numéro du tour actuel
//
int tour_actuel(void)
{
  return cxx2lang<int, int >(api_tour_actuel());
}


///
// Retourne la distance entre deux positions
//
int distance(position depart, position arrivee)
{
  return cxx2lang<int, int >(api_distance(lang2cxx<position, __internal__cxx__position >(depart), lang2cxx<position, __internal__cxx__position >(arrivee)));
}


///
// Annule la dernière action
//
erreur annuler(void)
{
  return cxx2lang<erreur, erreur >(api_annuler());
}


///
// Affiche le contenu d'une valeur de type case_info
//
void afficher_case_info(case_info v)
{
  api_afficher_case_info(lang2cxx<case_info, case_info >(v));
}


///
// Affiche le contenu d'une valeur de type erreur
//
void afficher_erreur(erreur v)
{
  api_afficher_erreur(lang2cxx<erreur, erreur >(v));
}


///
// Affiche le contenu d'une valeur de type position
//
void afficher_position(position v)
{
  api_afficher_position(lang2cxx<position, __internal__cxx__position >(v));
}


///
// Affiche le contenu d'une valeur de type tourelle
//
void afficher_tourelle(tourelle v)
{
  api_afficher_tourelle(lang2cxx<tourelle, __internal__cxx__tourelle >(v));
}


}
