(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

open Api;;

let rec list_take x l = match x,l with
  | 0, _ -> []
  | _, [] -> []
  | n, x::xs -> x :: list_take (n-1) xs

let case_random () = (Random.int 31, Random.int 31)

let rec constructible_random = function 
  | 0 -> None
  | n ->  let case = case_random () in
	  if constructible case (moi ())
	  then Some case
	  else constructible_random (n-1)

let distance (x,y) (x', y') = abs (x - x') + abs (y - y')

(* Truc de bourrin *)
let cases_ok () =
  let acc = ref [] in
  let tourelles = List.map (fun t -> t.pos)
    (Array.to_list (tourelles_joueur (moi ()))) in
  for i = 0 to 30 do
    for j = 0 to 30 do
      let case = (i,j) in
      if constructible case (moi ())
	&& List.for_all (fun t -> distance case t >= 3) tourelles
      then acc := case :: !acc
    done
  done;
  !acc
      

let direction_fontaine () = match base_joueur (moi ()) with
  | (0, 0) -> (1, 0)
  | (0, 30) -> (0, -1)
  | (30, 0) -> (0, 1)
  | (30, 30) -> (-1, 0)
  | _ -> failwith "la carte a changé de dimensions ?!?"

let avancer_vers_fontaine tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  let n = tour - 1 and n' = tour in
  ignore (deplacer (n*4*dx+x, n*4*dy+y) (n'*4*dx+x, n'*4*dy+y) 10)

let atteindre_fontaine tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  ignore (deplacer (12*dx+x, 12*dy+y) (15*dx+x, 15*dy+y) 10)

let construire_tour_chemin tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  let n = tour - 1 and n' = tour in
  ignore (deplacer (n*4*dx+x, n*4*dy+y) (n'*4*dx+x, n'*4*dy+y) 10)

(* typage fort au lieu de trucs à la C *)
let joueur_case pos =
  match joueur_case pos with
  | -1 -> None
  | x  -> Some x

(*
** Fonction appelée au début de la partie
*)
let partie_debut () = 
  let (x,y) = base_joueur (moi ()) in
  Printf.printf "Moi, %d, pars de <%d,%d>\n" (moi ()) x y;
  Random.self_init ();
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de construction
*)
let phase_construction () = begin match tour_actuel () with
  | 0 -> ignore (creer 10)
  | 1 -> let x, y = base_joueur (moi ()) in 
	 let dx, dy = direction_fontaine () in
	 ignore (construire (abs (x - 1) + dx, abs (y - 1) + dy) 3)
  | tour when tour <= 5 -> 
    let x, y = base_joueur (moi ()) in
    let dx, dy = direction_fontaine () in
    ignore (construire (abs (x - 1) + (3*(tour-1)+1)*dx,
			abs (y - 1) + (3*(tour-1)+1)*dy) 3)
  | tour -> begin
    (* match constructible_random 50 with  *)
    (* | None -> () *)
    (* | Some case -> ignore (construire case 3) *)
    let rec loop () =
      if magie (moi ()) >= 20 then begin
	let cases = cases_ok () in
	if cases <> [] then (begin
	  let len = List.length cases in
	  if len > 4 then
	    let prio = List.sort
	      (fun p p' -> compare
		(distance p (15,15))
		(distance p' (15,15)))
	      cases in 
	    let prio = list_take 4 prio in
	    ignore (construire (List.nth prio (Random.int 4)) 3)
	  else
	    let ix = Random.int (List.length cases) in
	    ignore (construire (List.nth cases ix) 3)
	end; loop ())
      end
      else
	raise Exit
    in
    try loop (); ignore (creer (magie (moi ()) / cout_sorcier))
    with Exit -> ()
  end end;
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de déplacement
*)
let phase_deplacement () = begin match tour_actuel () with
  | 0 -> ()
  | tour when tour <= 3 -> avancer_vers_fontaine tour
  | 4 -> atteindre_fontaine ()
  | tour -> begin
    let rec constructible_random = function 
      | 0 -> None
      | n ->  let case = case_random () in
	      if constructible case (moi ())
	      then Some case
	      else constructible_random (n-1)
    in
    begin
      match constructible_random 50 with
      | None -> ()
      | Some case -> ignore ( construire case 3 )
    end;
  end end;
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de tirs des tourelles
*)
let phase_tirs () =  
  let f t =
    let (x,y) = t.pos in
    for i = max (x - t.portee) 0 to min (x + t.portee) 30 do
      let d = t.portee - abs (i - x) in
      for j = max (y - d) 0 to min (y + d) 30 do
  	match joueur_case (i,j) with
	| None -> ()
	| Some player ->
	  let sorciers = nb_sorciers (i,j) player in
	  ignore (tirer (min sorciers t.attaque) (x,y) (i,j))
      done
    done
  in
  Array.iter f (tourelles_joueur (moi ()));
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de siège des tourelles
*)
let phase_siege () = 
  flush stderr; flush stdout

(*
** Fonction appelée à la fin de la partie
*)
let partie_fin () = 
  flush stderr; flush stdout
;;

(* /!\ Ne touche pas a ce qui suit /!\ *)
Callback.register "ml_partie_debut" partie_debut;;
Callback.register "ml_phase_construction" phase_construction;;
Callback.register "ml_phase_deplacement" phase_deplacement;;
Callback.register "ml_phase_tirs" phase_tirs;;
Callback.register "ml_phase_siege" phase_siege;;
Callback.register "ml_partie_fin" partie_fin;;
