(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

open Api
open Printf

let max_tourelle = 9
let max_tourelle_portee = 7

let action = function
  | Ok -> ()
  | x -> print_endline begin match x with
    | Annuler_impossible -> "Aucune action à annuler"
    | Case_impossible -> "Cette case n'existe pas"
    | Case_adverse -> "Vous ne contrôlez pas cette case"
    | Case_utilisee -> "Cette case n'est pas libre"
    | Case_vide -> "Cette case est vide"
    | Valeur_invalide -> "Cette valeur est invalide"
    | Magie_insuffisante -> "Vous n'avez pas assez de magie"
    | Sorciers_insuffisants -> "Vous n'avez pas assez de sorciers"
    | Attaque_insuffisante ->
      "Vous n'avez pas assez de points d'attaque"
    | Phase_incorrecte ->
      "Cette action ne peut pas être utilisée lors de cette phase du jeu."
    | Portee_insuffisante ->
      " Vous n'avez pas assez de portée pour effectuer cette action"
    | Perdant ->
      "Vous avez perdu et ne pouvez pas effectuer d'actions"
    | Ok -> assert false
  end

let rec (---) a b =
  if a > b then []
  else a :: ((a+1) --- b)


(* renvoie une liste avec des doublons *)
let sphere_l1 (x,y) r =
  let f (epsx, epsy) d = (x+epsx*d, y+epsy*(r-d)) in
  let range = 0 --- r in
  let l =
    List.map (f (1,1)) range @
      List.map (f (1,-1)) range @
      List.map (f (-1,1)) range @
      List.map (f (-1,-1)) range in
  List.filter (fun (x,y) -> x >= 0 && x <= 30 && y >= 0 && y <= 30) l

let boule_l1 (x,y) r = 
  let f x' =
    let d = r - abs (x - x') in
    List.map (fun y' -> (x', y')) ((max (y - d) 0) --- (min (y + d) 30))
  in
  List.concat (List.map f ((max (x - r) 0) --- (min (x + r) 30)))

let rec list_take x l = match x,l with
  | 0, _ -> []
  | _, [] -> []
  | n, x::xs -> x :: list_take (n-1) xs

let case_random () = (Random.int 31, Random.int 31)

let rec constructible_random = function 
  | 0 -> None
  | n ->  let case = case_random () in
	  if constructible case (moi ())
	  then Some case
	  else constructible_random (n-1)

let distance (x,y) (x', y') = abs (x - x') + abs (y - y')

(* Truc de bourrin ; obsolète *)
let cases_ok () =
  let acc = ref [] in
  let tourelles = List.map (fun t -> t.pos)
    (Array.to_list (tourelles_joueur (moi ()))) in
  for i = 0 to 30 do
    for j = 0 to 30 do
      let case = (i,j) in
      if constructible case (moi ())
	&& List.for_all (fun t -> distance case t >= 3) tourelles
      then acc := case :: !acc
    done
  done;
  !acc
      

let direction_fontaine () = match base_joueur (moi ()) with
  | (0, 0) -> (1, 0)
  | (0, 30) -> (0, -1)
  | (30, 0) -> (0, 1)
  | (30, 30) -> (-1, 0)
  | _ -> failwith "la carte a changé de dimensions ?!?"

let avancer_vers_fontaine tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  let n = tour-1 and n' = tour in
  action (deplacer (n*4*dx+x, n*4*dy+y) (n'*4*dx+x, n'*4*dy+y) 3)

let atteindre_fontaine tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  action (deplacer (12*dx+x, 12*dy+y) (15*dx+x, 15*dy+y) 3)

let construire_tour_chemin tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  let n = tour and n' = tour+1 in
  action (deplacer (n*4*dx+x, n*4*dy+y) (n'*4*dx+x, n'*4*dy+y) 3)

(* typage fort au lieu de trucs à la C *)
let joueur_case pos =
  match joueur_case pos with
  | -1 -> None
  | x  -> Some x

let tirer_au_pif () = 
  let f t =
    let g (i,j) =
      match joueur_case (i,j) with
      | None -> ()
      | Some player ->
  	let sorciers = nb_sorciers (i,j) player in
  	if sorciers > 0
	then action (tirer (min sorciers t.attaque) (x,y) (i,j))
    in
    List.iter g (boule_l1 t.pos t.portee)
  in
  Array.iter f (tourelles_joueur (moi ()))


module Foobar = struct

(*
** Fonction appelée au début de la partie
*)
let partie_debut () = 
  let (x,y) = base_joueur (moi ()) in
  printf "Moi, %d, pars de <%d,%d>\n" (moi ()) x y;
  Random.self_init ();
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de construction
*)
let phase_construction () =
  let x, y = base_joueur (moi ()) in 
  let dx, dy = direction_fontaine () in
  begin match tour_actuel () with
  (* Hardcoded build order to get a tower in range of a fountain
     as soon as possible *)
  | 0 -> action (construire (x + 3*dx, y + 3*dy) 3)
  | 1 ->
    action (construire (x + 6*dx, y + 6*dy) 3);
    action (supprimer (x + 3*dx, y + 3*dy));
    action (creer 3)
  | 2 ->
    action (supprimer (x + 6*dx, y + 6*dy));
    action (construire (x + 9*dx, y + 9*dy) 6)
  (* | tour when tour <= 5 ->  *)
  (*   (if tour = 1 then action (creer 10)); *)
  (*   let x, y = base_joueur (moi ()) in *)
  (*   let dx, dy = direction_fontaine () in *)
  (*   action (construire (abs (x - 1) + (3*(tour-1)+1)*dx, *)
  (* 			abs (y - 1) + (3*(tour-1)+1)*dy) 3) *)
  | tour -> begin
    (* match constructible_random 50 with  *)
    (* | None -> () *)
    (* | Some case -> action (construire case 3) *)
    (* let rec loop () = *)
    (*   if magie (moi ()) >= 20 then begin *)
    (* 	let cases = cases_ok () in *)
    (* 	if cases <> [] && Array.length (tourelles_joueur (moi ())) < 9 then (begin *)
    (* 	  let len = List.length cases in *)
    (* 	  if len > 4 then *)
    (* 	    let prio = List.sort *)
    (* 	      (fun p p' -> compare *)
    (* 		(distance p (15,15)) *)
    (* 		(distance p' (15,15))) *)
    (* 	      cases in  *)
    (* 	    let prio = list_take 4 prio in *)
    (* 	    action (construire (List.nth prio (Random.int 4)) 3) *)
    (* 	  else *)
    (* 	    let ix = Random.int (List.length cases) in *)
    (* 	    action (construire (List.nth cases ix) 3) *)
    (* 	end; loop ()) *)
    (*   end *)
    (*   else *)
    (* 	raise Exit *)
    (* in *)
    (* try loop (); action (creer (magie (moi ()) / cout_sorcier)) *)
    (* with Exit -> () *)
  end end;
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de déplacement
*)
let phase_deplacement () = begin match tour_actuel () with
  | tour when tour <= 3 -> avancer_vers_fontaine tour
  | 4 -> atteindre_fontaine ()
  | tour -> begin
  end end;
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de tirs des tourelles
*)
let phase_tirs () =  
  tirer_au_pif ();
  flush stderr; flush stdout

(*
** Fonction appelée pendant la phase de siège des tourelles
*)
let phase_siege () = 
  flush stderr; flush stdout

(*
** Fonction appelée à la fin de la partie
*)
let partie_fin () = 
  flush stderr; flush stdout
;;

end

module NoTower = struct

  let squad_v = ref (0,0) and squad_h = ref (0,0)
  let x0 = ref 0 and y0 = ref 0
  let squad_wat = ref (0,0)

(*
 ** Fonction appelée au début de la partie
 *)
  let partie_debut () =
    (let (x, y) = base_joueur (moi ()) in x0 := x; y0 := y);
    let f_v = (x0, 15) and f_h = (15, y0) in
    List.iter (fun r -> r := (!x0, !y0) [squad_v, squad_h, squad_wat];
    flush stderr; flush stdout

  let init_tour () =
    
(*
 ** Fonction appelée pendant la phase de construction
 *)
  let phase_construction () =
    init_tour ();
    begin match tour_actuel () with
    | 0 -> action (creer 10)
    | 1 -> action (construire (abs (!x0-1), abs (!y0-1)) 3)
    | _ -> action (creer (magie (moi ()) / cout_sorcier))
    end;
    flush stderr; flush stdout

  let naive_move_squad tour squad_ref (vx, vy) =
    let c = if tour = 3 then 3 else 4 in
    let (x,y) = !squad_ref in
    let x' = x + c*vx and y' = y + c*vy in
    action (deplacer !squad_ref (x',y') 5);
    squad_ref := (x',y')

(*
 ** Fonction appelée pendant la phase de déplacement
 *)
  let phase_deplacement () =
    begin match tour_actuel () with
    | tour when tour <= 3 ->
      naive_move_squad tour squad_h ((15 - !x0)/15, 0);
      naive_move_squad tour squad_v (0, (15 - !y0)/15);
    | tour when tour <= 15 -> ()
    | tour ->
      let (x,y) = !squad_wat in (* pour l'instant y = 0 tout le temps *)
      let vx = (15 - !x0) / 15 in
      
      let row = List.map (fun t -> (!x0 + vx*t, y0)) (
      let loop r = 
	
    end;
    flush stderr; flush stdout

(*
 ** Fonction appelée pendant la phase de tirs des tourelles
 *)
(* tirs indiscriminés *)
  let phase_tirs () =  
    tirer_au_pif ();
    flush stderr; flush stdout

(*
 ** Fonction appelée pendant la phase de siège des tourelles
 *)
  let phase_siege () = 
    flush stderr; flush stdout

(*
 ** Fonction appelée à la fin de la partie
 *)
  let partie_fin () = 
    flush stderr; flush stdout
end

include NoTower;;

(* /!\ Ne touche pas a ce qui suit /!\ *)
Callback.register "ml_partie_debut" partie_debut;;
Callback.register "ml_phase_construction" phase_construction;;
Callback.register "ml_phase_deplacement" phase_deplacement;;
Callback.register "ml_phase_tirs" phase_tirs;;
Callback.register "ml_phase_siege" phase_siege;;
Callback.register "ml_partie_fin" partie_fin;;
