(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(***** README *****

La fonction de cette IA est de faire chier les gens qui se ruent sur
l'artefact en voulant toujours gagner ; elle n'a pas vocation à
atteindre la première place, sauf dans un match anormal. En effet,
elle ignore systématiquement l'artefact et ne cherche qu'à tuer des
gens en faisant un rush sur les 2 bases voisines au tour 90.
Elle est capable de démolir les tours qui s'érigent contre elle.
Si l'ennemi reste cloîtré chez lui, elle essaie de prendre sa
fontaine. 

Elle s'appelle NipponBanzai à cause de la légère similitude
avec les kamikazes.

Attention, il y a pas mal de code mort, et les constantes sont codées
en dur.

Sinon, à part ça, le code devrait parler de lui-même : il n'y a rien
d'algorithmiquement compliqué. En fait on pourrait dire qu'il n'y
a aucun algorithme sérieux à part la fonction chemin gentiment
fournie. Le code de chaque phase fait une grosse disjonction de cas
sur le tour actuel ; il ne se passe rien avant le tour 90
à part le maintien de la défense (5 tours de portée 3).

De façon très ironique je ne reconstruis pas de murs après
avoir créé une ouverture pour mes troupes. Je préfère pouvoir buter
des aggressifs qui me balancent un flux continu d'unités plutôt
que de me prémunir de mes frères trollesques !

*)



open Api
open Printf

let max_tourelle = 9
let max_tourelle_portee = 7

let action = function
  | Ok -> ()
  | x -> print_endline begin match x with
    | Annuler_impossible -> "Aucune action à annuler"
    | Case_impossible -> "Cette case n'existe pas"
    | Case_adverse -> "Vous ne contrôlez pas cette case"
    | Case_utilisee -> "Cette case n'est pas libre"
    | Case_vide -> "Cette case est vide"
    | Valeur_invalide -> "Cette valeur est invalide"
    | Magie_insuffisante -> "Vous n'avez pas assez de magie"
    | Sorciers_insuffisants -> "Vous n'avez pas assez de sorciers"
    | Attaque_insuffisante ->
      "Vous n'avez pas assez de points d'attaque"
    | Phase_incorrecte ->
      "Cette action ne peut pas être utilisée lors de cette phase du jeu."
    | Portee_insuffisante ->
      " Vous n'avez pas assez de portée pour effectuer cette action"
    | Perdant ->
      "Vous avez perdu et ne pouvez pas effectuer d'actions"
    | Ok -> assert false
  end

let rec (---) a b =
  if a > b then []
  else a :: ((a+1) --- b)


(* renvoie une liste avec des doublons *)
let sphere_l1 (x,y) r =
  let f (epsx, epsy) d = (x+epsx*d, y+epsy*(r-d)) in
  let range = 0 --- r in
  let l =
    List.map (f (1,1)) range @
      List.map (f (1,-1)) range @
      List.map (f (-1,1)) range @
      List.map (f (-1,-1)) range in
  List.filter (fun (x,y) -> x >= 0 && x <= 30 && y >= 0 && y <= 30) l

let voisinage (x,y) =
  let l = [(x+1,y);(x-1,y);(x,y+1);(x,y-1)] in
  List.filter (fun (x,y) -> x >= 0 && x <= 30 && y >= 0 && y <= 30) l

let boule_l1 (x,y) r = 
  let f x' =
    let d = r - abs (x - x') in
    List.map (fun y' -> (x', y')) ((max (y - d) 0) --- (min (y + d) 30))
  in
  List.concat (List.map f ((max (x - r) 0) --- (min (x + r) 30)))

let rec list_take x l = match x,l with
  | 0, _ -> []
  | _, [] -> []
  | n, x::xs -> x :: list_take (n-1) xs

let case_random () = (Random.int 31, Random.int 31)

(* spam random de tours -> marche moins bien depuis le nerf *)
let rec constructible_random = function 
  | 0 -> None
  | n ->  let case = case_random () in
	  if constructible case (moi ())
	  then Some case
	  else constructible_random (n-1)

let distance (x,y) (x', y') = abs (x - x') + abs (y - y')

(* Truc de bourrin ; obsolète *)
let cases_ok () =
  let acc = ref [] in
  let tourelles = List.map (fun t -> t.pos)
    (Array.to_list (tourelles_joueur (moi ()))) in
  for i = 0 to 30 do
    for j = 0 to 30 do
      let case = (i,j) in
      if constructible case (moi ())
	&& List.for_all (fun t -> distance case t >= 3) tourelles
      then acc := case :: !acc
    done
  done;
  !acc
      
(* autres vieux trucs à l'époque où je voulais
   sécuriser une fontaine *)

let direction_fontaine () = match base_joueur (moi ()) with
  | (0, 0) -> (1, 0)
  | (0, 30) -> (0, -1)
  | (30, 0) -> (0, 1)
  | (30, 30) -> (-1, 0)
  | _ -> failwith "la carte a changé de dimensions ?!?"

let avancer_vers_fontaine tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  let n = tour-1 and n' = tour in
  action (deplacer (n*4*dx+x, n*4*dy+y) (n'*4*dx+x, n'*4*dy+y) 3)

let atteindre_fontaine tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  action (deplacer (12*dx+x, 12*dy+y) (15*dx+x, 15*dy+y) 3)

let construire_tour_chemin tour =
  let x, y = base_joueur (moi ()) in
  let dx, dy = direction_fontaine () in
  let n = tour and n' = tour+1 in
  action (deplacer (n*4*dx+x, n*4*dy+y) (n'*4*dx+x, n'*4*dy+y) 3)

(* fin code mort *)


(* typage fort au lieu de trucs à la C *)
let joueur_case pos =
  match joueur_case pos with
  | -1 -> None
  | x  -> Some x



let tirer_au_pif () = 
  let f t =
    let g (i,j) =
      match joueur_case (i,j) with
      | None -> ()
      | Some player ->
  	let sorciers = nb_sorciers (i,j) player in
  	if sorciers > 0
	then action (tirer (min sorciers t.attaque) t.pos (i,j))
    in
    List.iter g (boule_l1 t.pos t.portee)
  in
  Array.iter f (tourelles_joueur (moi ()))


let squad_x_loc = ref (0,0) and squad_y_loc = ref (0,0)
let squad_x_num = ref 0     and squad_y_num = ref 0

(*
 ** Fonction appelée au début de la partie
 *)
let partie_debut () = 
  let (x,y) = base_joueur (moi ()) in
  printf "Moi, %d, pars de <%d,%d>\n" (moi ()) x y;
  squad_x_loc := (x,y); squad_y_loc := (x,y);
  Random.self_init ();
  flush stderr; flush stdout

    
(*
 ** Fonction appelée pendant la phase de construction
 *)
let phase_construction () =
  print_endline "construction";
  (* init_tour (); *)
  begin match tour_actuel () with
  | tour when tour < 5 -> ()
  | 5 -> 
    let (x,y) = base_joueur (moi ()) in
    let x' = abs (x - 1) and y' = abs (y - 1)
    and x'' = abs (x - 2) and y'' = abs (y - 2) in
    (
      action (construire (x',y') 3);
      action (construire (x,y'') 3);
      action (construire (x'',y) 3);
      action (construire (x',y'') 3);
      action (construire (x'',y') 3)
    )
  | tour when tour < 90 -> 
    let (x,y) = base_joueur (moi ()) in
    let x' = abs (x - 1) and y' = abs (y - 1)
    and x'' = abs (x - 2) and y'' = abs (y - 2) in
    (
      action (construire (x,y'') 3);
      action (construire (x'',y) 3);
      action (construire (x',y'') 3);
      action (construire (x'',y') 3)
    ) 
  | 90 ->
    let (x,y) = base_joueur (moi ()) in
    let  x'' = abs (x - 2) and y'' = abs (y - 2) in
     (
      action (supprimer (x,y''));
      action (supprimer (x'',y));

      action (creer (magie (moi ()) / cout_sorcier));

      let troops = nb_sorciers (base_joueur (moi ())) (moi ()) in
      let threat = List.fold_left (+) 0
	(List.map (fun p -> match joueur_case p with
	| None -> 0
	| Some joueur when joueur = moi () -> 0
	| Some joueur -> nb_sorciers p joueur)
	 (boule_l1 (x,y) 4))
      in
      let attackers = troops - threat - 10 in
      squad_x_num := attackers/2;
      squad_y_num := (attackers+1)/2;
      action (creer (magie (moi ()) / cout_sorcier))
    )
  | _ -> action (creer (magie (moi ()) / cout_sorcier))
  end;
  flush stderr; flush stdout


(* en fait c'est pas exactement ça, but oh well... *)
let towers_vois p =
  List.length (List.filter (fun p' -> match joueur_case p' with
  | Some joueur when joueur <> moi () -> true
  | _ -> false
  ) (voisinage p))

 
let move_forward squad_loc squad_num adv =
  let pos = !squad_loc in
  let path = chemin pos adv in
  let dest = if Array.length path = 0 
    then (match
	List.sort (fun p p' ->
	  compare
	    (distance p adv,  -towers_vois p)
	    (distance p' adv, -towers_vois p'))
	  (List.filter (fun p -> match joueur_case p with
	  | Some joueur when joueur <> moi () -> false
	  | _ -> let x = Array.length (chemin pos p) in
		 x > 0 && x <= 4)
	     (boule_l1 pos 4))
      with
      | [] -> pos
      | x::_ -> x)
    else
      path.(min 3 (Array.length path - 1))
  in
  action (deplacer pos dest !squad_num);
  squad_loc := dest
	      
(*
 ** Fonction appelée pendant la phase de déplacement
 *)
let enemy_hikki_x = ref false and enemy_hikki_y = ref false

let nb_defensers adv = 
  match joueur_case adv with
  | None -> 0
  | Some joueur -> nb_sorciers adv joueur

let phase_deplacement () = 
  print_endline "deplacement";
  begin match tour_actuel () with
  | tour when tour < 90 -> ()
  | tour when tour <= 95 -> 
    let (x,y) = base_joueur (moi ()) in
    let adv_x = (30-x, y) and adv_y = (x, 30-y) in
    move_forward squad_x_loc squad_x_num adv_x;
    move_forward squad_y_loc squad_y_num adv_y
  | tour -> 
    let (x,y) = base_joueur (moi ()) in
    let adv_x = (30-x, y) and adv_y = (x, 30-y) in
    (if tour = 95 then (
      (if nb_defensers adv_x > !squad_x_num
       then enemy_hikki_x := true);
      (if nb_defensers adv_y > !squad_y_num
       then enemy_hikki_y := true);
     ));
    let (x,y) = base_joueur (moi ()) in
    let fount_x = (15, y) and fount_y = (x, 15) in
    let target_x = if !enemy_hikki_x then fount_x else adv_x
    and target_y = if !enemy_hikki_y then fount_y else adv_y in
    move_forward squad_x_loc squad_x_num target_x;
    move_forward squad_y_loc squad_y_num target_y
  end;
  flush stderr; flush stdout


(*
 ** Fonction appelée pendant la phase de tirs des tourelles
 *)

let phase_tirs () =  
  print_endline "tirs";
  tirer_au_pif ();
  flush stderr; flush stdout
    
let assieger_voisinage pos =
  List.iter (fun p -> match joueur_case p with
  | Some joueur when joueur <> moi () ->action (assieger pos p 10)
  | _ -> ()) (voisinage pos)
  

(*
 ** Fonction appelée pendant la phase de siège des tourelles
 *)
let phase_siege () = 
  print_endline "siege";
  begin match tour_actuel () with
  | tour when tour < 90 ->
    assieger_voisinage (base_joueur (moi ()))
  | _ -> 
    squad_x_num := nb_sorciers !squad_x_loc (moi ());
    squad_y_num := nb_sorciers !squad_y_loc (moi ());
    assieger_voisinage (base_joueur (moi ()));
    assieger_voisinage !squad_x_loc;
    assieger_voisinage !squad_y_loc
  end;
  flush stderr; flush stdout
    
(*
 ** Fonction appelée à la fin de la partie
 *)
let partie_fin () = 
  flush stderr; flush stdout
;;
    
(* /!\ Ne touche pas a ce qui suit /!\ *)
Callback.register "ml_partie_debut" partie_debut;;
Callback.register "ml_phase_construction" phase_construction;;
Callback.register "ml_phase_deplacement" phase_deplacement;;
Callback.register "ml_phase_tirs" phase_tirs;;
Callback.register "ml_phase_siege" phase_siege;;
Callback.register "ml_partie_fin" partie_fin;;
