///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_php.rb
//

#include "interface.hh"

static void _init_php();

template <typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
zval* cxx2lang<zval*, int>(int in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_LONG(x, (long)in);
    return x;
}

template <>
zval* cxx2lang<zval*, bool>(bool in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_BOOL(x, in);
    return x;
}

template <>
zval* cxx2lang<zval*, std::string>(std::string in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_STRINGL(x, in.c_str(), in.length(), true);
    return x;
}

template <typename Cxx>
zval* cxx2lang_array(const std::vector<Cxx>& in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    array_init(x);

    size_t s = in.size();

    for (size_t i = 0; i < s; ++i)
      add_next_index_zval(x, cxx2lang<zval*, Cxx>(in[i]));

    return x;
}

template <typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
int lang2cxx<zval*, int>(zval* in)
{
    if (in->type != IS_LONG) {
        zend_error(E_WARNING, "parameter should be an int");
        throw 42;
    }
    return (int)Z_LVAL_P(in);
}

template <>
bool lang2cxx<zval*, bool>(zval* in)
{
    if (in->type != IS_BOOL) {
        zend_error(E_WARNING, "parameter should be a boolean");
        throw 42;
    }
    return Z_BVAL_P(in);
}

template <>
std::string lang2cxx<zval*, std::string>(zval* in)
{
    if (in->type != IS_STRING) {
        zend_error(E_WARNING, "parameter should be a string");
        throw 42;
    }
    return Z_STRVAL_P(in);
}

template <typename Cxx>
std::vector<Cxx> lang2cxx_array(zval* in)
{
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter should be an array");
        throw 42;
    }

    HashTable* ht = Z_ARRVAL_P(in);
    std::vector<Cxx> out;
    size_t s = zend_hash_num_elements(ht);

    for (size_t i = 0; i < s; ++i)
    {
        zval** v;
        zend_hash_index_find(ht, i, (void**)&v);
        out.push_back(lang2cxx<zval*, Cxx>(*v));
    }

    return out;
}
///
// Information sur les cases
//
template <>
zval* cxx2lang<zval*, case_info>(case_info in)
{
    return cxx2lang<zval*, int>((int)in);
}

template <>
case_info lang2cxx<zval*, case_info>(zval* in)
{
    return (case_info)lang2cxx<zval*, int>(in);
}

///
// Erreurs possibles
//
template <>
zval* cxx2lang<zval*, erreur>(erreur in)
{
    return cxx2lang<zval*, int>((int)in);
}

template <>
erreur lang2cxx<zval*, erreur>(zval* in)
{
    return (erreur)lang2cxx<zval*, int>(in);
}

///
// Représente la position sur la carte
//
template <>
zval* cxx2lang<zval*, position>(position in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, int>(in.x));
    add_assoc_zval(ret, "x", tmp);
    tmp = (cxx2lang<zval*, int>(in.y));
    add_assoc_zval(ret, "y", tmp);
    return ret;
}

template <>
position lang2cxx<zval*, position>(zval* in)
{
    position out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "x", 2, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"x\" of struct \"position\" not found");
        throw 42;
    }
    out.x = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "y", 2, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"y\" of struct \"position\" not found");
        throw 42;
    }
    out.y = lang2cxx<zval*, int>(*tmp);
    return out;
}

///
// Représente une tourelle
//
template <>
zval* cxx2lang<zval*, tourelle>(tourelle in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, position>(in.pos));
    add_assoc_zval(ret, "pos", tmp);
    tmp = (cxx2lang<zval*, int>(in.portee));
    add_assoc_zval(ret, "portee", tmp);
    tmp = (cxx2lang<zval*, int>(in.joueur));
    add_assoc_zval(ret, "joueur", tmp);
    tmp = (cxx2lang<zval*, int>(in.vie));
    add_assoc_zval(ret, "vie", tmp);
    tmp = (cxx2lang<zval*, int>(in.attaque));
    add_assoc_zval(ret, "attaque", tmp);
    return ret;
}

template <>
tourelle lang2cxx<zval*, tourelle>(zval* in)
{
    tourelle out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "pos", 4, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"pos\" of struct \"tourelle\" not found");
        throw 42;
    }
    out.pos = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "portee", 7, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"portee\" of struct \"tourelle\" not found");
        throw 42;
    }
    out.portee = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "joueur", 7, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"joueur\" of struct \"tourelle\" not found");
        throw 42;
    }
    out.joueur = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "vie", 4, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"vie\" of struct \"tourelle\" not found");
        throw 42;
    }
    out.vie = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "attaque", 8, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"attaque\" of struct \"tourelle\" not found");
        throw 42;
    }
    out.attaque = lang2cxx<zval*, int>(*tmp);
    return out;
}

///
// Retourne le type de la case à l'emplacement `pos`
//
PHP_FUNCTION(php_api_info_case)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, case_info>(api_info_case(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
//
PHP_FUNCTION(php_api_tourelles_joueur)
{
    zval* _joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_tourelles_joueur(lang2cxx<zval*, int>(_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la magie que possède le joueur ``joueur``
//
PHP_FUNCTION(php_api_magie)
{
    zval* _joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_magie(lang2cxx<zval*, int>(_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
//
PHP_FUNCTION(php_api_nb_sorciers)
{
    zval* _pos;
    zval* _joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos, &_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_nb_sorciers(lang2cxx<zval*, position>(_pos), lang2cxx<zval*, int>(_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
//
PHP_FUNCTION(php_api_nb_sorciers_deplacables)
{
    zval* _pos;
    zval* _joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos, &_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_nb_sorciers_deplacables(lang2cxx<zval*, position>(_pos), lang2cxx<zval*, int>(_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le numéro du joueur qui contrôle la case ``pos``
//
PHP_FUNCTION(php_api_joueur_case)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_joueur_case(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la tourelle située sur la case ``pos``
//
PHP_FUNCTION(php_api_tourelle_case)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, tourelle>(api_tourelle_case(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la position de la base du joueur ``joueur``
//
PHP_FUNCTION(php_api_base_joueur)
{
    zval* _joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, position>(api_base_joueur(lang2cxx<zval*, int>(_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne vrai si l'on peut construire sur la case ``pos``
//
PHP_FUNCTION(php_api_constructible)
{
    zval* _pos;
    zval* _joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos, &_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_constructible(lang2cxx<zval*, position>(_pos), lang2cxx<zval*, int>(_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
//
PHP_FUNCTION(php_api_chemin)
{
    zval* _pos1;
    zval* _pos2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos1, &_pos2) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_chemin(lang2cxx<zval*, position>(_pos1), lang2cxx<zval*, position>(_pos2)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Construire une tourelle à la position ``pos``
//
PHP_FUNCTION(php_api_construire)
{
    zval* _pos;
    zval* _portee;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos, &_portee) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_construire(lang2cxx<zval*, position>(_pos), lang2cxx<zval*, int>(_portee)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Supprimer une tourelle à la position ``pos``
//
PHP_FUNCTION(php_api_supprimer)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_supprimer(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
//
PHP_FUNCTION(php_api_tirer)
{
    zval* _pts;
    zval* _tourelle;
    zval* _cible;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_pts, &_tourelle, &_cible) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_tirer(lang2cxx<zval*, int>(_pts), lang2cxx<zval*, position>(_tourelle), lang2cxx<zval*, position>(_cible)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Créer ``nb`` sorciers dans la base
//
PHP_FUNCTION(php_api_creer)
{
    zval* _nb;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_nb) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_creer(lang2cxx<zval*, int>(_nb)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
//
PHP_FUNCTION(php_api_deplacer)
{
    zval* _depart;
    zval* _arrivee;
    zval* _nb;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_depart, &_arrivee, &_nb) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_deplacer(lang2cxx<zval*, position>(_depart), lang2cxx<zval*, position>(_arrivee), lang2cxx<zval*, int>(_nb)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
//
PHP_FUNCTION(php_api_assieger)
{
    zval* _pos;
    zval* _cible;
    zval* _nb_sorciers;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_pos, &_cible, &_nb_sorciers) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_assieger(lang2cxx<zval*, position>(_pos), lang2cxx<zval*, position>(_cible), lang2cxx<zval*, int>(_nb_sorciers)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le numéro de votre joueur
//
PHP_FUNCTION(php_api_moi)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_moi());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste des numéros de vos adversaires
//
PHP_FUNCTION(php_api_adversaires)
{
        try {
zval* ret = cxx2lang_array(api_adversaires());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le numéro du tour actuel
//
PHP_FUNCTION(php_api_tour_actuel)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_tour_actuel());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la distance entre deux positions
//
PHP_FUNCTION(php_api_distance)
{
    zval* _depart;
    zval* _arrivee;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_depart, &_arrivee) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_distance(lang2cxx<zval*, position>(_depart), lang2cxx<zval*, position>(_arrivee)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Annule la dernière action
//
PHP_FUNCTION(php_api_annuler)
{
        try {
zval* ret = cxx2lang<zval*, erreur>(api_annuler());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type case_info
//
PHP_FUNCTION(php_api_afficher_case_info)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_case_info(lang2cxx<zval*, case_info>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type erreur
//
PHP_FUNCTION(php_api_afficher_erreur)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_erreur(lang2cxx<zval*, erreur>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type position
//
PHP_FUNCTION(php_api_afficher_position)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_position(lang2cxx<zval*, position>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type tourelle
//
PHP_FUNCTION(php_api_afficher_tourelle)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_tourelle(lang2cxx<zval*, tourelle>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

static zend_function_entry module_functions_table[] = {
    PHP_FALIAS(info_case, php_api_info_case, NULL)    PHP_FALIAS(tourelles_joueur, php_api_tourelles_joueur, NULL)    PHP_FALIAS(magie, php_api_magie, NULL)    PHP_FALIAS(nb_sorciers, php_api_nb_sorciers, NULL)    PHP_FALIAS(nb_sorciers_deplacables, php_api_nb_sorciers_deplacables, NULL)    PHP_FALIAS(joueur_case, php_api_joueur_case, NULL)    PHP_FALIAS(tourelle_case, php_api_tourelle_case, NULL)    PHP_FALIAS(base_joueur, php_api_base_joueur, NULL)    PHP_FALIAS(constructible, php_api_constructible, NULL)    PHP_FALIAS(chemin, php_api_chemin, NULL)    PHP_FALIAS(construire, php_api_construire, NULL)    PHP_FALIAS(supprimer, php_api_supprimer, NULL)    PHP_FALIAS(tirer, php_api_tirer, NULL)    PHP_FALIAS(creer, php_api_creer, NULL)    PHP_FALIAS(deplacer, php_api_deplacer, NULL)    PHP_FALIAS(assieger, php_api_assieger, NULL)    PHP_FALIAS(moi, php_api_moi, NULL)    PHP_FALIAS(adversaires, php_api_adversaires, NULL)    PHP_FALIAS(tour_actuel, php_api_tour_actuel, NULL)    PHP_FALIAS(distance, php_api_distance, NULL)    PHP_FALIAS(annuler, php_api_annuler, NULL)    PHP_FALIAS(afficher_case_info, php_api_afficher_case_info, NULL)    PHP_FALIAS(afficher_erreur, php_api_afficher_erreur, NULL)    PHP_FALIAS(afficher_position, php_api_afficher_position, NULL)    PHP_FALIAS(afficher_tourelle, php_api_afficher_tourelle, NULL)    {NULL, NULL, NULL}
};
static zend_module_entry api_module_entry = {
    STANDARD_MODULE_HEADER,
    "api",
    module_functions_table,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    "1.0",
    STANDARD_MODULE_PROPERTIES
};

static void _init_php()
{
    static int initialized = 0;
    if (initialized)
        return;
    initialized = 1;

    char* argv[] = { "champion", NULL };
    char buffer[1024];
    const char* path;
    zend_file_handle script;

    path = getenv("CHAMPION_PATH");
    if (!path)
        path = ".";

    snprintf(buffer, 1024, "include('%s/%s.php');", path, "prologin");

    php_embed_init(1, argv PTSRMLS_CC);
    zend_startup_module(&api_module_entry);
    zend_eval_string(buffer, NULL, "PHP to Stechec interface");
}

///
// Fonction appelée au début de la partie
//
extern "C" void partie_debut()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "partie_debut", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée pendant la phase de construction
//
extern "C" void phase_construction()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "phase_construction", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée pendant la phase de déplacement
//
extern "C" void phase_deplacement()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "phase_deplacement", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée pendant la phase de tirs des tourelles
//
extern "C" void phase_tirs()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "phase_tirs", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée pendant la phase de siège des tourelles
//
extern "C" void phase_siege()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "phase_siege", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée à la fin de la partie
//
extern "C" void partie_fin()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "partie_fin", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

