(* idea for simulations ; put on the shelf *)

type game_board_data = { player_controls : int;
                         num_caravelles : int;
                         num_galleons : int;
                         gold : int; }
  
type game_board = game_board_data array array

let make_current_game_board () =
  let data_null = { player_controls = -1;
                    num_caravelles = 0;
                    num_galleons = 0;
                    gold = 0 } in
  let t = Array.make_matrix taille_terrain taille_terrain data_null in
  for i = 0 to taille_terrain - 1 do
    for j = 0 to taille_terrain - 1 do
      let c = ref 0 and g = ref 0 and boats = liste_bateaux_position (i,j) in
      Array.iter (fun b -> match b.btype with
                           | Bateau_caravelle -> incr c
                           | Bateau_galion -> incr g
                           | Bateau_erreur -> assert false) 
                 boats;
      if List.mem (info_terrain (i,j)) [Terrain_ile; Terrain_volcan]
      then t.(i).(j) <- { player_controls = info_ile_joueur (i,j);
                          num_caravelles = !c;
                          num_galleons = !g;
                          gold = info_ile_or (i,j) }
      else let data = { player_controls = -1;
                        num_caravelles = !c;
                        num_galleons = !g;
                        gold = info_ile_or (i,j) } in 
           (failwith "unfinished") data
    done 
  done


(* opening strategy choice 
   + caravelle management
 *)

type opening = Rush | LowEcon | NormalEcon

(*let opening_choice () = match A.length (liste_iles ()) with
  | 2 -> Rush
  | n when n < 10 -> LowEcon
  | _ -> NormalEcon *)

let opening_choice () = LowEcon

let create_caravelle pos =
  let err = construire Bateau_caravelle pos in
  log_error "create_caravelle" err;
  match err with
  | Ok -> mes_caravelles := id_dernier_bateau_construit () :: !mes_caravelles
  | _ -> assert false

let caravelle_missions = H.create 4

(*
** Fonction appelée à chaque tour
*)
let rec jouer_tour () =  match (tour_actuel (), opening_choice ()) with
  | _, Rush -> normal_turn ()
  | 1, LowEcon -> create_caravelle !ile_depart; normal_turn ()
  | 1, NormalEcon -> create_caravelle !ile_depart
  | 2, NormalEcon -> ()
  | 3, NormalEcon -> create_caravelle !ile_depart; normal_turn ()
  | _ -> normal_turn ()


and normal_turn () =


  (*** colonisation ***)
  (* priorité aux îles non volcaniques *)

  let find_mission crv =
    let is_free ile =
      info_ile_joueur ile = -1 &&
      H.fold (fun _ mission b -> b && mission <> ile) caravelle_missions true
    in
    let free_islands = L.filter is_free (A.to_list (liste_iles ())) in
    let pos_crv = (info_bateau crv).pos in
    let better_target a b =
      match (info_terrain a, info_terrain b) with
      | Terrain_ile, Terrain_volcan -> a
      | Terrain_volcan, Terrain_ile -> b
      | _,_ -> if distance a pos_crv < distance b pos_crv
               then a else b
    in
    if free_islands = [] then None
    else Some (foldl1 better_target free_islands)
  in
  
  let rec move_caravelle crv =
    try
      let mission = H.find caravelle_missions crv in
      log_error "2" (rapprocher_max crv mission);
      if (info_bateau crv).pos = mission
      then log_error "colonisation" (coloniser mission)
    with Not_found -> (match find_mission crv with
                       | None -> () (* for now do nothing *)
                       | Some target -> (
                           H.add caravelle_missions crv target;
                           move_caravelle crv ))
  in

  List.iter (fun crv -> if not (bateau_existe crv)
                        then H.remove caravelle_missions crv)
            !mes_caravelles;
  mes_caravelles := List.filter bateau_existe !mes_caravelles;
  List.iter move_caravelle !mes_caravelles;
  
    (* let target = *)
    (*   let is_free ile = *)
    (*     info_ile_joueur ile = -1 *)
    (*   in *)
    (*   let free_islands = L.filter is_free (A.to_list (liste_iles ())) in *)
    (*   let better_target a b = *)
    (*     match (info_terrain a, info_terrain b) with *)
    (*     | Terrain_ile, Terrain_volcan -> a *)
    (*     | Terrain_volcan, Terrain_ile -> b *)
    (*     | _,_ -> if distance a scout_pos < distance b scout_pos *)
    (*              then a else b *)
    (*   in *)
    (*   if free_islands = [] then None *)
    (*   else Some (foldl1 better_target free_islands) *)
    (* in *)

(*

  let rapprocher_max bat_id ((x,y) as dest) =
    let bat_data = info_bateau bat_id in
    let range = portee bat_data.btype in
    let (xb, yb) as bpos = bat_data.pos in
    if distance bpos dest <= range
    then deplacer bat_id dest
    else let delta_x = x - xb and delta_y = y - yb in
         let target =
           if abs delta_x <= range
           then (x, (nonzero_int_sign delta_y)*(range - abs delta_x) + yb)
           else ((nonzero_int_sign delta_x)*range + xb, yb) in
         deplacer bat_id target
*)
