///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_php.rb
//

#include "interface.hh"

static void _init_php();

template <typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
zval* cxx2lang<zval*, int>(int in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_LONG(x, (long)in);
    return x;
}

template <>
zval* cxx2lang<zval*, bool>(bool in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_BOOL(x, in);
    return x;
}

template <>
zval* cxx2lang<zval*, std::string>(std::string in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_STRINGL(x, in.c_str(), in.length(), true);
    return x;
}

template <typename Cxx>
zval* cxx2lang_array(const std::vector<Cxx>& in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    array_init(x);

    size_t s = in.size();

    for (size_t i = 0; i < s; ++i)
      add_next_index_zval(x, cxx2lang<zval*, Cxx>(in[i]));

    return x;
}

template <typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
int lang2cxx<zval*, int>(zval* in)
{
    if (in->type != IS_LONG) {
        zend_error(E_WARNING, "parameter should be an int");
        throw 42;
    }
    return (int)Z_LVAL_P(in);
}

template <>
bool lang2cxx<zval*, bool>(zval* in)
{
    if (in->type != IS_BOOL) {
        zend_error(E_WARNING, "parameter should be a boolean");
        throw 42;
    }
    return Z_BVAL_P(in);
}

template <>
std::string lang2cxx<zval*, std::string>(zval* in)
{
    if (in->type != IS_STRING) {
        zend_error(E_WARNING, "parameter should be a string");
        throw 42;
    }
    return Z_STRVAL_P(in);
}

template <typename Cxx>
std::vector<Cxx> lang2cxx_array(zval* in)
{
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter should be an array");
        throw 42;
    }

    HashTable* ht = Z_ARRVAL_P(in);
    std::vector<Cxx> out;
    size_t s = zend_hash_num_elements(ht);

    for (size_t i = 0; i < s; ++i)
    {
        zval** v;
        zend_hash_index_find(ht, i, (void**)&v);
        out.push_back(lang2cxx<zval*, Cxx>(*v));
    }

    return out;
}
///
// Type de bateau
//
template <>
zval* cxx2lang<zval*, bateau_type>(bateau_type in)
{
    return cxx2lang<zval*, int>((int)in);
}

template <>
bateau_type lang2cxx<zval*, bateau_type>(zval* in)
{
    return (bateau_type)lang2cxx<zval*, int>(in);
}

///
// Type de terrain
//
template <>
zval* cxx2lang<zval*, terrain>(terrain in)
{
    return cxx2lang<zval*, int>((int)in);
}

template <>
terrain lang2cxx<zval*, terrain>(zval* in)
{
    return (terrain)lang2cxx<zval*, int>(in);
}

///
// Erreurs possibles
//
template <>
zval* cxx2lang<zval*, erreur>(erreur in)
{
    return cxx2lang<zval*, int>((int)in);
}

template <>
erreur lang2cxx<zval*, erreur>(zval* in)
{
    return (erreur)lang2cxx<zval*, int>(in);
}

///
// Représente la position sur la carte
//
template <>
zval* cxx2lang<zval*, position>(position in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, int>(in.x));
    add_assoc_zval(ret, "x", tmp);
    tmp = (cxx2lang<zval*, int>(in.y));
    add_assoc_zval(ret, "y", tmp);
    return ret;
}

template <>
position lang2cxx<zval*, position>(zval* in)
{
    position out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "x", 2, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"x\" of struct \"position\" not found");
        throw 42;
    }
    out.x = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "y", 2, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"y\" of struct \"position\" not found");
        throw 42;
    }
    out.y = lang2cxx<zval*, int>(*tmp);
    return out;
}

///
// Représente un bateau
//
template <>
zval* cxx2lang<zval*, bateau>(bateau in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, int>(in.id));
    add_assoc_zval(ret, "id", tmp);
    tmp = (cxx2lang<zval*, position>(in.pos));
    add_assoc_zval(ret, "pos", tmp);
    tmp = (cxx2lang<zval*, int>(in.joueur));
    add_assoc_zval(ret, "joueur", tmp);
    tmp = (cxx2lang<zval*, bateau_type>(in.btype));
    add_assoc_zval(ret, "btype", tmp);
    tmp = (cxx2lang<zval*, int>(in.nb_or));
    add_assoc_zval(ret, "nb_or", tmp);
    tmp = (cxx2lang<zval*, bool>(in.deplacable));
    add_assoc_zval(ret, "deplacable", tmp);
    return ret;
}

template <>
bateau lang2cxx<zval*, bateau>(zval* in)
{
    bateau out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "id", 3, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"id\" of struct \"bateau\" not found");
        throw 42;
    }
    out.id = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "pos", 4, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"pos\" of struct \"bateau\" not found");
        throw 42;
    }
    out.pos = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "joueur", 7, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"joueur\" of struct \"bateau\" not found");
        throw 42;
    }
    out.joueur = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "btype", 6, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"btype\" of struct \"bateau\" not found");
        throw 42;
    }
    out.btype = lang2cxx<zval*, bateau_type>(*tmp);
    if (zend_hash_find(ht, "nb_or", 6, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"nb_or\" of struct \"bateau\" not found");
        throw 42;
    }
    out.nb_or = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "deplacable", 11, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"deplacable\" of struct \"bateau\" not found");
        throw 42;
    }
    out.deplacable = lang2cxx<zval*, bool>(*tmp);
    return out;
}

///
// Retourne la nature du terrain désigné par ``pos``.
//
PHP_FUNCTION(php_api_info_terrain)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, terrain>(api_info_terrain(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le joueur qui possède l'île à l'emplacement ``pos``. Retourne -1 si l'île est libre ou si la position indiquée n'est pas une île
//
PHP_FUNCTION(php_api_info_ile_joueur)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_info_ile_joueur(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne l'or contenu sur l'île à l'emplacement ``pos``. Retourne -1 si la case spécifiée n'est pas une île.
//
PHP_FUNCTION(php_api_info_ile_or)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_info_ile_or(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le bateau ayant pour identifiant ``id``
//
PHP_FUNCTION(php_api_info_bateau)
{
    zval* _id;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bateau>(api_info_bateau(lang2cxx<zval*, int>(_id)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne vrai si le bateau ayant pour identifiant ``id`` existe et est encore à flots
//
PHP_FUNCTION(php_api_bateau_existe)
{
    zval* _id;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_bateau_existe(lang2cxx<zval*, int>(_id)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste de bateaux à la position ``pos``
//
PHP_FUNCTION(php_api_liste_bateaux_position)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_liste_bateaux_position(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste des ID des bateaux à la position ``pos``
//
PHP_FUNCTION(php_api_liste_id_bateaux_position)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_liste_id_bateaux_position(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste des positions des îles de la carte
//
PHP_FUNCTION(php_api_liste_iles)
{
        try {
zval* ret = cxx2lang_array(api_liste_iles());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la liste des positions des îles qui vous appartiennent
//
PHP_FUNCTION(php_api_mes_iles)
{
        try {
zval* ret = cxx2lang_array(api_mes_iles());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne l'ID du dernier bateau construit. Son comportement n'est pas défini si vous n'avez pas encore créé de bateau à ce tour-ci.
//
PHP_FUNCTION(php_api_id_dernier_bateau_construit)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_id_dernier_bateau_construit());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne la distance entre deux positions
//
PHP_FUNCTION(php_api_distance)
{
    zval* _depart;
    zval* _arrivee;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_depart, &_arrivee) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_distance(lang2cxx<zval*, position>(_depart), lang2cxx<zval*, position>(_arrivee)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Construire un bateau de type ``btype`` sur l'île à la position ``pos``
//
PHP_FUNCTION(php_api_construire)
{
    zval* _btype;
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_btype, &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_construire(lang2cxx<zval*, bateau_type>(_btype), lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Déplace le bateau représenté par l'identifiant ``id`` jusqu'à la position `pos`` (si elle est dans la portée du bateau)
//
PHP_FUNCTION(php_api_deplacer)
{
    zval* _id;
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id, &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_deplacer(lang2cxx<zval*, int>(_id), lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Colonise l'île à la position ``pos``
//
PHP_FUNCTION(php_api_coloniser)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_coloniser(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Charge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
//
PHP_FUNCTION(php_api_charger)
{
    zval* _id;
    zval* _nb_or;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id, &_nb_or) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_charger(lang2cxx<zval*, int>(_id), lang2cxx<zval*, int>(_nb_or)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Décharge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
//
PHP_FUNCTION(php_api_decharger)
{
    zval* _id;
    zval* _nb_or;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id, &_nb_or) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_decharger(lang2cxx<zval*, int>(_id), lang2cxx<zval*, int>(_nb_or)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Transfère ``montant`` or de la caravelle ``id_source`` à la caravelle ``id_dest``
//
PHP_FUNCTION(php_api_transferer)
{
    zval* _montant;
    zval* _id_source;
    zval* _id_dest;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_montant, &_id_source, &_id_dest) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_transferer(lang2cxx<zval*, int>(_montant), lang2cxx<zval*, int>(_id_source), lang2cxx<zval*, int>(_id_dest)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le numéro de votre joueur
//
PHP_FUNCTION(php_api_mon_joueur)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_mon_joueur());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le numéro de votre adversaire
//
PHP_FUNCTION(php_api_adversaire)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_adversaire());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne les scores du joueur désigné par l'identifiant ``id``
//
PHP_FUNCTION(php_api_score)
{
    zval* _id_joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_score(lang2cxx<zval*, int>(_id_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le numéro du tour actuel
//
PHP_FUNCTION(php_api_tour_actuel)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_tour_actuel());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Retourne le nombre de bateaux que possède le joueur désigné par l'identifiant ``id``
//
PHP_FUNCTION(php_api_nombre_bateaux)
{
    zval* _id_joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_nombre_bateaux(lang2cxx<zval*, int>(_id_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type bateau_type
//
PHP_FUNCTION(php_api_afficher_bateau_type)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_bateau_type(lang2cxx<zval*, bateau_type>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type terrain
//
PHP_FUNCTION(php_api_afficher_terrain)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_terrain(lang2cxx<zval*, terrain>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type erreur
//
PHP_FUNCTION(php_api_afficher_erreur)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_erreur(lang2cxx<zval*, erreur>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type position
//
PHP_FUNCTION(php_api_afficher_position)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_position(lang2cxx<zval*, position>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type bateau
//
PHP_FUNCTION(php_api_afficher_bateau)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_bateau(lang2cxx<zval*, bateau>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

static zend_function_entry module_functions_table[] = {
    PHP_FALIAS(info_terrain, php_api_info_terrain, NULL)    PHP_FALIAS(info_ile_joueur, php_api_info_ile_joueur, NULL)    PHP_FALIAS(info_ile_or, php_api_info_ile_or, NULL)    PHP_FALIAS(info_bateau, php_api_info_bateau, NULL)    PHP_FALIAS(bateau_existe, php_api_bateau_existe, NULL)    PHP_FALIAS(liste_bateaux_position, php_api_liste_bateaux_position, NULL)    PHP_FALIAS(liste_id_bateaux_position, php_api_liste_id_bateaux_position, NULL)    PHP_FALIAS(liste_iles, php_api_liste_iles, NULL)    PHP_FALIAS(mes_iles, php_api_mes_iles, NULL)    PHP_FALIAS(id_dernier_bateau_construit, php_api_id_dernier_bateau_construit, NULL)    PHP_FALIAS(distance, php_api_distance, NULL)    PHP_FALIAS(construire, php_api_construire, NULL)    PHP_FALIAS(deplacer, php_api_deplacer, NULL)    PHP_FALIAS(coloniser, php_api_coloniser, NULL)    PHP_FALIAS(charger, php_api_charger, NULL)    PHP_FALIAS(decharger, php_api_decharger, NULL)    PHP_FALIAS(transferer, php_api_transferer, NULL)    PHP_FALIAS(mon_joueur, php_api_mon_joueur, NULL)    PHP_FALIAS(adversaire, php_api_adversaire, NULL)    PHP_FALIAS(score, php_api_score, NULL)    PHP_FALIAS(tour_actuel, php_api_tour_actuel, NULL)    PHP_FALIAS(nombre_bateaux, php_api_nombre_bateaux, NULL)    PHP_FALIAS(afficher_bateau_type, php_api_afficher_bateau_type, NULL)    PHP_FALIAS(afficher_terrain, php_api_afficher_terrain, NULL)    PHP_FALIAS(afficher_erreur, php_api_afficher_erreur, NULL)    PHP_FALIAS(afficher_position, php_api_afficher_position, NULL)    PHP_FALIAS(afficher_bateau, php_api_afficher_bateau, NULL)    {NULL, NULL, NULL}
};
static zend_module_entry api_module_entry = {
    STANDARD_MODULE_HEADER,
    "api",
    module_functions_table,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    "1.0",
    STANDARD_MODULE_PROPERTIES
};

static void _init_php()
{
    static int initialized = 0;
    if (initialized)
        return;
    initialized = 1;

    char* argv[] = { "champion", NULL };
    char buffer[1024];
    const char* path;
    zend_file_handle script;

    path = getenv("CHAMPION_PATH");
    if (!path)
        path = ".";

    snprintf(buffer, 1024, "include('%s/%s.php');", path, "prologin");

    php_embed_init(1, argv PTSRMLS_CC);
    zend_startup_module(&api_module_entry);
    zend_eval_string(buffer, NULL, "PHP to Stechec interface");
}

///
// Fonction appelée au début de la partie
//
extern "C" void partie_init()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "partie_init", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée à chaque tour
//
extern "C" void jouer_tour()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "jouer_tour", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée à la fin de la partie
//
extern "C" void partie_fin()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "partie_fin", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

