#include <bits/stdc++.h>

#include "prologin.hh"

#define FOR(i, n) for(int (i) = 0; (i) < (n); ++(i))
#define FORU(i, a, b) for(int (i) = a; (i) <= (b); ++(i))
#define FORD(i, a, b) for(int (i) = a; (i) >= (b); --(i))

#define GRILLE(i, j) FOR((i), TAILLE_ETABLI) FOR((j), TAILLE_ETABLI)
#define GRILLE2(i, j, pos) GRILLE(i, j) for(position pos = {i, j}; pos.ligne != -1; pos.ligne = -1)

#define MOI 0
#define ADV 1

using namespace std;
using lli = long long int;

case_type met[3] = {PLOMB, FER, CUIVRE};
case_type cat[2] = {SOUFRE, MERCURE};

case_type types[5] = {PLOMB, FER, CUIVRE, SOUFRE, MERCURE};

int joueurs[2];
case_type grilles[2][TAILLE_ETABLI][TAILLE_ETABLI];
map<case_type, vector<position> > cases[2];
echantillon cur_ech;
bool dejaVu[TAILLE_ETABLI][TAILLE_ETABLI];

bool est_met(position, int);
bool est_cat(position, int);
int quantite_transmutation(position, int);

void transmute();
int transmute(position pos, bool tempo = false);

void placer();

/// Fonction appelée au début de la partie.
void partie_init()
{
    srand(time(NULL));
    joueurs[MOI] = moi();
    joueurs[ADV] = adversaire();
}

void update_grille(int id)
{
    cases[id].clear();
    GRILLE(i, j)
    {
        grilles[id][i][j] = type_case({i,j}, joueurs[id]);
        if(cases[id].count(grilles[id][i][j]) == 0)
            cases[id][grilles[id][i][j]] = vector<position>();
        cases[id][grilles[id][i][j]].push_back({i, j});
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    FOR(i, 2)
        update_grille(i);
    cur_ech = echantillon_tour();
    placer();
    if((tour_actuel() + 1) / 2 == NB_TOURS / 2)
    {
        GRILLE(i, j)
            if(est_cat({i, j}, MOI) && quantite_transmutation({i,j}, MOI) >= 0)
            {
                transmute({i,j});
                update_grille(MOI);
            }
        GRILLE(i, j)
            if(est_met({i, j}, MOI) && quantite_transmutation({i,j}, MOI) > 0)
            {
                transmute({i,j});
                update_grille(MOI);
            }
    }
    case_type a = cases[ADV][cur_ech.element1].size() > cases[ADV][cur_ech.element2].size() ? cur_ech.element2 : cur_ech.element1;
    case_type b = types[1] == a ? types[0] : types[1];
    for(auto t : types)
        if(cases[ADV][b].size() > cases[ADV][t].size())
            b = t;
    donner_echantillon({a, b});
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
}

int quantite_transmutation(position pos, int id)
{
    if(est_met(pos, id))
        return quantite_transmutation_or(taille_region(pos, joueurs[id]));
    return quantite_transmutation_catalyseur_or(taille_region(pos, joueurs[id]));
}

void placer()
{
    vector<position_echantillon> coups = placements_possible_echantillon(cur_ech, joueurs[MOI]);
    if(coups.size())
    {
        int id = rand() % coups.size();
        placer_echantillon(coups[id].pos1, coups[id].pos2);
        return;
    }
    vector<position> options;
    GRILLE(i, j)
        dejaVu[i][j] = 0;
    GRILLE2(i, j, pos)
        if(grilles[MOI][i][j] != VIDE && !dejaVu[i][j] && quantite_transmutation(pos, MOI) >= 0)
        {
            vector<position> zone = positions_region(pos, MOI);
            for(auto c : zone)
                dejaVu[c.ligne][c.colonne] = 1;
    //printf("kwak\n");
            int nbA = transmute(pos, true);
    //printf("plop\n");
            if(placements_possible_echantillon(cur_ech, joueurs[MOI]).size())
                options.push_back(pos);
    //printf("coin\n");
            FOR(k, nbA)
                annuler();
        }
    if(options.size())
    {
        auto cmp_options = [&] (const position& a, const position& b) -> bool {
            if(est_cat(a, MOI) && est_met(b, MOI))
                return true;
            if(est_cat(b, MOI) && est_met(a, MOI))
                return false;
            if(est_cat(a, MOI) && est_cat(b, MOI))
                return quantite_transmutation(a, MOI) > quantite_transmutation(b, MOI);
            return quantite_transmutation(a, MOI) < quantite_transmutation(b, MOI);
        };
        sort(options.begin(), options.end(), cmp_options);
        transmute(options[0]);
        update_grille(MOI);
    }
    while(coups.empty())
    {
        coups = placements_possible_echantillon(cur_ech, joueurs[MOI]);
        if(coups.empty())
            transmute();
        else
            placer_echantillon(coups[0].pos1, coups[0].pos2);
    }
}

int transmute(position pos, bool tempo)
{
    int nbA = 1;
    transmuter(pos);
    if(est_cat(pos, MOI) && !tempo)
    {
        int nbC = nombre_catalyseurs();
        while(nbC)
        {
            //printf("coin\n");
            vector<position> valides;
            GRILLE2(i, j, pos)
                if(est_met(pos, ADV))
                    valides.push_back(pos);
            if(valides.empty()) break;
            int i = rand() % valides.size();
            position pos = valides[i];
            catalyser(pos, joueurs[ADV], (case_type)((rand() % 2) + 4));
            ++nbA;
            update_grille(ADV);
            //printf("plop\n");
            //printf("%d\n", nbC);
            --nbC;
        }
    }
    if(!tempo)
        update_grille(MOI);
    return nbA;
}

void transmute()
{
    int maxi = -42;
    position real = {-1, -1};
    GRILLE(i, j)
    {
        if(grilles[MOI][i][j] != VIDE)
        {
            int gain = quantite_transmutation({i, j}, MOI);
            if(grilles[MOI][i][j] != VIDE && gain > maxi)
            {
                maxi = gain;
                real = {i, j};
            }
        }
    }
    transmute(real);
    update_grille(MOI);
}

bool est_met(position pos, int id)
{
    switch(grilles[id][pos.ligne][pos.colonne])
    {
        case PLOMB:
        case FER:
        case CUIVRE:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}

bool est_cat(position pos, int id)
{
    switch(grilles[id][pos.ligne][pos.colonne])
    {
        case SOUFRE:
        case MERCURE:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}





