// TODO : essayer de faire des parties plus grosses, et pas 5 de taille 35 / 5
// TODO : catalyser chez moi pour diminuer l'entropie
// TODO : essayer d'attaquer a d'autres moments que quand je vire plein de catalyseurs

#include <bits/stdc++.h>

#include "prologin.hh"

#define FOR(i, n) for(int (i) = 0; (i) < (n); ++(i))
#define FORU(i, a, b) for(int (i) = a; (i) <= (b); ++(i))
#define FORD(i, a, b) for(int (i) = a; (i) >= (b); --(i))

#define GRILLE(i, j) FOR((i), TAILLE_ETABLI) FOR((j), TAILLE_ETABLI)
#define GRILLE2(i, j, pos) GRILLE(i, j) for(position pos = {i, j}; pos.ligne != -1; pos.ligne = -1)

#define MOI 0
#define ADV 1

using namespace std;
using lli = long long int;

const int oo = 1E9;

int dir[4][2] = {{1,0},{0,1},{-1,0},{0,-1}};

case_type met[3] = {PLOMB, FER, CUIVRE};
case_type cat[2] = {SOUFRE, MERCURE};

case_type types[5] = {PLOMB, FER, CUIVRE, SOUFRE, MERCURE};

int joueurs[2];
case_type grilles[2][TAILLE_ETABLI][TAILLE_ETABLI];
map<case_type, vector<position> > cases[2];
echantillon cur_ech;
bool dejaVu[TAILLE_ETABLI][TAILLE_ETABLI];

bool est_met(position, int);
bool est_cat(position, int);
int quantite_transmutation(position, int);
int taille(position, int);
int libertes(position, int);
int centralite(position, int);
int centralite_vide(position, int);
int isolement(position, int);
void marquer(position, int, bool(& dejaVu)[TAILLE_ETABLI][TAILLE_ETABLI] = dejaVu);
vector<pair<vector<position>, int> > coupes(position, int, int maxi = 2, int last = -1);
int entropie(int);
case_type find_other(position, int);

void catalyse();

int choisir(vector<position_echantillon>&, int, bool simule = false);

void transmute();
int transmute(position pos, bool tempo = false);

void placer();

/// Fonction appelée au début de la partie.
void partie_init()
{
    srand(time(NULL));
    joueurs[MOI] = moi();
    joueurs[ADV] = adversaire();
}

void update_grille(int id)
{
    cases[id].clear();
    GRILLE2(i, j, pos)
    {
        grilles[id][i][j] = type_case(pos, joueurs[id]);
        if(cases[id].count(grilles[id][i][j]) == 0)
            cases[id][grilles[id][i][j]] = vector<position>();
        cases[id][grilles[id][i][j]].push_back(pos);
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    //if(tour_actuel() < 30)
    //    afficher_etablis();
    FOR(i, 2)
        update_grille(i);
    //printf("%d\n", entropie(MOI));
    cur_ech = echantillon_tour();
    FOR(iT, 2)
    {
        bool cont = true;
        while(cont)
        {
            cont = false;
            FOR(i, 2)
                update_grille(i);
            GRILLE2(i, j, pos)
                dejaVu[i][j] = 0;
            int a_met = 0;
            int a_cat = 0;
            GRILLE2(i, j, pos)
                if(!dejaVu[i][j] && grilles[ADV][i][j] != VIDE)
                {
                    marquer(pos, ADV);
                    int ss = taille(pos, ADV);
                    if(ss > 1)
                    {
                        if(est_met(pos, ADV))
                            a_met += ss * ss / 4 - 1;
                        else
                            a_cat += ss - 2;
                    }
                }

            if(a_cat > 1-iT || a_met > 2+2*iT)
            {
                position cata;
                int ss = -1;
                if(a_cat > 2-iT || a_met > 2+2*iT)
                {
                    GRILLE2(i, j, pos)
                        if(est_cat(pos, MOI))
                        {
                            int sz = taille(pos, MOI);
                            if(sz > ss)
                            {
                                ss = sz;
                                cata = pos;
                            }
                        }
                }
                int ss2 = -1;
                position meta;
                if(a_cat > 2-iT)
                {
                    GRILLE2(i, j, pos)
                        if(est_met(pos, MOI))
                        {
                            int sz = taille(pos, MOI);
                            if(sz > ss2)
                            {
                                ss2 = sz;
                                meta = pos;
                            }
                        }
                }
                if(ss2 < a_cat * 3)
                    ss2 = -1;
                if(max(ss2, ss) > 2)
                {
                    if(ss2 > ss)
                        transmute(meta);
                    else
                    {
                        transmuter(cata);
                        catalyse();
                    }
                    cont = iT;
                }
            }
        }
        update_grille(MOI);
        if(iT == 0)
            placer();
    }
    if(tour_actuel() >= NB_TOURS - 2)
    {
        GRILLE(i, j)
            if(est_cat({i, j}, MOI) && quantite_transmutation({i,j}, MOI) >= 0)
            {
                transmute({i,j});
                update_grille(MOI);
            }
        GRILLE(i, j)
            if(est_met({i, j}, MOI) && quantite_transmutation({i,j}, MOI) > 0)
            {
                transmute({i,j});
                update_grille(MOI);
            }
    }
    vector<echantillon> echs;
    FOR(i, 4)
        FORU(j, i+1, 4)
            if(types[i] == cur_ech.element1 || types[j] == cur_ech.element2)
                echs.push_back({types[i], types[j]});

    echantillon best_ech;
    int score = -oo;

    for(auto ech : echs)
    {
        int sco = oo;
        GRILLE2(i, j, p1)
            FOR(k, 4)
            {
                position p2 = {p1.ligne + dir[k][0], p1.colonne + dir[k][1]};
                if(p2.ligne >= 0 && p2.ligne < TAILLE_ETABLI && p2.colonne >= 0 && p2.colonne < TAILLE_ETABLI)
                    if(grilles[ADV][p1.ligne][p1.colonne] == VIDE && grilles[ADV][p2.ligne][p2.colonne] == VIDE)
                    {
                        grilles[ADV][p1.ligne][p1.colonne] = ech.element1;
                        grilles[ADV][p2.ligne][p2.colonne] = ech.element2;

                        sco = min(sco, entropie(ADV));

                        grilles[ADV][p1.ligne][p1.colonne] = VIDE;
                        grilles[ADV][p2.ligne][p2.colonne] = VIDE;
                    }
            }
        if(sco != oo && sco > score)
        {
            score = sco;
            best_ech = ech;
        }
        else if(sco != oo && sco == score)
        {
            assert(score != -oo);
            int a = max(cases[ADV][ech.element1].size(), cases[ADV][ech.element2].size());
            int b = max(cases[ADV][best_ech.element1].size(), cases[ADV][best_ech.element2].size());
            if(a < b)
            {
                score = sco;
                best_ech = ech;
            }
        }
    }
    if(score != -1)
        donner_echantillon(best_ech);
    else
    {
        case_type a = cases[ADV][cur_ech.element1].size() > cases[ADV][cur_ech.element2].size() ? cur_ech.element2 : cur_ech.element1;
        case_type b = types[1] == a ? types[0] : types[1];
        for(auto t : types)
            if(t != a && cases[ADV][b].size() > cases[ADV][t].size())
                b = t;
        donner_echantillon({a, b});
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
}

int quantite_transmutation(position pos, int id)
{
    if(est_met(pos, id))
        return quantite_transmutation_or(taille_region(pos, joueurs[id]));
    return quantite_transmutation_catalyseur_or(taille_region(pos, joueurs[id]));
}

void placer()
{
    vector<position_echantillon> coups = placements_possible_echantillon(cur_ech, joueurs[MOI]);
    if(coups.size())
    {
        choisir(coups, MOI);
        return;
    }
    vector<pair<position, int> > options;
    GRILLE(i, j)
        dejaVu[i][j] = 0;
    GRILLE2(i, j, pos)
        if(grilles[MOI][i][j] != VIDE && !dejaVu[i][j])
        {
            vector<position> zone = positions_region(pos, MOI);
            for(auto c : zone)
                dejaVu[c.ligne][c.colonne] = 1;
    //printf("kwak\n");
            int nbA = transmute(pos, true);
    //printf("plop\n");
            auto cps2 = placements_possible_echantillon(cur_ech, joueurs[MOI]);
            if(cps2.size())
                options.push_back({pos, choisir(cps2, MOI, true)});
    //printf("coin\n");
            FOR(k, nbA)
                annuler();
        }
    update_grille(MOI);
    if(options.size())
    {
        bool cat_first = rand() % 2; // TODO improve this ugly fix
        auto collision = [&] (const position& a) -> bool {
            return grilles[MOI][a.ligne][a.colonne] == echantillon_tour().element1 || grilles[MOI][a.ligne][a.colonne] == echantillon_tour().element2;
        };
        auto cmp_options = [&] (const pair<position, int>& a, const pair<position, int>& b) -> bool {
            if((quantite_transmutation(a.first, MOI) < 1 || quantite_transmutation(b.first, MOI) < 1) && quantite_transmutation(a.first, MOI) != quantite_transmutation(b.first, MOI))
                return quantite_transmutation(a.first, MOI) > quantite_transmutation(b.first, MOI);
            if(collision(a.first) && !collision(b.first))
                return false;
            if(!collision(a.first) && collision(b.first))
                return true;
            if(est_cat(a.first, MOI) && est_met(b.first, MOI))
                return cat_first;
            if(est_cat(b.first, MOI) && est_met(a.first, MOI))
                return !cat_first;
            if(est_cat(a.first, MOI))
            {
                if(a.second > 2 * b.second)
                    return true;
                if(a.second * 2 < b.second)
                    return false;
            }
            else
            {
                if(a.second > 5 * b.second)
                    return true;
                if(a.second * 5 < b.second)
                    return false;
            }
            //if(est_cat(a.first, MOI) && est_cat(b.first, MOI))
            //    return quantite_transmutation(a.first, MOI) + a.second > quantite_transmutation(b.first, MOI) + b.second;
            return quantite_transmutation(a.first, MOI) + b.second < quantite_transmutation(b.first, MOI) + a.second;
        };
        pair<position, int> best = options[0];
        for(auto p : options)
            if(cmp_options(p, best))
                best = p;
        transmute(best.first);
        update_grille(MOI);
    }
    while(coups.empty())
    {
        coups = placements_possible_echantillon(cur_ech, joueurs[MOI]);
        if(coups.empty())
            transmute();
        else
            placer_echantillon(coups[0].pos1, coups[0].pos2);
        update_grille(MOI);
    }
}

int transmute(position pos, bool tempo)
{
    int nbA = 1;
    transmuter(pos);
    if(!tempo)
    {
        if(est_cat(pos, MOI))
            catalyse();
        update_grille(MOI);
    }
    return nbA;
}

void transmute()
{
    int maxi = -42;
    position real = {-1, -1};
    GRILLE(i, j)
    {
        if(grilles[MOI][i][j] != VIDE)
        {
            int gain = quantite_transmutation({i, j}, MOI);
            if(grilles[MOI][i][j] != VIDE && gain > maxi)
            {
                maxi = gain;
                real = {i, j};
            }
        }
    }
    transmute(real);
    update_grille(MOI);
}

bool est_met(position pos, int id)
{
    switch(grilles[id][pos.ligne][pos.colonne])
    {
        case PLOMB:
        case FER:
        case CUIVRE:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}

bool est_cat(position pos, int id)
{
    switch(grilles[id][pos.ligne][pos.colonne])
    {
        case SOUFRE:
        case MERCURE:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}

int taille(position pos, int id)
{
    bool innerDejaVu[TAILLE_ETABLI][TAILLE_ETABLI];
    int rep = 0;
    queue<position> file;
    file.push(pos);
    GRILLE(i, j)
        innerDejaVu[i][j] = 0;
    while(file.size())
    {
        position cur = file.front();
        file.pop();
        if(!innerDejaVu[cur.ligne][cur.colonne])
        {
            ++rep;
            innerDejaVu[cur.ligne][cur.colonne] = true;
            FOR(i, 4)
            {
                position nouv = {cur.ligne + dir[i][0], cur.colonne + dir[i][1]};
                if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                    if(grilles[id][nouv.ligne][nouv.colonne] == grilles[id][pos.ligne][pos.colonne])
                        file.push(nouv);
            }
        }
    }
    return rep;
}

int libertes(position pos, int id)
{
    int rep = 0;
    queue<position> file;
    file.push(pos);
    GRILLE(i, j)
        dejaVu[i][j] = 0;
    while(file.size())
    {
        position cur = file.front();
        file.pop();
        if(!dejaVu[cur.ligne][cur.colonne])
        {
            //if(tour_actuel() == 1)
            //    printf("%d %d %d\n", cur.ligne, cur.colonne, (int)grilles[id][cur.ligne][cur.colonne]);
            dejaVu[cur.ligne][cur.colonne] = true;
            FOR(i, 4)
            {
                position nouv = {cur.ligne + dir[i][0], cur.colonne + dir[i][1]};
                if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                {
                    if(grilles[id][nouv.ligne][nouv.colonne] == grilles[id][pos.ligne][pos.colonne])
                        file.push(nouv);
                    else if(grilles[id][nouv.ligne][nouv.colonne] == VIDE)
                    {
                        if(!dejaVu[nouv.ligne][nouv.colonne])
                        {
                            bool seul = true;
                            FOR(j, 4)
                            {
                                position nnouv = {nouv.ligne + dir[j][0], nouv.colonne + dir[j][1]};
                                if(grilles[id][nnouv.ligne][nnouv.colonne] == VIDE)
                                    seul = false;
                            }
                            if(!seul)
                                ++rep;
                        }
                        dejaVu[nouv.ligne][nouv.colonne] = true;
                    }
                }
            }
        }
    }
    //if(tour_actuel() == 1)
    //    printf("%d %d %d %d\n", pos.ligne, pos.colonne, (int)grilles[id][pos.ligne][pos.colonne], rep);
    return rep * (est_met(pos, id) ? 1 : 1);
}

int centralite(position pos, int id)
{
    int rep = 0;

    GRILLE2(i, j, p)
        if(grilles[id][i][j] == grilles[id][pos.ligne][pos.colonne])
        {
            //rep += abs(i - pos.ligne) + abs(j - pos.colonne); // Distance Manhattan
            rep += (int)sqrt((i - pos.ligne) * (i - pos.ligne) + (j - pos.colonne) * (j - pos.colonne)); // Distance Euclidienne
        }


    return rep;
}

int centralite_vide(position pos, int id)
{
    int rep = 0;

    GRILLE2(i, j, p)
        if(grilles[id][i][j] == VIDE)
        {
            rep += abs(i - pos.ligne) + abs(j - pos.colonne); // Distance Manhattan
            //rep += max(abs(i - pos.ligne), abs(j - pos.colonne)); // Distance loo
            //rep += (int)sqrt((i - pos.ligne) * (i - pos.ligne) + (j - pos.colonne) * (j - pos.colonne)); // Distance Euclidienne
        }


    return rep * (est_met(pos, id) ? 2 : -1);
}

int isolement(position pos, int id)
{
    int rep = 0;

    GRILLE2(i, j, p)
        if(grilles[id][i][j] != grilles[id][pos.ligne][pos.colonne])
        {
            rep += abs(i - pos.ligne) + abs(j - pos.colonne); // Distance Manhattan
            //rep += max(abs(i - pos.ligne), abs(j - pos.colonne)); // Distance loo
            //rep += (int)sqrt((i - pos.ligne) * (i - pos.ligne) + (j - pos.colonne) * (j - pos.colonne)); // Distance Euclidienne
        }


    return rep;
}

int trous(position pos, int id)
{
    int ret = 0;
    FOR(i, 4)
    {
        position nouv = {pos.ligne + dir[i][0], pos.colonne + dir[i][1]};
        if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
            if(grilles[id][nouv.ligne][nouv.colonne] == VIDE)
            {
                int trou = 4;
                FOR(j, 4)
                {
                    position nouv2 = {nouv.ligne + dir[j][0], nouv.colonne + dir[j][1]};
                    if(nouv2.ligne >= 0 && nouv2.ligne < TAILLE_ETABLI && nouv2.colonne >= 0 && nouv2.colonne < TAILLE_ETABLI)
                        if(grilles[id][nouv2.ligne][nouv2.colonne] == VIDE)
                            trou -= 1;
                }
                ret += trou;
            }
    }
    return ret;
}

int choisir(vector<position_echantillon>& coups, int id, bool simule)
{
    assert(coups.size());
    position_echantillon best = coups[0];
    int score = -oo;

    for(auto ech : coups)
    {
        placer_echantillon(ech.pos1, ech.pos2);
        update_grille(id);

        auto libertes_voisins = [&] (position_echantillon pos_ech, int id) -> int {
            int ret = 0;
            FOR(i, 4)
            {
                position nouv = {pos_ech.pos1.ligne + dir[i][0], pos_ech.pos1.colonne + dir[i][1]};
                if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                    if(nouv != pos_ech.pos2
                            && grilles[id][nouv.ligne][nouv.colonne] != VIDE
                            && grilles[id][pos_ech.pos1.ligne][pos_ech.pos1.colonne] != grilles[id][nouv.ligne][nouv.colonne])
                        ret += 1;
                nouv = {pos_ech.pos2.ligne + dir[i][0], pos_ech.pos2.colonne + dir[i][1]};
                if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                    if(nouv != pos_ech.pos1
                            && grilles[id][nouv.ligne][nouv.colonne] != VIDE
                            && grilles[id][pos_ech.pos2.ligne][pos_ech.pos2.colonne] != grilles[id][nouv.ligne][nouv.colonne])
                        ret += 1;
            }
            return ret;
        };

        // TODO prendre en compte quand l'echantillon empeche deux parties de se rejoindre

        int sz1 = taille(ech.pos1, id);
        int sz2 = taille(ech.pos2, id);
        int siz = (est_met(ech.pos1, id) ? sz1 * sz1 : 4 * sz1) + (est_met(ech.pos2, id) ? sz2 * sz2 : 4 * sz2);
        int lib1 = libertes(ech.pos1, id);
        int lib2 = libertes(ech.pos2, id);
        int lib = lib1 * lib1 + lib2 * lib2;
        int liv = libertes_voisins(ech, id);
        int cen = centralite(ech.pos1, id) + centralite(ech.pos2, id);
        int cev1 = centralite_vide(ech.pos1, id);
        int cev2 = centralite_vide(ech.pos2, id);
        int iso = isolement(ech.pos1, id) + isolement(ech.pos2, id);
        int tro = trous(ech.pos1, id) + trous(ech.pos2, id);
        //printf("%d %d %d %d %d\n", ech.pos1.ligne, ech.pos1.colonne, ech.pos2.ligne, ech.pos2.colonne, liv);

        int val = 100 * siz + 10 * (2 * lib - 10 * liv - 15 * cen - 1 * (cev1 + cev2)) + 2 * iso - 50 * tro;// + 10 * entropie(id);
        //int val = 100 * siz + 10 * (2 * lib - 30 * liv - 10 * cen - 2 * cev) + 2 * iso - 250 * tro;
        if(val > score)
        {
            score = val;
            best = ech;
        }
        annuler();
    }
    //printf(" %d %d %d\n", best.pos1.ligne, best.pos1.colonne, score);

    if(!simule)
    {
        placer_echantillon(best.pos1, best.pos2);
        update_grille(MOI);
    }
    return score;
}

vector<pair<vector<position>, int> > coupes(position pos, int id, int maxi, int last)
{
    vector<pair<vector<position>, int> > ret;
    {
        case_type tp = grilles[id][pos.ligne][pos.colonne];
        int sz = taille(pos, id);
        queue<position> file;
        file.push(pos);
        bool innerDejaVu[TAILLE_ETABLI][TAILLE_ETABLI];
        GRILLE(i, j)
            innerDejaVu[i][j] = 0;
        innerDejaVu[pos.ligne][pos.colonne] = true;
        while(file.size())
        {
            position cur = file.front();
            file.pop();
            //printf("%d %d %d\n", (int)file.size(), pos.ligne, pos.colonne);
            grilles[id][cur.ligne][cur.colonne] = VIDE;
            int sum = 0;
            int ss = 0;

            GRILLE(i, j)
                dejaVu[i][j] = 0;
            FOR(i, 4)
            {
                position nouv = {cur.ligne + dir[i][0], cur.colonne + dir[i][1]};
                if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                {
                    if(!innerDejaVu[nouv.ligne][nouv.colonne] && grilles[id][nouv.ligne][nouv.colonne] == tp)
                    {
                        //printf("%d %d -> %d %d %d\n", cur.ligne, cur.colonne, nouv.ligne, nouv.colonne, (int)innerDejaVu[nouv.ligne][nouv.colonne]);
                        innerDejaVu[nouv.ligne][nouv.colonne] = true;
                        file.push(nouv);
                    }
                    if(!dejaVu[nouv.ligne][nouv.colonne] && grilles[id][nouv.ligne][nouv.colonne] == tp)
                    {
                        marquer(nouv, id);

                        int ss2 = taille(nouv, id);
                        ss = max(ss, ss2);
                        sum += ss2 == 1 ? -1 : ss2*ss2 / 4 - 1;
                    }
                }
            }
            if(cur.ligne * TAILLE_ETABLI + cur.colonne > last && ss != sz-1)
            {
                //printf("cps: %d %d %d %d %d\n", ss, sz, nbV, cur.ligne, cur.colonne);
                ret.push_back({{cur}, sum});
            }
            grilles[id][cur.ligne][cur.colonne] = tp;
        }
    }
    if(maxi > 1)
    {
        bool innerDejaVu[TAILLE_ETABLI][TAILLE_ETABLI];
        GRILLE(i, j)
            innerDejaVu[i][j] = 0;
        case_type tp = grilles[id][pos.ligne][pos.colonne];
        queue<position> file;
        file.push(pos);
        GRILLE(i, j)
            innerDejaVu[i][j] = 0;
        while(file.size())
        {
            position cur = file.front();
            file.pop();
            if(!innerDejaVu[cur.ligne][cur.colonne])
            {
                grilles[id][cur.ligne][cur.colonne] = VIDE;
                position vois = {-1, -1};

                innerDejaVu[cur.ligne][cur.colonne] = true;
                FOR(i, 4)
                {
                    position nouv = {cur.ligne + dir[i][0], cur.colonne + dir[i][1]};
                    if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                        if(grilles[id][nouv.ligne][nouv.colonne] == tp)
                        {
                            file.push(nouv);
                            vois = nouv;
                        }
                }
                if(vois.ligne != -1 && cur.ligne * TAILLE_ETABLI + cur.colonne > last)
                {
                    vector<pair<vector<position>, int> > rr = coupes(vois, id, maxi-1, cur.ligne * TAILLE_ETABLI + cur.colonne);
                    for(auto p : rr)
                    {
                        p.first.push_back(cur);
                        ret.push_back(p);
                    }
                }
                grilles[id][cur.ligne][cur.colonne] = tp;
            }
            return ret;
        }
    }
    return ret;
}

int entropie(int id)
{
    int ret = 0;
    GRILLE2(k, j, pos)
        FOR(i, 4)
        {
            position nouv = {k + dir[i][0], j + dir[i][1]};
            if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                if(grilles[id][nouv.ligne][nouv.colonne] != VIDE)
                {
                    ret += grilles[id][k][j] != grilles[id][nouv.ligne][nouv.colonne];
                    ret -= (est_met(pos, id) ? 2 : 2) * (grilles[id][k][j] == grilles[id][nouv.ligne][nouv.colonne]);
                }
        }
    return ret;
}

void marquer(position pos, int id, bool(& dejaVu)[TAILLE_ETABLI][TAILLE_ETABLI])
{
    queue<position> file;
    file.push(pos);
    while(file.size())
    {
        position cur = file.front();
        file.pop();
        if(!dejaVu[cur.ligne][cur.colonne])
        {
            dejaVu[cur.ligne][cur.colonne] = true;
            FOR(i, 4)
            {
                position nouv = {cur.ligne + dir[i][0], cur.colonne + dir[i][1]};
                if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                    if(grilles[id][nouv.ligne][nouv.colonne] == grilles[id][pos.ligne][pos.colonne])
                        file.push(nouv);
            }
        }
    }
}
                            
case_type find_other(position pos, int id)
{
    case_type cible = (case_type)6;
    bool alone = false;
    while(!alone)
    {
        cible = (case_type)((int)cible - 1);
        alone = true;
        FOR(i, 4)
        {
            position nouv = {pos.ligne + dir[i][0], pos.colonne + dir[i][1]};
            if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
                if(grilles[id][pos.ligne][pos.colonne] == cible)
                    alone = false;
        }
    }
    return cible;
}

void catalyse()
{
    while(nombre_catalyseurs())
    {
        FOR(i, 2)
            update_grille(i);

        pair<vector<position>, vector<case_type> > defense;
        int dValue = -oo;

        // Aggrandir le plus grand met / cat
        // Reduire l'entropie                               x
        // (essayer de catalyser deux cases en un coup)
        
        GRILLE2(i, j, pos)
            if(grilles[MOI][i][j] != VIDE)
                FOR(k, 5)
                {
                    auto tp = grilles[MOI][i][j];
                    grilles[MOI][i][j] = types[k];

                    int n_ent = entropie(MOI);
                    if(-n_ent > dValue)
                    {
                        dValue = -n_ent;
                        defense = {{pos}, {types[k]}};
                    }

                    grilles[MOI][i][j] = tp;
                }

        if(grilles[MOI][defense.first[0].ligne][defense.first[0].colonne] == defense.second[0])
        {
            defense.first.clear();
            defense.second.clear();
        }

        // ------------------------------------------------------------

        pair<vector<position>, vector<case_type> > attaque;
        int aValue = -oo;

        // Casser les plus grands met / cat                 o
        // Augmenter l'entropie                             x
        
        // Attaque de composante

        GRILLE(i, j)
            dejaVu[i][j] = 0;
        vector<position> valides;
        GRILLE2(i, j, pos)
            if(!dejaVu[i][j] && type_case(pos, joueurs[ADV]) != VIDE)
            {
                marquer(pos, ADV);
                valides.push_back(pos);
            }

        if(valides.size())
            for(auto p : valides)
            {
                int sz = taille(p, ADV);
                if(sz > 1) // On ne catalyse pas des elements seuls, sans interet
                {
                    // On ne tente pas de couper en plus de 2 endroits
                    auto cps = coupes(p, ADV, min(sz - 1 , min(2, nombre_catalyseurs())));

                    if(cps.size())
                    {
                        vector<position> best_coupe;
                        vector<case_type> type_coupe;
                        int n_score = -oo;
                        for(auto pp : cps)
                            if(pp.second > n_score)
                            {
                                n_score = pp.second;
                                best_coupe = pp.first;
                            }

                        for(auto pp : best_coupe)
                        {
                            type_coupe.push_back(grilles[ADV][pp.ligne][pp.colonne]);
                            grilles[ADV][pp.ligne][pp.colonne] = find_other(pp, ADV);
                        }

                        int n_ent = entropie(ADV);
                        if(-n_ent > aValue)
                        {
                            aValue = -n_ent;
                            attaque = {best_coupe, type_coupe};
                        }

                        FOR(i, (int)best_coupe.size())
                            grilles[ADV][best_coupe[i].ligne][best_coupe[i].colonne] = type_coupe[i];

                        // Version prenant en compte la perte infligee a l'adversaire
                        //
                        //int maxi = -1;
                        //int ss = taille(p, ADV);

                        //for(auto pp : cps)
                        //    maxi = max(maxi, (((ss * ss) / 4 - 1) - pp.second) * 6 / (int)pp.first.size());
                        //if(maxi > bsum)
                        //{
                        //    bsum = maxi;
                        //    best = p;
                        //}
                    }
                }
            }

        // Choisir entre attaque et defense
        auto action = 3 * aValue > 2 * dValue ? attaque : defense;
        auto cible  = 3 * aValue > 2 * dValue ? ADV     : MOI;

        if(!action.first.size())
            return;

        FOR(i, (int)action.first.size())
            catalyser(action.first[i], joueurs[cible], action.second[i]);
    }

    //    else
    //    {
    //        int ss = taille(best, ADV);
    //        vector<pair<vector<position>, int> > cps = coupes(best, ADV, min(ss-1, min(2, nombre_catalyseurs())));
    //        vector<position> coupe;
    //        for(auto pp : cps)
    //            if(bsum == (((ss * ss) / 4 - 1) - pp.second) * 6 / (int)pp.first.size())
    //            {
    //                coupe = pp.first;
    //                break;
    //            }
    //        for(auto p : coupe)
    //        {
    //            case_type cible = (case_type)6;
    //            bool alone = false;
    //            while(!alone)
    //            {
    //                cible = (case_type)((int)cible - 1);
    //                alone = true;
    //                FOR(i, 4)
    //                {
    //                    position nouv = {p.ligne + dir[i][0], p.colonne + dir[i][1]};
    //                    if(nouv.ligne >= 0 && nouv.ligne < TAILLE_ETABLI && nouv.colonne >= 0 && nouv.colonne < TAILLE_ETABLI)
    //                        if(type_case(nouv, joueurs[ADV]) == cible)
    //                            alone = false;
    //                }
    //            }

    //            if(cible != grilles[ADV][p.ligne][p.colonne])
    //            {
    //                catalyser(p, joueurs[ADV], cible); // TODO : choose worst catalyser (or even metal)
    //                ++nbA;
    //            }
    //        }
    //    }
    //    update_grille(ADV);
    //}
}





