#include <bits/stdc++.h>

#include "prologin.hh"

#define FOR(i, n) for(int (i) = 0; (i) < (n); ++(i))
#define FORU(i, a, b) for(int (i) = a; (i) <= (b); ++(i))
#define FORD(i, a, b) for(int (i) = a; (i) >= (b); --(i))

#define GRILLE(i, j) FOR((i), TAILLE_ETABLI) FOR((j), TAILLE_ETABLI)

#define MOI 0
#define ADV 1

using namespace std;
using lli = long long int;

case_type met[3] = {PLOMB, FER, CUIVRE};
case_type cat[2] = {SOUFRE, MERCURE};


int joueurs[2];
case_type grilles[2][TAILLE_ETABLI][TAILLE_ETABLI];
map<case_type, vector<position> > cases[2];
echantillon cur_ech;

bool est_met(position, int);
bool est_cat(position, int);
int quantite_transmutation(position, int);

void transmuter();

void placer();

/// Fonction appelée au début de la partie.
void partie_init()
{
    joueurs[MOI] = moi();
    joueurs[ADV] = adversaire();
}

void update_grille(int id)
{
    cases[id].clear();
    GRILLE(i, j)
    {
        grilles[id][i][j] = type_case({i,j}, joueurs[id]);
        if(cases[id].count(grilles[id][i][j]) == 0)
            cases[id][grilles[id][i][j]] = vector<position>();
        cases[id][grilles[id][i][j]].push_back({i, j});
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    FOR(i, 2)
        update_grille(i);
    cur_ech = echantillon_tour();
    placer();
    if((tour_actuel() + 1) / 2 == NB_TOURS / 2)
    {
        GRILLE(i, j)
            if(est_cat({i, j}, MOI))
            {
                transmuter({i,j});
                update_grille(MOI);
            }
        GRILLE(i, j)
            if(est_met({i, j}, MOI))
            {
                transmuter({i,j});
                update_grille(MOI);
            }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
}

int quantite_transmutation(position pos, int id)
{
    if(est_met(pos, id))
        return quantite_transmutation_or(taille_region(pos, joueurs[id]));
    return quantite_transmutation_catalyseur(taille_region(pos, joueurs[id]));
}

void placer()
{
    vector<position_echantillon> coups;
    while(coups.empty())
    {
        coups = placements_possible_echantillon(cur_ech, joueurs[MOI]);
        if(coups.empty())
            transmuter();
        else
            placer_echantillon(coups[0].pos1, coups[0].pos2);
    }
}

void transmuter()
{
    int maxi = -42;
    position real = {-1, -1};
    GRILLE(i, j)
    {
        if(grilles[MOI][i][j] != VIDE)
        {
            int gain = quantite_transmutation({i, j}, MOI);
            if(grilles[MOI][i][j] != VIDE && gain > maxi)
            {
                maxi = gain;
                real = {i, j};
            }
        }
    }
    transmuter(real);
}

bool est_met(position pos, int id)
{
    switch(grilles[id][pos.ligne][pos.colonne])
    {
        case PLOMB:
        case FER:
        case CUIVRE:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}

bool est_cat(position pos, int id)
{
    switch(grilles[id][pos.ligne][pos.colonne])
    {
        case SOUFRE:
        case MERCURE:
            return 1;
            break;
        default:
            return 0;
            break;
    }
}





