#include <algorithm>
#include <cstdio>
#include <queue>

#include "prologin.hh"

using namespace std;

const int oo = 1E9;

/*Position Position(int x, int y)
{
	Position retour;
	retour.x = x;
	retour.y = y;
	return retour;
}*/

struct Position
{
	int x, y, dist, prop;
	Position(int x = 0, int y = 0, int dist = 0, int prop = -1) : x(x), y(y), dist(dist), prop(prop) {}
	Position operator+(const Position& droite) const
	{
		return Position(x + droite.x, y + droite.y, dist + droite.dist, prop);
	}
	bool operator <(const Position& droite) const
	{
		return dist > droite.dist;
	}
	position pos()
	{
		position retour;
		retour.x = x;
		retour.y = y;
		return retour;
	}
};

case_type type_case(Position pos)
{
	return type_case(pos.pos());
}

Position dirs[4] = {Position(-1,0,1), Position(1,0,1), Position(0,-1,1), Position(0,1,1)};

int id, adv;

void partie_init()
{
	id = moi();
	adv = adversaire();
}

int distMoi[TAILLE_TERRAIN][TAILLE_TERRAIN];
int distAdv[TAILLE_TERRAIN][TAILLE_TERRAIN];

void jouer_tour()
{
	for(int iLig = 0; iLig < TAILLE_TERRAIN; ++iLig)
		for(int iCol = 0; iCol < TAILLE_TERRAIN; ++iCol)
		{	
			distMoi[iCol][iLig] = oo;
			distAdv[iCol][iLig] = oo;
		}
	calculerDists(id);
	calculerDists(adv);
	for(int iLig = 0; iLig < TAILLE_TERRAIN; ++iLig)
		for(int iCol = 0; iCol < TAILLE_TERRAIN; ++iCol)
			if(est_debris(Position(iCol, iLig).pos()) && distMoi[iCol][iLig] < distAdv[iCol][iLig])
			{
				deblayer(Position(iCol, iLig).pos());
				construire(Position(iCol, iLig).pos());
			}
	for(int iAction = 0; iAction < 4; ++iAction)
	{
		int closest = oo;
		int xMin = 0, yMin = 0;
		for(int iLig = 0; iLig < TAILLE_TERRAIN; ++iLig)
			for(int iCol = 0; iCol < TAILLE_TERRAIN; ++iCol)
				if(distMoi[iCol][iLig] != oo && distMoi[iCol][iLig] <= distAdv[iCol][iLig])
				{
					bool utile = false;
					for(int iDir = 0; iDir < 4; ++iDir)
					{
						Position newPos = Position(iCol, iLig) + dirs[iDir];
						utile = utile || (newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && est_libre(newPos.pos()));
					}
					if(utile)
					{
						vector<Position> depart;
						depart.push_back(Position(iCol, iLig));
						int dist = plusProchesPulsars(depart).front().dist;
						if(dist < closest)
						{
							closest = dist;
							xMin = iCol;
							yMin = iLig;
						}
					}
				}
		int newclosest = oo;
		int x = 0, y = 0;
		for(int iDir = 0; iDir < 4; ++iDir)
		{
			Position newPos = Position(xMin, yMin) + dirs[iDir];
			if(newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && est_libre(newPos.pos()))
			{
				vector<Position> depart;
				depart.push_back(newPos);
				int dist = plusProchesPulsars(depart).front().dist;
				if(dist < newclosest)
				{
					newclosest = dist;
					x = newPos.x;
					y = newPos.y;
				}
			}
		}
		if(newclosest <= closest)
		{
			construire(Position(x, y).pos());
			distMoi[x][y] = distMoi[xMin][yMin] + 1;
		}
	}
	for(int iLig = 0; iLig < TAILLE_TERRAIN; ++iLig)
		for(int iCol = 0; iCol < TAILLE_TERRAIN; ++iCol)
			if(distMoi[iCol][iLig] != oo && distMoi[iCol][iLig] < distAdv[iCol][iLig])
				ameliorer(Position(iCol, iLig).pos());
	auto base = ma_base();
	for(auto pos = base.begin(); pos != base.end(); ++pos)
		if(puissance_aspiration(*pos) < LIMITE_ASPIRATION)
		{
			bool utile = false;
			for(int iDir = 0; iDir < 4; ++iDir)
			{
				Position newPos = Position(pos->x, pos->y) + dirs[iDir];
				utile = utile || (newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && (est_tuyau(newPos.pos()) || est_debris(newPos.pos())));
			}
			if(utile)
				for(int iDir = 0; iDir < 4; ++iDir)
				{
					Position newPos = Position(pos->x, pos->y) + dirs[iDir] + dirs[iDir];
					deplacer_aspiration(newPos.pos(), *pos);
					newPos = newPos + dirs[iDir];
					deplacer_aspiration(newPos.pos(), *pos);
					newPos = newPos + dirs[iDir];
					deplacer_aspiration(newPos.pos(), *pos);
					newPos = newPos + dirs[iDir];
					deplacer_aspiration(newPos.pos(), *pos);
				}
		}
}

void partie_fin()
{
}

int idDejaVu = 0;
int dejaVu[TAILLE_TERRAIN][TAILLE_TERRAIN];

void calculerDists(int joueur)
{
	++idDejaVu;
	priority_queue<Position> file;
	vector<position> base;
	if(joueur == id)
	{
		base = ma_base();
		for(auto pos = base.begin(); pos != base.end(); ++pos)
			file.push(Position(pos->x, pos->y, -puissance_aspiration(*pos)));
	}
	else
	{
		base = base_ennemie();
		for(auto pos = base.begin(); pos != base.end(); ++pos)
			file.push(Position(pos->x, pos->y, -puissance_aspiration(*pos)));
	}
	while(file.size())
	{
		Position curPos = file.top();
		file.pop();
		if(dejaVu[curPos.x][curPos.y] < idDejaVu)
		{
			dejaVu[curPos.x][curPos.y] = idDejaVu;
			if(joueur == id)
				distMoi[curPos.x][curPos.y] = curPos.dist;
			else
				distAdv[curPos.x][curPos.y] = curPos.dist;
			for(int iDir = 0; iDir < 4; ++iDir)
			{
				Position newPos = curPos + dirs[iDir];
				if(newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && (est_tuyau(newPos.pos()) || est_debris(newPos.pos())))
					file.push(newPos);
			}
		}
	}
}

bool pulsarDispo(Position pos)
{
	for(int iDir = 0; iDir < 4; ++iDir)
	{
		Position newPos = pos + dirs[iDir];
		if(newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && est_libre(newPos.pos()))
			return true;
	}
	return false;
}

vector<Position> plusProchesPulsars(vector<Position> departs)
{
	++idDejaVu;
	queue<Position> file;
	vector<Position> reponse;
	for(auto depart = departs.begin(); depart != departs.end(); ++depart)
		file.push(*depart);
	while(file.size() && (reponse.empty() || reponse.front().dist < file.front().dist))
	{
		Position curPos = file.front();
		file.pop();
		if(curPos.dist != 1 && type_case(curPos) == PULSAR && info_pulsar(curPos.pos()).pulsations_restantes && pulsarDispo(curPos))
			reponse.push_back(curPos);
		if(dejaVu[curPos.x][curPos.y] < idDejaVu && type_case(curPos) != PULSAR)
		{
			dejaVu[curPos.x][curPos.y] = idDejaVu;
			for(int iDir = 0; iDir < 4; ++iDir)
			{
				Position newPos = curPos + dirs[iDir];
				if(newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && type_case(newPos) != TUYAU && type_case(newPos) != SUPER_TUYAU && type_case(newPos) != INTERDIT)
					file.push(newPos);
			}
		}
	}
	if(reponse.empty())
		reponse.push_back(Position(0, 0, oo));
	return reponse;
}
