#include <algorithm>
#include <cstdio>
#include <queue>

#include "prologin.hh"

using namespace std;

const int oo = 1E9;
const int MOI = 1;
const int ADV = 0;

struct Case
{
	int distBase[2], dejaVu;
	Case()
	{
		distBase[ADV] = oo;
		distBase[MOI] = oo;
		dejaVu = 0;
	}
};

Case grille[TAILLE_TERRAIN][TAILLE_TERRAIN];

struct Position
{
	int x, y;
	Position(int x = 0, int y = 0) : x(x), y(y) {}
	Position operator+(const Position& droite) const
	{
		return Position(x + droite.x, y + droite.y);
	}
	bool withinBounds()
	{
		return (x >= 0 && x < TAILLE_TERRAIN && y >= 0 && y < TAILLE_TERRAIN && type_case(*this) != INTERDIT);
	}
	vector<Position> voisins();
	position pos()
	{
		position retour;
		retour.x = x;
		retour.y = y;
		return retour;
	}
	Case getGrille() const
	{
		return grille[x][y];
	}
	int newPlasma()
	{
		int plasma = 0;
		auto neighbours = this->voisins();
		for(auto voisin = neighbours.begin(); voisin != neighbours.end(); ++voisin)
			if(est_pulsar(voisin->pos()))
				plasma += plasmaRestant(*voisin);
		return plasma;
	}
};

Position dirs[4] = {Position(-1,0), Position(1,0), Position(0,-1), Position(0,1)};

vector<Position> Position::voisins()
{
	vector<Position> retour;
	for(int iDir = 0; iDir < 4; ++iDir)
		if((*this + dirs[iDir]).withinBounds())
			retour.push_back(*this + dirs[iDir]);
	return retour;
}

struct Chemin
{
	Position pos;
	int longueur;
	int score;
	Position depart;
	Chemin(Position pos = Position(-1,-1), int longueur = 0, int score = 0, Position depart = Position(-1,-1)) : pos(pos), longueur(longueur), score(score), depart(depart) {}
	Chemin operator + (const Chemin& droite) const
	{
		return Chemin(pos + droite.pos, longueur + droite.longueur, score + droite.score, (depart.x == -1) ? pos + droite.pos : depart);
	}
	bool operator < (const Chemin& droite) const
	{
		if(longueur + depart.getGrille().distBase[MOI] - score != droite.longueur + droite.depart.getGrille().distBase[MOI] - droite.score)
			return longueur + depart.getGrille().distBase[MOI] - score > droite.longueur + droite.depart.getGrille().distBase[MOI] - droite.score;
		if(longueur - score != droite.longueur - droite.score)
			return longueur - score > droite.longueur - droite.score;
		return longueur > droite.longueur;
	}
	vector<Chemin> voisins()
	{
		vector<Chemin> retour;
		for(int iDir = 0; iDir < 4; ++iDir)
			if((this->pos + dirs[iDir]).withinBounds())
				retour.push_back(*this + Chemin(dirs[iDir], 1));
		return retour;
	}
};

int id, adv;
int idDejaVu = 0;

void partie_init()
{
	id = moi();
	adv = adversaire();
}

void jouer_tour()
{
	for(int iAction = 0; iAction < 4 && points_action(); ++iAction)
	{
		idDejaVu = 0;
		for(int x = 0; x < TAILLE_TERRAIN; ++x)
			for(int y = 0; y < TAILLE_TERRAIN; ++y)
				grille[x][y] = Case();
		calculerDistBase(id);
		calculerDistBase(adv);
		vector<Position> myNetwork;
		for(int x = 0; x < TAILLE_TERRAIN; ++x)
			for(int y = 0; y < TAILLE_TERRAIN; ++y)
				if(grille[x][y].distBase[MOI] != oo && grille[x][y].distBase[MOI] <= grille[x][y].distBase[ADV] && (est_tuyau(Position(x,y).pos()) || type_case(Position(x,y)) == BASE))
					myNetwork.push_back(Position(x, y));
		priority_queue<Chemin> coups = reliures(myNetwork);
		if(coups.size())
		{
			Chemin coup = coups.top();
			deblayer(coup.depart.pos());
			construire(coup.depart.pos());
		}
		//*
		while(coups.size())
		{
			Chemin coup = coups.top();
			coups.pop();
			printf("%d %d / %d / %d %d\n", coup.depart.x, coup.depart.y, coup.longueur, coup.pos.x, coup.pos.y);
		}
		printf("\n");
		//*/
	}
	/*
	for(int iLig = 0; iLig < TAILLE_TERRAIN; ++iLig)
		for(int iCol = 0; iCol < TAILLE_TERRAIN; ++iCol)
			if(est_debris(Position(iCol, iLig).pos()) && distMoi[iCol][iLig] < distAdv[iCol][iLig])
			{
				deblayer(Position(iCol, iLig).pos());
				construire(Position(iCol, iLig).pos());
			}
	for(int iAction = 0; iAction < 4; ++iAction)
	{
		int closest = oo;
		int xMin = 0, yMin = 0;
		for(int iLig = 0; iLig < TAILLE_TERRAIN; ++iLig)
			for(int iCol = 0; iCol < TAILLE_TERRAIN; ++iCol)
				if(distMoi[iCol][iLig] != oo && distMoi[iCol][iLig] <= distAdv[iCol][iLig])
				{
					bool utile = false;
					for(int iDir = 0; iDir < 4; ++iDir)
					{
						Position newPos = Position(iCol, iLig) + dirs[iDir];
						utile = utile || (newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && est_libre(newPos.pos()));
					}
					if(utile)
					{
						vector<Position> depart;
						depart.push_back(Position(iCol, iLig));
						int dist = plusProchesPulsars(depart, type_case(Position(iCol, iLig)) == BASE).top().prop;
						if(dist < closest)
						{
							closest = dist;
							xMin = iCol;
							yMin = iLig;
						}
					}
				}
		int newclosest = oo;
		int x = 0, y = 0;
		for(int iDir = 0; iDir < 4; ++iDir)
		{
			Position newPos = Position(xMin, yMin) + dirs[iDir];
			if(newPos.x >= 0 && newPos.x < TAILLE_TERRAIN && newPos.y >= 0 && newPos.y < TAILLE_TERRAIN && est_libre(newPos.pos()))
			{
				vector<Position> depart;
				depart.push_back(newPos);
				int dist = plusProchesPulsars(depart, type_case(newPos) == BASE).top().prop;
				if(dist < newclosest)
				{
					newclosest = dist;
					x = newPos.x;
					y = newPos.y;
				}
			}
		}
		if(newclosest <= closest)
		{
			construire(Position(x, y).pos());
			distMoi[x][y] = distMoi[xMin][yMin] + 1;
		}
	}
				*/
	for(int x = 0; x < TAILLE_TERRAIN; ++x)
		for(int y = 0; y < TAILLE_TERRAIN; ++y)
			if(grille[x][y].distBase[MOI] != oo && grille[x][y].distBase[MOI] < grille[x][y].distBase[ADV])
				ameliorer(Position(x, y).pos());
	auto base = ma_base();
	for(auto pos = base.begin(); pos != base.end(); ++pos)
		if(puissance_aspiration(*pos) < LIMITE_ASPIRATION)
		{
			if(baseUtile(Position(pos->x, pos->y)))
				for(int i = 2; i < 6; ++i)
					for(int iDir = 0; iDir < 4; ++iDir)
					{
						Position newPos = Position(pos->x, pos->y);
						for(int j = 0; j < i; ++j)
							newPos = newPos + dirs[iDir];
						if(type_case(newPos) == BASE && !baseUtile(newPos))
							deplacer_aspiration(newPos.pos(), *pos);
					}
		}
}

void partie_fin()
{
}

void calculerDistBase(int joueur)
{
	++idDejaVu;
	priority_queue<Chemin> file;
	vector<position> base = (joueur == id) ? ma_base() : base_ennemie();
	for(auto pos = base.begin(); pos != base.end(); ++pos)
		file.push(Chemin(Position(pos->x, pos->y), -puissance_aspiration(*pos)));
	while(file.size())
	{
		Chemin curPos = file.top();
		file.pop();
		if(curPos.pos.getGrille().dejaVu < idDejaVu)
		{
			grille[curPos.pos.x][curPos.pos.y].dejaVu = idDejaVu;
			grille[curPos.pos.x][curPos.pos.y].distBase[joueur == id] = curPos.longueur;
			if(type_case(curPos.pos) == BASE || est_tuyau(curPos.pos.pos()))
			{
				auto voisins = curPos.voisins();
				for(auto voisin = voisins.begin(); voisin != voisins.end(); ++voisin)
					file.push(*voisin);
			}
		}
	}
}

priority_queue<Chemin> reliures(vector<Position> departs)
{
	bool enablePipes = true;
	auto pulsars = liste_pulsars();
	for(auto pulsar = pulsars.begin(); pulsar != pulsars.end(); ++pulsar)
		enablePipes = enablePipes && !pulsarAccessible(Position(pulsar->x, pulsar->y));
	++idDejaVu;
	queue<Chemin> file;
	priority_queue<Chemin> reponse;
	for(auto depart = departs.begin(); depart != departs.end(); ++depart)
		file.push(Chemin(*depart));
	while(file.size())
	{
		Chemin curPos = file.front();
		file.pop();
		if(curPos.pos.getGrille().dejaVu < idDejaVu)
		{
			grille[curPos.pos.x][curPos.pos.y].dejaVu = idDejaVu;
			if(curPos.longueur > 0)
			{
				curPos.score = curPos.pos.newPlasma();
				if(curPos.pos.newPlasma())
					reponse.push(curPos);
				curPos.score = -curPos.pos.getGrille().distBase[MOI];
				if(enablePipes && curPos.depart.x != -1 && est_tuyau(curPos.pos.pos()))
					reponse.push(curPos);
			}
			if(curPos.longueur == 0 || type_case(curPos.pos) == VIDE || type_case(curPos.pos) == DEBRIS)// || (curPos.depart.x != -1 && est_tuyau(curPos.pos.pos())))
			{
				auto voisins = curPos.voisins();
				for(auto voisin = voisins.begin(); voisin != voisins.end(); ++voisin)
					if(!est_pulsar(voisin->pos.pos()) && (!est_tuyau(voisin->pos.pos()) || voisin->pos.x != voisin->depart.x || voisin->pos.y != voisin->depart.y))
						file.push(*voisin);
			}
		}
	}
	return reponse;
}

case_type type_case(Position pos)
{
	return type_case(pos.pos());
}

int plasmaRestant(Position pulsar)
{
	pulsar_info info = info_pulsar(pulsar.pos());
	return info.pulsations_restantes * info.puissance;
}

bool pulsarAccessible(Position pulsar)
{
	auto voisins = pulsar.voisins();
	for(auto voisin = voisins.begin(); voisin != voisins.end(); ++voisin)
		if(est_libre(voisin->pos()))
			return true;
	return false;
}

bool baseUtile(Position base)
{
	auto voisins = base.voisins();
	for(auto voisin = voisins.begin(); voisin != voisins.end(); ++voisin)
		if(est_tuyau(voisin->pos()))
			return true;
	return false;
}
