#include "placement.hh"

using namespace std;

bool can_place(echantillon e) {
    vector<position_echantillon> choices = placements_possible_echantillon(e, moi());
    return choices.size() > 0;
}

position_echantillon get_placement_echantillon(echantillon e) {
    vector<position_echantillon> choices = placements_possible_echantillon(e, moi());

    // On minimise le nombre de composantes
    sort(begin(choices), end(choices), [](auto a, auto b) {
        if(a.pos1.ligne == a.pos2.ligne && b.pos1.ligne != b.pos2.ligne)
            return false;
        else if(a.pos1.ligne != a.pos2.ligne && b.pos1.ligne == b.pos2.ligne)
            return true;
        else
            return rand() < 0.5;
    });

    // On minimise le nombre de composantes
    sort(begin(choices), end(choices), [](auto a, auto b) {
        placer_echantillon(a.pos1, a.pos2);
        int s_a = count_composantes();
        annuler();
        placer_echantillon(b.pos1, b.pos2);
        int s_b = count_composantes();
        annuler();

        placer_echantillon(a.pos1, a.pos2);
        int d_a = 0;
        position p, q;
        for(p.ligne=0 ; p.ligne < 6 ; p.ligne++) {
            for(p.colonne=0 ; p.colonne < 6 ; p.colonne++) {
                for(q.ligne=0 ; q.ligne < 6 ; q.ligne++) {
                    for(q.colonne=0 ; q.colonne < 6 ; q.colonne++) {
                        if(!est_vide(p, moi()) && !est_vide(q, moi())) {
                            if(type_case(p, moi()) != type_case(q, moi()))
                                d_a += abs(p.colonne-q.colonne) + abs(p.ligne-q.ligne);
                        }
                    }
                }
            }
        }
        annuler();

        placer_echantillon(b.pos1, b.pos2);
        int d_b = 0;
        for(p.ligne=0 ; p.ligne < 6 ; p.ligne++) {
            for(p.colonne=0 ; p.colonne < 6 ; p.colonne++) {
                for(q.ligne=0 ; q.ligne < 6 ; q.ligne++) {
                    for(q.colonne=0 ; q.colonne < 6 ; q.colonne++) {
                        if(!est_vide(p, moi()) && !est_vide(q, moi())) {
                            if(type_case(p, moi()) != type_case(q, moi()))
                                d_b += abs(p.colonne-q.colonne) + abs(p.ligne-q.ligne);
                        }
                    }
                }
            }
        }
        annuler();

        if(s_a == s_b) {
            return d_a > d_b;
        }
        return s_a < s_b;
    });

    return choices[0];
}
