#include "give.hh"
#include <iostream>
using namespace std;

vector<case_type> materials({PLOMB, FER, CUIVRE, SOUFRE, MERCURE});

vector<int> occurences(int joueur) {
    vector<int> ret(materials.size(), 0);
    position p;
    for(p.ligne=0 ; p.ligne < 6 ; p.ligne++) {
        for(p.colonne=0 ; p.colonne < 6 ; p.colonne++) {
            if(!est_vide(p, joueur)) {
                int i = find(begin(materials), end(materials), type_case(p, joueur)) - begin(materials);
                ret[i]++;
            }
        }
    }
    return ret;
}

echantillon chose_gift() {
    vector<int> occur = occurences(adversaire());

    vector<tuple<int, case_type>> choix(materials.size());
    for(int i=0 ; i < materials.size() ; i++) {
        choix[i] = make_tuple(occur[i], materials[i]);
    }
    sort(begin(choix), end(choix));

    echantillon ret;
    int x;
    tie(x, ret.element1) = choix[0];
    for(int i=1 ; i < materials.size() ; i++) {
        tie(x, ret.element2) = choix[i];
        if(donner_echantillon(ret) == OK) {
            annuler();
            break;
        }
    }
    return ret;
}
