/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <tuple>

#include "prologin.hh"
#include "placement.hh"
#include "liberate.hh"
#include "composantes.hh"
#include "give.hh"

using namespace std;

/// Fonction appelée au début de la partie.
void partie_init() {
    srand( time(0) );
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
    printf("##### Joueur %d #####\n", moi());

    while(!can_place(echantillon_tour())) {
        position to_erase = get_region_to_clean();
        transmuter(to_erase);
    }

    position_echantillon placement = get_placement_echantillon( echantillon_tour() );
    placer_echantillon(placement.pos1, placement.pos2);

    auto echant = chose_gift();
    printf("Donner un echantillon : %d\n", donner_echantillon(echant));

    if(nombre_catalyseurs() > 0) {
        printf("Il me reste %d catalyseurs pour defendre\n", nombre_catalyseurs());

        auto path = get_catalyse_path();
        position a = path[0];
        if(path.size() > 2) {
            for(int i=1 ; i+1 < path.size() ; i++) {
                printf("Catalyser : %d\n", catalyser(path[i], moi(), type_case(a, moi())));
            }
        }
    }

    if(nombre_catalyseurs() > 0)
        printf("Il me reste %d catalyseurs pour attaquer\n", nombre_catalyseurs());

    vector<bool> changed(false, 26);
    vector<tuple<position, case_type>> agro = get_attack_cells();
    for(int i=0 ; i < agro.size() && nombre_catalyseurs() > 0 ; i++)  {
        case_type m;
        position p;
        tie(p, m) = agro[i];
        if(!changed[HASH(p)]) {
            catalyser(p, adversaire(), m);
            changed[HASH(p)] = true;
        }
    }

    /* ******************************************************** */

    if(tour_actuel() > 148) {
        position p;
        for(p.ligne=0 ; p.ligne < 6 ; p.ligne++) {
            for(p.colonne=0 ; p.colonne < 6 ; p.colonne++) {
                if(!est_vide(p, moi())) {
                    if(quantite_transmutation_or(taille_region(p, moi())) > 0) {
                        transmuter(p);
                    }
                }
            }
        }
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin(){
    // fonction a completer
}
