from api import *
from enum import IntEnum

import patern as pat
import map
import bases

dist_lui =  None
dist_moi = None
ecart_max = None

def calculer_distances() :
	global dist_lui, dist_moi, ecart_max
	dist_moi = [[ float("inf") for i in range(TAILLE_TERRAIN) ] for j in range(TAILLE_TERRAIN) ]
	dist_lui = [[ float("inf") for i in range(TAILLE_TERRAIN) ] for j in range(TAILLE_TERRAIN) ]
	
	moi, moi_next = [], []
	lui, lui_next = [], []
	for profondeur in range(-LIMITE_ASPIRATION, TAILLE_TERRAIN**2) :
		moi += [ base for base in ma_base() if puissance_aspiration(base) == -profondeur ]
		lui += [ base for base in base_ennemie() if puissance_aspiration(base) == -profondeur ]
		
		for (x, y) in moi :
			if dist_moi[x][y] == float("inf") :
				dist_moi[x][y] = profondeur
				for next in pat.membres((x, y), pat.adjacents) :
					if est_tuyau(next) :
						moi_next.append(next)
		
		for (x, y) in lui :
			if dist_lui[x][y] == float("inf") :
				dist_lui[x][y] = profondeur
				for next in pat.membres((x, y), pat.adjacents) :
					if est_tuyau(next) :
						lui_next.append(next)
						
		moi = moi_next[:]
		lui = lui_next[:]
		moi_next = [ base for base in ma_base() if puissance_aspiration(base) == profondeur ]
		lui_next = [ base for base in base_ennemie() if puissance_aspiration(base) == profondeur ]
	
	ecart_max = calculer_ecart()

def calculer_ecart() :
	retour = 0
	for x in range(TAILLE_TERRAIN) :
		for y in range(TAILLE_TERRAIN) :
			if dist_moi[x][y] < float('inf') and type_case((x, y)) != case_type.BASE :
				dist_base = map.distance((x,y), map.proche_base((x,y)))
				retour = max(retour, abs(dist_moi[x][y]))
	return retour

def eloignement_pulsar(pos, j) :
	retour = float("inf")
	for (x,y) in pat.membres(pos, pat.adjacents) :
		if j != bases.joueur.lui :
			retour = min(retour, dist_moi[x][y])
		if j != bases.joueur.moi :
			retour = min(retour, dist_lui[x][y])
	return retour

def mon_tuyau(pos) :
	x, y = pos
	return dist_lui[x][y] <= dist_moi[x][y]

def son_tuyau(pos) :
	x, y = pos
	return dist_lui[x][y] >= dist_moi[x][y]

def attirant_depart(A) : # /!\ clone dans 'map'
	cases_connectees = liste_tuyaux() + [ pos for pos in ma_base() if not est_debris(pos) ]
	retour = A
	min = dist_moi[A[0]][A[1]]
	for (x,y) in cases_connectees :
		if map.distance(A, (x,y)) + dist_moi[x][y] < min :
			min = map.distance(A, (x,y)) + dist_moi[x][y]
			retour = (x,y)
	return retour
	
def dist_base_proche(A) :
	x,y = attirant_depart(A)
	return map.distance(A,(x,y)) + dist_moi[x][y]

def dist_attirant_proche(A) :
	return map.dist(A, attirant_depart(A))

