/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_c.rb
*/

#include <stdlib.h>
#include <stdbool.h>

/*!
** Taille du terrain (longueur et largeur).
*/
# define TAILLE_TERRAIN            39

/*!
** Longueur de chacune de vos deux bases.
*/
# define LONGUEUR_BASE             13

/*!
** Nombre de tours à jouer avant la fin de la partie.
*/
# define NB_TOURS                  100

/*!
** Nombre de points d'action par tour.
*/
# define NB_POINTS_ACTION          4

/*!
** Nombre de points d'action que coûte la construction d'un tuyau.
*/
# define COUT_CONSTRUCTION         1

/*!
** Nombre de points d'action que coûte l'amélioration d'un tuyau.
*/
# define COUT_AMELIORATION         1

/*!
** Nombre de points d'action que coûte la destruction d'un tuyau.
*/
# define COUT_DESTRUCTION          3

/*!
** Nombre de points d'action que coûte la destruction d'un Super Tuyau™.
*/
# define COUT_DESTRUCTION_SUPER_TUYAU 4

/*!
** Charge en plasma nécessaire pour la destruction d'un tuyau ou d'un Super Tuyau™.
*/
# define CHARGE_DESTRUCTION        2.0

/*!
** Nombre de points d'action que coûte le déblayage d'une case de débris.
*/
# define COUT_DEBLAYAGE            2

/*!
** Nombre de points d'action que coûte le déplacement d'une unité de puissance d'aspiration de la base (la première modification de chaque tour est offerte).
*/
# define COUT_MODIFICATION_ASPIRATION 1

/*!
** Limite de puissance d'aspiration sur une case de base.
*/
# define LIMITE_ASPIRATION         5

/*!
** Vitesse du plasma dans un tuyau normal, en nombre de cases par tour.
*/
# define VITESSE_TUYAU             1

/*!
** Multiplicateur de la vitesse du plasma dans un Super Tuyau™.
*/
# define MULTIPLICATEUR_VITESSE_SUPER_TUYAU 2

/*!
** Erreurs possibles
*/
typedef enum erreur {
  OK, /* <- L'action a été exécutée avec succès. */
  PA_INSUFFISANTS, /* <- Vous ne possédez pas assez de points d'action pour cette action. */
  AUCUN_TUYAU, /* <- Il n'y a pas de tuyau à la position spécifiée. */
  POSITION_INVALIDE, /* <- La position spécifiée est hors de la carte. */
  PUISSANCE_INSUFFISANTE, /* <- Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base. */
  DEPLACEMENT_INVALIDE, /* <- Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même. */
  PAS_DANS_BASE, /* <- Cette case n'appartient pas à votre base. */
  AMELIORATION_IMPOSSIBLE, /* <- Il y a déjà un Super Tuyau™ sur cette case. */
  CONSTRUCTION_IMPOSSIBLE, /* <- Il est impossible de construire un tuyau à la position indiquée. */
  DESTRUCTION_IMPOSSIBLE, /* <- Il n'y a pas de tuyau à la position spécifiée. */
  PAS_DE_PULSAR, /* <- Il n'y a pas de pulsar à la position spécifiée. */
  PAS_DE_DEBRIS, /* <- Il n'y a pas de débris à la position spécifiée. */
  CHARGE_INSUFFISANTE, /* <- Vous ne possédez pas assez de plasma pour lancer une destruction. */
  LIMITE_ASPIRATION_ATTEINTE, /* <- Vous avez atteint la limite d'aspiration sur cette case. */
} erreur;


/*!
** Types de cases
*/
typedef enum case_type {
  VIDE, /* <- Case vide */
  TUYAU, /* <- Case contenant un tuyau */
  SUPER_TUYAU, /* <- Case contenant un Super Tuyau™ */
  DEBRIS, /* <- Case contenant des débris à déblayer */
  PULSAR, /* <- Case contenant un pulsar */
  BASE, /* <- Case appartenant à une base d'un des joueurs */
  INTERDIT, /* <- Case où aucune action n'est possible */
} case_type;


struct position;
struct pulsar_info;

typedef struct position_array {
  struct position* datas;
  size_t length;
} position_array;

/*!
** Position sur la carte, donnée par deux coordonnées.
*/
typedef struct position {
  int x;  /* <- Coordonnée en X */
  int y;  /* <- Coordonnée en Y */
} position;


/*!
** Représente un pulsar existant.
*/
typedef struct pulsar_info {
  int periode;  /* <- Période de pulsation du pulsar */
  double puissance;  /* <- Quantité de plasma émise par chaque pulsation dans chaque direction */
  int pulsations_restantes;  /* <- Nombre de pulsations restantes */
  int pulsations_totales;  /* <- Nombre total de pulsations au début de la partie */
} pulsar_info;


/*!
** Construit un tuyau sur une case donnée.
*/
erreur construire(position pos);

/*!
** Améliore un tuyau en Super Tuyau™.
*/
erreur ameliorer(position pos);

/*!
** Détruit un tuyau sur une case donnée.
*/
erreur detruire(position pos);

/*!
** Déplace une unité de puissance d'aspiration d'une case de votre base vers une autre.
*/
erreur deplacer_aspiration(position source, position destination);

/*!
** Déblaye une case de débris.
*/
erreur deblayer(position pos);

/*!
** Renvoie le type d'une case donnée.
*/
case_type type_case(position pos);

/*!
** Renvoie la liste de tous les pulsars présents.
*/
position_array liste_pulsars(void);

/*!
** Renvoie la liste des cases contenant du plasma.
*/
position_array liste_plasmas(void);

/*!
** Renvoie la liste des cases contenant un tuyau ou Super Tuyau™.
*/
position_array liste_tuyaux(void);

/*!
** Renvoie la liste des cases contenant un Super Tuyau™.
*/
position_array liste_super_tuyaux(void);

/*!
** Renvoie la liste des cases contenant des débris.
*/
position_array liste_debris(void);

/*!
** Renvoie vrai si et seulement si la case contient un pulsar.
*/
bool est_pulsar(position pos);

/*!
** Renvoie vrai si et seulement si la case contient un tuyau ou un Super Tuyau™.
*/
bool est_tuyau(position pos);

/*!
** Renvoie vrai si et seulement si la case contient un simple tuyau.
*/
bool est_simple_tuyau(position pos);

/*!
** Renvoie vrai si et seulement si la case contient un Super Tuyau™.
*/
bool est_super_tuyau(position pos);

/*!
** Renvoie vrai si et seulement si la case contient un débris.
*/
bool est_debris(position pos);

/*!
** Renvoie vrai si et seulement s'il est possible de construire sur cette case.
*/
bool est_libre(position pos);

/*!
** Renvoie les informations propres au pulsar à la position donnée.
*/
pulsar_info info_pulsar(position pos);

/*!
** Renvoie la quantité de plasma sur une case donnée.
*/
double charges_presentes(position pos);

/*!
** Renvoie le numéro du joueur ayant dernièrement construit ou amélioré un tuyau sur une case.
*/
int constructeur_tuyau(position pos);

/*!
** Renvoie le numéro du propriétaire d'une case de base.
*/
int proprietaire_base(position pos);

/*!
** Renvoie la liste des cases composant votre base.
*/
position_array ma_base(void);

/*!
** Renvoie la liste des cases composant la base de votre ennemi.
*/
position_array base_ennemie(void);

/*!
** Renvoie la puissance d'aspiration d'une case de base donnée. Renvoie -1 si la position n'est pas celle d'une base.
*/
int puissance_aspiration(position pos);

/*!
** Renvoie pour une case donnée la liste des cases vers lesquelles le plasma se propagera. Renvoie la liste vide si la case n'est pas une case contenant un tuyau ou si elle n'est reliée à aucune base.
*/
position_array directions_plasma(position pos);

/*!
** Renvoie la valeur du coût de la prochaine modification de vos puissances d'aspiration.
*/
int cout_prochaine_modification_aspiration(void);

/*!
** Renvoie la liste des tuyaux construits par votre adversaire au dernier tour.
*/
position_array hist_tuyaux_construits(void);

/*!
** Renvoie la liste des tuyaux détruits par votre adversaire au dernier tour.
*/
position_array hist_tuyaux_detruits(void);

/*!
** Renvoie la liste des tuyaux améliorés par votre adversaire au dernier tour.
*/
position_array hist_tuyaux_ameliores(void);

/*!
** Renvoie la liste des débris déblayés par votre adversaire au dernier tour.
*/
position_array hist_debris_deblayes(void);

/*!
** Renvoie la liste des cases de base de votre adversaire qui ont reçu un point d'aspiration (une même case peut apparaître plusieurs fois).
*/
position_array hist_points_aspiration_ajoutes(void);

/*!
** Renvoie la liste des cases de base de votre adversaire qui ont perdu un point d'aspiration (une même case peut apparaître plusieurs fois).
*/
position_array hist_points_aspiration_retires(void);

/*!
** Renvoie votre numéro de joueur.
*/
int moi(void);

/*!
** Renvoie le numéro de votre adversaire.
*/
int adversaire(void);

/*!
** Indique votre nombre de points d'actions restants pour ce tour-ci.
*/
int points_action(void);

/*!
** Renvoie le score du joueur désigné par le numéro ``id_joueur``. Renvoie -1 si ``id_joueur`` est invalide.
*/
int score(int id_joueur);

/*!
** Renvoie le numéro du tour actuel.
*/
int tour_actuel(void);

/*!
** Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
*/
bool annuler(void);

/*!
** Affiche le contenu d'une valeur de type erreur
*/
void afficher_erreur(erreur v);

/*!
** Affiche le contenu d'une valeur de type case_type
*/
void afficher_case_type(case_type v);

/*!
** Affiche le contenu d'une valeur de type position
*/
void afficher_position(position v);

/*!
** Affiche le contenu d'une valeur de type pulsar_info
*/
void afficher_pulsar_info(pulsar_info v);

/*!
** Fonction appelée au début de la partie.
*/
void partie_init(void);

/*!
** Fonction appelée à chaque tour.
*/
void jouer_tour(void);

/*!
** Fonction appelée à la fin de la partie.
*/
void partie_fin(void);

