"""
	L'ASTUCCCCCCCCCCE ! Voici un fichier qui s'est avéré très pratique.
	Il défini des masques qui sont utilisés pour parcourir des cases placées relativements à une autre.
	Un paterne sera toujours appliqué avec pour centre une case passée en paramètre
"""

from api import *
import map

# Blinde une base
protection_base = [[1,1,1,1,1],
				   [1,0,1,0,1],
				   [1,1,1,1,1],
				   [1,0,1,0,1],
				   [1,1,1,1,1]]

# Entoure un pulsar (c'est pas optimal, mais telement rapide à implémenter)
contourner = [[1,1,1],
			  [1,0,1],
			  [0,1,1]]

# Il est mal nomé, fait le tours
protection_tuyau = [[1,1,1],
					[1,0,1],
					[1,1,1]]

# Les cases adjacentes
adjacents = [[0,1,0],
			 [1,0,1],
			 [0,1,0]]

### Les cases à remplir pour blinder le tuyau en fonction de la direction (g:gauche, h:haut, etc ...)
doublage_gb = [[0,0,0],
			   [1,0,0],
			   [1,1,0]]
			   
doublage_gh = [[1,1,0],
			   [1,0,0],
			   [0,0,0]]
			   
doublage_db = [[0,0,0],
			   [0,0,1],
			   [0,1,1]]
			   
doublage_dh = [[0,1,1],
			   [0,0,1],
			   [0,0,0]]


def direction(pos, direction) :
	""" Retourne le paterne adapté dans doublage_* en fonction de la direction de déplacement
	"""
	i,j = pos
	x,y = direction
	
	if x > i and y > j :
		return doublage_dh
	elif x > i :
		return doublage_db
	elif x < i and y > j :
		return doublage_gh
	else :
		return doublage_gb

def membres(case, paterne) :
	""" Retourne la liste des cases concernées par le masque
	"""
	x, y = case
	n = len(paterne)
	retour = []
	for i in range(n) :
		for j in range(n) :
			if paterne[i][j] == 1 and map.dans_map((i,j)) :
				retour.append((x+i-(n//2), y+j-(n//2)))
	return retour

def appliquer(case, paterne) :
	""" Construit à l'emplacement des 1 dans le paterne """
	for pos in membres(case, paterne) :
		construire(pos)

