"""
	Permet l'organisation des bases
"""

from api import *

import map
import reseau

############### 

class joueur(IntEnum) :
	moi = 0
	lui = 1

############### Organisation des bases ###############

def arranger() :
	### Déplace un point d'aspiration pour le rentabiliser
	op = carrying()
	kev = kevin()
	deplacer_aspiration(kev, op)

def voisines(pos) :
	### Retourne les bases voisines d'une position
	return [ i for i in map.voisins(pos) if type_case(i) == case_type.BASE ]

def connectee(base) :
	### Retourne la position d'un eventuel tuyau, None sinon
	x, y = base
	retour = None
	for X in [ (x+1,y), (x-1,y), (x,y+1), (x,y-1) ] :
		if type_case(X) == case_type.TUYAU :
			retour = X
	return retour

def valeur(base) :
	### Quantifie l'interet porté à une base
	tuyau = connectee(base)
	if tuyau is None :
		return 0
	else :
		return 1 + charges_presentes(tuyau) + reseau.stockage_tuyau(tuyau) / 10 # TODO

def carrying() :
	### SELECTIONNE LE CHARISME
	# Correspond à la base la plus intérressante
	max = 0
	pos = ma_base()[len(ma_base()) // 4] # Par défault on prend le milieu
	for base in ma_base() :
		if valeur(base) > max and puissance_aspiration(base) < LIMITE_ASPIRATION :
			max = valeur(base)
			pos = base
	return pos
	
def kevin() :
	### SELECTIONNE LE KEVIN
	# Correspond à la base la moins intérressante
	
	min = float('inf')
	pos = ma_base()[0]
	for base in ma_base() :
		if valeur(base) < min and puissance_aspiration(base) > 0 :
			min = valeur(base)
			pos = base
	return pos

