from enum import IntEnum

from api import *
import map as map
import patern as pat
import constantes as cst
import reseau
import bases

class action(IntEnum) :
	capturer = 0
	proteger = 1
	rapprocher = 2
	casser = 3

class evenement() :
	def __init__(self, pos, act = None) :
		self.pos = pos
		self.type = None
		
		if act is None : # on recherche auto
			# CAPTURE
			if type_case(self.pos) == case_type.PULSAR :
				if reseau.eloignement_pulsar(self.pos, bases.joueur.lui) >= reseau.eloignement_pulsar(self.pos, bases.joueur.moi) :
					self.type = action.capturer
					
			elif est_tuyau(self.pos) and map.tuyau_isole(self.pos) and reseau.son_tuyau(self.pos) :
				self.type = action.casser

			# RAPPROCHER
			elif est_tuyau(self.pos) :
				self.type = action.rapprocher
				
			
		else :
			self.type = act
		
		self.rentabilite = self.nv_rentabilite()
		
	
	def nv_rentabilite(self) :
		self.rentabilite = 0
		
		if self.type == action.capturer :
			pulsar = info_pulsar( self.pos )
			dist = map.distance(self.pos, map.proche_depart(self.pos))
			self.rentabilite = ( pulsar.puissance * pulsar.pulsations_restantes ) / ( pulsar.periode * dist * COUT_CONSTRUCTION )
			return self.rentabilite
		
		elif self.type == action.proteger :
			self.rentabilite = cst.NB_DESTRUCTIONS * cst.INQUIETUDE_DESTRUCTION
		
		elif self.type == action.rapprocher :
			x, y = self.pos
			if reseau.dist_base_proche(self.pos) > reseau.dist_lui[x][y] or ( reseau.dist_moi[x][y] == float('inf') and reseau.dist_lui[x][y] == float('inf') ):
				self.rentabilite = 0
			else :
				cible = reseau.attirant_depart(self.pos)
				dist = map.distance(self.pos, cible)
				eloignement = 20 if reseau.dist_moi[x][y] == float('inf') else reseau.dist_moi[x][y]
				
				if dist > 0 :
					rapport = eloignement / dist
					self.rentabilite = rapport / 6
					
		elif self.type == action.casser :
			self.rentabilite = map.stockage_tuyau(self.pos) / 3
			
		return self.rentabilite
	
	def executer(self) :
		###### CAPTURE ######
		if self.type == action.capturer :
			flux = map.proche_depart(self.pos)
			while points_action() > 0 and not flux is None and self.pos != flux :
				construire(flux)
				flux = map.aller_vers(flux, self.pos)
			pat.appliquer(self.pos, pat.contourner)
			
		###### RAPPROCHER ######
		elif self.type == action.rapprocher :
			x, y = self.pos
			flux = self.pos
			cible = reseau.attirant_depart(self.pos)
			while points_action() > 0 and not flux is None and cible != flux :
				construire(flux)
				flux = map.aller_vers(flux, cible)
			
		###### PROTECTION ######
		elif self.type == action.proteger :
			pat.appliquer(self.pos, pat.protection_base)
			
		###### CASSAGE ######
		elif self.type == action.casser :
			detruire(self.pos)
			

###### Gestion d'une liste d'evenements ######

def lister() :
	retour = []
	for i in range(0, TAILLE_TERRAIN) :
		for j in range(0, TAILLE_TERRAIN) :
			inserer(retour, evenement((i, j)))
	
	for base in ma_base() :
		inserer(retour, evenement(base , action.proteger))
		
	return retour

def inserer(liste, evenement) :
	if evenement.rentabilite > 0 :
		x = len(liste)
		while x > 0 and liste[x-1].rentabilite > evenement.rentabilite :
			x -= 1
		liste.insert(x, evenement)

