"""
====== Explication de la structure ======

	# Approche
	Le programme initialise à chaque tour une liste d'évenements qu'il sait traiter.
	On évalue numériquement un intéret à chaque évenement, et on stocke les évenements en sorte qu'ils restent dans l'ordre (au final, un tri insertion a été effectué).
	On dépile les évenements jusqu'à ne plus avoir de points d'actions.

	## Interprétation du réseau
	Un parcours en largeur partant de ma base et celle de l'adversaire est effectuée au début des tours.
	Elle permet de calculer l'influence de l'aspiration sur une case pour chaque joueur.
	Avec ces données on décide si une case doit être rapproché de notre base, si le tuyau nous est favorable, etc ...

	## Les évenements
	 - Capturer : partir à la conquête des **pulsars non-exploités**
	 - Rapprocher : rapproche une portion de la carte **pour la sécuriser ou la voler à l'adversaire**
	 - Casser : détruire **un tuyau important** dans le réseau ennemi

	## Gestion de la base
	On répartis les points d'aspirations en sorte que les tuyaux recevant un flux soient privilégiés.
	
	=> Juste pour l'auto-satisfaction : le fichier 'patern.py' est court est marrant, ca vaut le coup d'y jeter un oeuil
"""

from api import *
from time import time

import map as map
import event as even
import bases as base
import reseau as reseau
import patern as pat

# Fonction appelée au début de la partie.
def partie_init():
	# Place ton code ici
	pass

# Fonction appelée à chaque tour.
def jouer_tour():

	debut = time()

	##### Force la réparation de certains types de cassage (désuet mais peut aider) #####
	for debrit in hist_tuyaux_detruits() :
		nb_debrits = 0
		for pos in pat.membres(debrit, pat.protection_tuyau) :
			nb_debrits += 1 if type_case(pos) == case_type.DEBRIS else 0
		
		if len(base.voisines(debrit)) > 0 : # Si c'est adjacent à une base on fait un crabe (
			pat.appliquer(debrit, pat.protection_tuyau)
		
		elif nb_debrits >= 1 :
			pat.appliquer(debrit, pat.protection_tuyau)
		
		elif nb_debrits >= 2 :
			deblayer(debrit)
			construire(debrit)
		
	##### Le coeur du programme #####
		
	reseau.calculer_distances()
	map.cases_connectees = ma_base() + [ (x,y) for (x,y) in liste_tuyaux() if reseau.dist_moi[x][y] < float('inf') ]
	
	evenements = even.lister() # On récupère les évenements
	
	print(str(len(evenements)) + " evenements")
	for i in range(1, min(10, len(evenements)+1)) :
		msg = " - "
		msg += str(evenements[-i].type) + " : "
		msg += str(evenements[-i].pos) + " = "
		msg += str(evenements[-i].rentabilite)
		print(msg)
	print('distances max : ' + str(reseau.ecart_max))
	
	# Execution des actions
	while points_action() > 0 and len(evenements) > 0 :
		evenements.pop().executer()
	base.arranger()

	print("Temps d'execution : ", time() - debut, "s")

# Fonction appelée à la fin de la partie.
def partie_fin():
	# Place ton code ici
	pass

