"""
	Analyse la structure de tuyaux créée
	C'est un peu le grand frère plus recherché de 'map.py'
	Est plus centré sur l'aspiration qu'une propagation rapide (les deux servent pour des phases de jeu différentes)
""" 

from api import *
from enum import IntEnum

import patern as pat
import map
import bases


# Contient la distance en terme d'aspiration que j'exerce sur dist_lui[i][j]
# Si la case n'est pas reliée à une base, vaut float('inf')
dist_lui =  None
dist_moi = None # Pareil pour l'adversaire
ecart_max = None # Contient le plus grand écart 

############### Calcul de l'alignement des tuyaux ###############

def calculer_distances() :
	""" Met à jours les variables dist_* en parcourant les tuyaux en largeur, partant de chaque base
	"""
	global dist_lui, dist_moi, ecart_max
	dist_moi = [[ float("inf") for i in range(TAILLE_TERRAIN) ] for j in range(TAILLE_TERRAIN) ]
	dist_lui = [[ float("inf") for i in range(TAILLE_TERRAIN) ] for j in range(TAILLE_TERRAIN) ]
	
	moi, moi_next = [], []
	lui, lui_next = [], []
	for profondeur in range(-LIMITE_ASPIRATION, TAILLE_TERRAIN**2) :
		moi += [ base for base in ma_base() if puissance_aspiration(base) == -profondeur ]
		lui += [ base for base in base_ennemie() if puissance_aspiration(base) == -profondeur ]
		
		for (x, y) in moi :
			if dist_moi[x][y] == float("inf") :
				dist_moi[x][y] = profondeur
				for next in pat.membres((x, y), pat.adjacents) :
					if est_tuyau(next) :
						moi_next.append(next)
		
		for (x, y) in lui :
			if dist_lui[x][y] == float("inf") :
				dist_lui[x][y] = profondeur
				for next in pat.membres((x, y), pat.adjacents) :
					if est_tuyau(next) :
						lui_next.append(next)
						
		moi = moi_next[:]
		lui = lui_next[:]
		moi_next = [ base for base in ma_base() if puissance_aspiration(base) == profondeur ]
		lui_next = [ base for base in base_ennemie() if puissance_aspiration(base) == profondeur ]
	
	ecart_max = calculer_ecart()

def eloignement_pulsar(pos, j) :
	"""	Pour un pulsar donnée donne la plus petit distance en partant des cases adjacentes
	"""
	retour = float("inf")
	for (x,y) in pat.membres(pos, pat.adjacents) :
		if j != bases.joueur.lui :
			retour = min(retour, dist_moi[x][y])
		if j != bases.joueur.moi :
			retour = min(retour, dist_lui[x][y])
	return retour

def attirant_depart(A) :
	""" Cherche l'endroit où il est le plus interressant de relier pour optimiser l'aspiration
	"""
	cases_connectees = liste_tuyaux() + [ pos for pos in ma_base() if not est_debris(pos) ]
	retour = A
	min = dist_moi[A[0]][A[1]]
	for (x,y) in cases_connectees :
		if map.distance(A, (x,y)) + dist_moi[x][y] < min :
			min = map.distance(A, (x,y)) + dist_moi[x][y]
			retour = (x,y)
	return retour
	
def mon_tuyau(pos) :
	""" Retourne True si ce tuyau m'avantage
	"""
	x, y = pos
	return dist_lui[x][y] >= dist_moi[x][y]

def son_tuyau(pos) :
	""" Retourne True si ce tuyau avantage l'autre
	"""
	x, y = pos
	return dist_lui[x][y] <= dist_moi[x][y]
	
################# Calculs des interets ##################

def calculer_ecart() :
	""" Calcule l'écart de distance sur une case
	"""
	retour = 0
	for x in range(TAILLE_TERRAIN) :
		for y in range(TAILLE_TERRAIN) :
			if dist_moi[x][y] < float('inf') and type_case((x, y)) != case_type.BASE :
				dist_base = map.distance((x,y), map.proche_base((x,y)))
				retour = max(retour, abs(dist_moi[x][y]))
	return retour

def dist_attirant_proche(A) :
	return map.dist(A, attirant_depart(A))

def dist_base_proche(A) :
	""" Retourne la distance en terme d'aspiration de la map la plus proche
	"""
	x,y = attirant_depart(A)
	return map.distance(A,(x,y)) + dist_moi[x][y]

def stockage_tuyau(pos, ignorer = True) :
	""" Retourne une valeur typique du plasma stocké EN AMONT du tuyau
	"""
	if not map.tuyau_isole(pos):
		return 0
	
	retour = 0 if ignorer else charges_presentes(pos)
	x, y  = pos
	for i, j in pat.membres(pos, pat.adjacents) :
		if est_tuyau((i,j)) and dist_lui[x][y] < dist_lui[i][j] :
			retour += stockage_tuyau((i,j), False)
	return retour


