"""
	Fonctions relatives à l'analyse de la map 
"""

from api import *
import patern as pat

cases_connectees = [] # Penser à l'autre

############### Analyse des cases ###############

def tuyau_isole(pos) :
	c = 0
	for A in pat.membres(pos, pat.adjacents) :
		if est_tuyau(A) :
			c += 1
	return c <= 2

def voisins(A) :
	x, y = A
	retour = []
	for i in range(x-1, x+2) :
		for j in range(y-1, y+2) :
			if x >= 0 and y >= 0 and x < TAILLE_TERRAIN and y < TAILLE_TERRAIN :
				retour.append( (i,j) )
	return retour

def est_voisin_pulsar(A) :
	retour = False 
	for pos in pat.membres(A, pat.adjacents) :
		retour = retour or est_pulsar(pos)
	return retour

def dans_map(pos) :
	x, y = pos
	return x >= 0 and y >= 0 and x < TAILLE_TERRAIN and y < TAILLE_TERRAIN

def forcer_doublage() :
	""" Retourne true si on n'a pas encore atteind une zone active
	    Le cas échéant on cherchera à doubler le tuyau pour proteger des destructions
	"""
	for tuyau in liste_tuyaux():
		if constructeur_tuyau(tuyau) == moi() and est_voisin_pulsar(tuyau) :
			return False
	return True

############### Distances ###############

def distance(A, B) :
	xa, ya = A
	xb, yb = B
	return abs(xa-xb) + abs(ya-yb)

def dist_base_proche(pos) :
	return distance(pos, proche_base(pos))

############### Déplacement ###############

def aller_vers(A, B) :
	for choix in direction(A, B) :
		if type_case(choix) in [case_type.TUYAU, case_type.SUPER_TUYAU, case_type.VIDE, case_type.BASE] :
			return choix
	return None

def direction(A, B) :
	""" Donne les directions logiques pour aller de A à B """
	(xa, ya), (xb, yb) = A, B
	
	suivant_x = (xa+1, ya) if xb > xa else (xa-1, ya)
	suivant_y = (xa, ya+1) if yb > ya else (xa, ya-1)
	
	if A == B :
		return []
	elif xa == xb :
		return [suivant_y]
	elif ya == yb :
		return [suivant_x]
	else :
		return [suivant_x, suivant_y]

def proche_depart(A) :
	""" Trouve une case connectée proche à vol d'oiseau
	"""
	global cases_connectees
	retour = cases_connectees[0]
	min = float('inf')
	for B in cases_connectees :
		if distance(A, B) < min :
			retour = B
			min = distance(A, B)
	return retour

def proche_base(A) :
	""" Trouve la base la plus proche à vol d'oiseau
	"""
	retour = ma_base()[0]
	min = float('inf')
	for B in ma_base() :
		if distance(A, B) < min :
			retour = B
			min = distance(A, B)
	return retour

