from api import *

def toutLier() :
    """Relie tout ce qui est possible a la case actuelle"""
    for portail in liste_portails() :
        if portail_joueur(portail) == moi() :
            lier(portail)

def lien_possible(posa, posb) :
    return len(liens_bloquants(posa, posb)) == 0

def portailsReliables(position) :
    """Retourne la liste des portails reliables a un portail donne
     -> prend en compte les liens existants
    """
    retour = []
    for portail in liste_portails() :
        if portail_joueur(portail) == moi() :
            if lien_possible(position, portail) :
                retour += [ portail ]
    return retour
            
def gainAire(position) :
    """Donne l'aire totale qui sera recuperee a l'acquisition de la case et/ou apres l'avoir reliee
    /!\ Fonction couteuse
    """
    if case_dans_champ(position) : # A prioris on ne peut pas le recuperer directement
        return 0
    
    def nvxTriangles() :
        points = portailsReliables(position)
        retour = []
        for seg in liste_liens() :
            if portail_joueur(seg[0]) == moi() and lien_possible(seg[0], position) and lien_possible(seg[1], position) :
                retour += [ seg ]
        return retour
    retour = 0
    for triangle in nvxTriangles() :
        retour += score_triangle( triangle[0], triangle[1], position )
    return retour

def scorePortail(portail) :
    """Retourne le score total que le portail apporte"""
    total = 0
    for champ in champs_incidents_portail(portail) :
        total += score_triangle(champ[0], champ[1], champ[2])
    return total