# -*- coding: utf-8 -*-
# DONE : Mode triso
# OSEF : Estimer le cout pour relier
# TODO : Position des boucliers en fonction de l'operateur adverse
# DONE : Utiliser les boosts / se deplacer a la fin des tours
# TODO : Eviter de faire converger les points sur un seul portail
# TODO : Ajouter une partie des points de capture a la neutralisation\
# DONE : URGENT : La gestion des points isoles pue (avec la gestion des points seuls)
# DONE : S'optimiser pour les grosses cartes
# TODO TODO TODO : regler les CONSTANTES
# TODO : Gerer les convergeances (regarder historique ?)
# TODO : Detruire le segment le plus casse - couilles
# TODO : Readme

from math import ceil

from api import *
from action import *
from deplacement import *

PA_GACHES = 0
PM_GACHES = 0

MAX_ACTION_CRITIQUE = 30 # Le nombre d'actions en mode critique
DEPASSEMENT_CRITIQUE = 150 # Le depassement qui enclanche le mode critique
NB_DEPASSEMENTS = 5 # Compte a rebour avant l'activation du mode critique

# Fonction appelée au début de la partie.
def partie_init():
    print("Game commencee - id du joueur : " + str(moi()))

# Fonction appelée à chaque tour.
def jouer_tour() :
    global PA_GACHES
    global PM_GACHES
    global NB_DEPASSEMENTS
    
    print("---------- Choix d'actions ---------- " + str(tour_actuel()))
    actions = listerActions()
    if(len(liste_portails()) > 40) :
        actions = filtrer_actions(actions) # On elimine le gros des actions
    
    ### CLEAN BOURRIN DES ACTIONS
    if len(actions) > DEPASSEMENT_CRITIQUE :
        if NB_DEPASSEMENTS > 0 :
            NB_DEPASSEMENTS -= 1
        else :
            nb_actions = min(MAX_ACTION_CRITIQUE, len(actions)) # le nombre d'actions ideal
            pas = ceil( len(actions) / nb_actions )
            actions = actions[::pas]
            print("/!\ Le nombre d'actions a ete divise par " + str(pas))
    ###
    
    worths = worth_of_actions(actions)
    print("Nombre d'actions a traiter : " + str(len(actions)))
    serieAction = 1 # Le nombre de fois qu'on a fait la meme action d'affile
    while len(worths) > 0 and points_action() > 0 :
        toutLier() # On lie tout comme des gros porcs
        choix = worths[0]
        action = choix[1]
        
        gain_a = gain(action)
        nouvellesActions = do_action(action)
        
        print(" - " + string_of_action(action) + " | gain: " + str(gain_a)[:4] + " | " + str(points_action()) + "pa ; " + str(points_deplacement()) + "pm" )
        
        del worths[0] # Supprime l'action precedente
        actions = actions_of_worth(worths) + nouvellesActions # On etablie la nouvelle liste d'actions
        actions = filtrer_actions(actions)
        worths = worth_of_actions(actions)
        
    PA_GACHES += points_action()
    PM_GACHES += points_deplacement()
    
# Fonction appelée à la fin de la partie.
def partie_fin():
    print("---------- Rapport final ----------")
    print(str(PA_GACHES) + " points d'actions gaches (" + str(PA_GACHES/NB_TOURS)[:4] + "/tours)")
    print(str(PM_GACHES) + " points de mouvement gaches (" + str(PM_GACHES/NB_TOURS)[:4] + "/tours)")
    print(str(compteur_turbos()) + " turbos utilises (" + str(compteur_turbos()/NB_TOURS)[:4] + "/tours)")
    print("-----------------------------------")