from api import *

# formats d'actions :
# { "type" : "capture", "position" : pos }

def listerActions() :
    actions = []
    # liste des portails
    for portail in liste_portails() :
        if( portail_joueur(portail) == -1 ) :
            actions += [ { "type" : "capture", "position" : portail } ]
    return actions

def gain(action) :
    """Quantifie l'apport d'une action"""
    if( action["type"] == "capture" ) :
        return POINTS_CAPTURE
    
def coutAction(action) :
    """Retourne le cout de l'action"""
    cout = 0
    if( action["type"] == "capture" ) :
         cout += COUT_CAPTURE

def coupDeplacement(position) :
    """Calcul de cout du deplacement de la case actuelle vers la position donnee
       2 * mouvements + le cout en turbo"""
    dist = distance( position_agent(moi()), position )
    cout = min(dist, points_deplacement())
    cout = 2*cout + (dist-cout)*COUT_BOUCLIER
    return cout
