# -*- coding: utf-8 -*-

from api import *

pos_artifact = 15
#tower_goals = [(pos_artifact-1, pos_artifact), (pos_artifact, pos_artifact+1), (pos_artifact, pos_artifact-1), (pos_artifact+1, pos_artifact), (0, pos_artifact+1), (0, pos_artifact-1), (1, pos_artifact), (TAILLE_TERRAIN-1, pos_artifact+1), (TAILLE_TERRAIN-1, pos_artifact-1), (TAILLE_TERRAIN-2, pos_artifact)]
sorcier_goals = [[(pos_artifact, pos_artifact), 1/5, 0], [(0, pos_artifact), 1/5, 0], [(pos_artifact, 0), 1/5, 0], [(TAILLE_TERRAIN-1, pos_artifact), 1/5, 0], [(pos_artifact, TAILLE_TERRAIN-1), 1/5, 0]]

defense_patterns = ((	(0,1,1),
			(1,1,1),
			(1,1,0)	),

		(	(0,1,1),
			(1,1,0),
			(1,0,0)	),

		(	(0,1,0),
			(1,1,0),
			(0,0,0)	),

		(	(0,1,0),
			(1,0,0),
			(0,0,0)	),

		(	(0,0,0),
			(1,0,0),
			(0,0,0)	),

		(	(0,0,0),
			(0,0,0),
			(0,0,0)))

def sorciers_joueur(joueur) :
	sorciers = []
	for i in range(TAILLE_TERRAIN):
		for j in range(TAILLE_TERRAIN):
			sorcier = nb_sorciers((i,j), joueur)
			if sorcier > 0 :
				sorciers.append([(i,j), sorcier])
	return sorciers

def sorciers_deplacables_joueur(joueur) :
	sorciers = []
	for i in range(TAILLE_TERRAIN):
		for j in range(TAILLE_TERRAIN):
			sorcier = nb_sorciers_deplacables((i,j), joueur)
			if sorcier > 0 :
				sorciers.append([(i,j), sorcier])
	return sorciers

def distancee(pos1, pos2) :
	return abs(pos1[0]-pos2[0]) + abs(pos1[1]-pos2[1])

# Fonction appelée au début de la partie
def partie_debut():
	global last_tower_pos
	last_tower_pos = base_joueur(moi())

def nearest_goal_tower_cmp(goal) :
	global last_tower_pos
	return distancee(last_tower_pos, goal)

def nearest_goal_sorcier_cmp(goal) :
	return goal[0]

def defcon() :
	global defense_patterns
	distances = []
	for adversaire in adversaires() :
		if adversaire != moi():
			for sorcier in sorciers_joueur(adversaire) :
				distances.append(int(distancee(base_joueur(moi()), sorcier[0])/PORTEE_SORCIER)+1)
	if len(distances) <= 0 :
		return len(defense_patterns)
	else : return min(distances)

def apply_pattern(pattern) :
	base = base_joueur(moi())
	for i in range(len(pattern)-1):
		for j in range(len(pattern[i])-1):
			if pattern[i][j] != 0 :
				construire((base[0] + i, base[1] + j), PORTEE_TOURELLE)
				construire((base[0] + i, base[1] - j), PORTEE_TOURELLE)
				construire((base[0] - i, base[1] + j), PORTEE_TOURELLE)
				construire((base[0] - i, base[1] - j), PORTEE_TOURELLE)
			else :
				supprimer((base[0] + i, base[1] + j))
				supprimer((base[0] + i, base[1] - j))
				supprimer((base[0] - i, base[1] + j))
				supprimer((base[0] - i, base[1] - j))
	

def phase_construction() :
	global defense_patterns
	
	apply_pattern(defense_patterns[min((defcon(), len(defense_patterns)-1))])
	
	#if moi() != 1 : return
	#global tower_goals
	#global last_tower_pos

	#tower_goals_now = []

	#for i in tower_goals :
	#       if info_case(i) == case_info.CASE_SIMPLE :
	#               if distancee(last_tower_pos, i) < PORTEE_TOURELLE-1 :
	#                       if constructible(i, moi()) :
	#                               tower_goals_now.append(i)
	#               else : 
	#                       tower_goals_now.append(i)

	#distances = []
	#goal = min(tower_goals_now, key=nearest_goal_tower_cmp)        for sorcier in sorciers :

	#chemine = chemin(last_tower_pos, goal)
	#for i in range(len(chemine)-1, 0, -1) :
	#       if construire(chemine[i], PORTEE_TOURELLE) == erreur.OK : 
	#               last_tower_pos = chemine[i]
	#               break
	creer(int(magie(moi())/COUT_SORCIER))

def nearest_sorcier_cmp (sorcier) :
	return sorcier[2][0][0]

def degats(pos) :
	acc = 0
	for adversaire in adversaires() :
		if adversaire != moi() :
			for tourelle in tourelles_joueur(adversaire) :
				if distancee(pos, tourelle.pos) <= tourelle.portee :
					acc += tourelle.attaque
	return acc

# Fonction appelée pendant la phase de déplacement
def phase_deplacement():
	#if moi() != 1 : return
	global pos_artifact
	global sorcier_goals
	sorciers = sorciers_joueur(moi())
	total = 0
	
	
	for i in range(len(sorcier_goals)-1) :
		sorciers_adverses = 0
		for adversaire in adversaires() :
			if adversaire != moi() :
				sorciers_adverses += nb_sorciers(sorcier_goals[i][0], adversaire)

		sorcier_goals[i][2] = nb_sorciers(sorcier_goals[i][0], moi()) - sorciers_adverses

	for sorcier in sorciers :
		total += sorcier[1]
		sorcier.append([])
		
		for j in range(len(sorcier_goals)) :
			sorcier[2].append((distancee(sorcier[0], sorcier_goals[j][0]), j))
		sorcier[2].sort(key=nearest_goal_sorcier_cmp)

	sorciers.sort(key=nearest_sorcier_cmp)

	for sorcier in sorciers :
		for goal in sorcier[2]:
			if nb_sorciers_deplacables(sorcier[0], moi()) <= 0 :
				break
			
			if sorcier_goals[goal[1]][2] <= sorcier_goals[goal[1]][1]*total :
				chemine = chemin(sorcier[0], sorcier_goals[goal[1]][0])
	
				print(str(nb_sorciers_deplacables(sorcier[0], moi())) + " sorciers left " + " Want " + str(int(sorcier_goals[goal[1]][1]*total)) + " In " + str(goal[1]) + " Already sent " + str(sorcier_goals[goal[1]][2]))
				
				sending = int(min(nb_sorciers_deplacables(sorcier[0], moi()), int(sorcier_goals[goal[1]][1]*total)-sorcier_goals[goal[1]][2]))
				
				if sorcier[2][0][0] <= 0 :
					sending = min(sending, int(max(0, nb_sorciers(sorcier[0], moi()) - sorcier_goals[sorcier[2][0][1]][1]*total)))

				
				for i in range(min(len(chemine), PORTEE_SORCIER)-1, -1, -1) :
					if degats(chemine[i]) >= sending :
						continue
					
					err = deplacer(sorcier[0], chemine[i], sending)
						
					if  err == erreur.OK : 
						print("OK, from " + str(sorcier[0]) + " TO " + str(chemine[i]) + "For a total of " + str(sending) + " sorciers")
						sorcier_goals[goal[1]][2] += sending
						if sorcier[2][0][0] <= 0 : 
							sorcier_goals[sorcier[2][0][1]][2] -= sending
						break
					elif err != erreur.PORTEE_INSUFFISANTE : print(err)

	sorciers_deplacables = sorciers_deplacables_joueur(moi())
	sorciers = sorciers_joueur(moi())
	
	for sorcier in sorciers :
		sorcier.append([])
		
		for j in range(len(sorcier_goals)) :
			sorcier[2].append((distancee(sorcier[0], sorcier_goals[j][0]), sorcier[0]))
		sorcier[2].sort(key=nearest_goal_sorcier_cmp)

	sorciers.sort(key=nearest_sorcier_cmp)

	
	for sorcier_deplacable in sorciers_deplacables :
		if nb_sorciers_deplacables(sorcier_deplacable[0], moi()) == nb_sorciers(sorcier_deplacable[0], moi()) :
			for sorcier in sorciers :
				if sorcier[2][0][0] >= 0 :
					chemine = chemin(sorcier_deplacable[0], sorcier[0])
					if len(chemine)-1 <= PORTEE_SORCIER and len(chemine)-1 > 0 :
						deplacer(sorcier_deplacable[0], sorcier[0], nb_sorciers_deplacables(sorcier_deplacable[0], moi()))


def sort_sorcier_tourelle_cmp(sorcier) :
	return len(sorcier[2])

# Fonction appelée pendant la phase de tirs des tourelles
def phase_tirs():
	#if moi() != 1 : return
	sorciers = []
	for adversaire in adversaires() :
		if adversaire != moi() :
			sorciers += sorciers_joueur(adversaire)

	tourelles = tourelles_joueur(moi())

	for sorcier in sorciers : 
		sorcier.append([])
		for tourelle in tourelles :
			if distancee(sorcier[0], tourelle.pos) <= tourelle.portee :
				sorcier[2].append(tourelle)
				
	sorciers.sort(key=sort_sorcier_tourelle_cmp)

	for sorcier in sorciers :
		for tourelle in sorcier[2] :
			tourelle = tourelle_case(tourelle.pos)
			tirer(min(nb_sorciers(sorcier[0], joueur_case(sorcier[0])), tourelle.attaque), tourelle.pos, sorcier[0])
	pass

# Fonction appelée pendant la phase de siège des tourelles
def phase_siege():
	autour = [(0,1), (0,-1), (1,0), (-1,0)]
	for i in sorciers_joueur(moi()) :
		for j in autour :
			assieger(i[0], (i[0][0] + j[0], i[0][1] + j[1]), min(nb_sorciers(i[0], moi()), tourelle_case((i[0][0] + j[0], i[0][1] + j[1])).vie))

# Fonction appelée à la fin de la partie
def partie_fin():
	pass